/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.naming;

import com.harrand.coreclasses.naming.INameProps;
import com.harrand.coreclasses.naming.NameProps;
import com.harrand.dbwrench.naming.IDbNameProps;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DbNameProps
implements IDbNameProps {
    private INameProps nameProps_;
    private boolean useTableName_;
    private boolean useColumnNames_;
    public static final String XML_NM = "DbNameProps";
    public static final String XML_USE_TABLE_NM = "UseTableName";
    public static final String XML_USE_COLUMN_NM = "UseColumnNames";

    public DbNameProps(String prefix, String separator, String suffix, boolean useTableName, boolean useColumnNames) {
        this.nameProps_ = new NameProps(prefix, separator, suffix);
        this.useTableName_ = useTableName;
        this.useColumnNames_ = useColumnNames;
    }

    public static DbNameProps fromXml(Element element) {
        Element elmNameProps = XmlHelper.getFirstElementByTagName(element, "NameProps");
        NameProps nameProps = NameProps.fromXml(elmNameProps);
        boolean useTableName = XmlHelper.getAttrBool(element, XML_USE_TABLE_NM);
        boolean useColNames = XmlHelper.getAttrBool(element, XML_USE_COLUMN_NM);
        DbNameProps newProps = new DbNameProps(nameProps.getPrefix(), nameProps.getSeparator(), nameProps.getSuffix(), useTableName, useColNames);
        return newProps;
    }

    public String getTableColumnsName(Table table, List columnNames) {
        return this.getTableColumnsName(table.getName(), columnNames);
    }

    public String getTableColumnsName(String tableName, List columnNames) {
        ArrayList<String> names = new ArrayList<String>();
        String sep = this.getSeparator();
        names.add(this.getPrefix());
        if (this.getUseTableName()) {
            names.add(tableName);
        }
        if (this.getUseColumnNames()) {
            for (String colName : columnNames) {
                names.add(colName);
            }
        }
        names.add(this.getSuffix());
        return DbNameProps.buildName(names, this.getSeparator());
    }

    public static String buildName(List names, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String name : names) {
            if (sb.length() > 0 && name.length() > 0) {
                sb.append(separator);
            }
            sb.append(name);
        }
        return sb.toString();
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmParent = doc.createElement(XML_NM);
        XmlHelper.setAttr(elmParent, XML_USE_TABLE_NM, this.getUseTableName());
        XmlHelper.setAttr(elmParent, XML_USE_COLUMN_NM, this.getUseColumnNames());
        Element elmNameProps = this.nameProps_.asXmlElement();
        XmlHelper.addForeignElement(doc, elmParent, elmNameProps);
        return elmParent;
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getName() {
        return XML_NM;
    }

    @Override
    public boolean getUseColumnNames() {
        return this.useColumnNames_;
    }

    @Override
    public boolean getUseTableName() {
        return this.useTableName_;
    }

    @Override
    public void setUseColumnNames(boolean use) {
        this.useColumnNames_ = use;
    }

    @Override
    public void setUseTableName(boolean use) {
        this.useTableName_ = use;
    }

    @Override
    public String getPrefix() {
        return this.nameProps_.getPrefix();
    }

    @Override
    public String getSeparator() {
        return this.nameProps_.getSeparator();
    }

    @Override
    public String getSuffix() {
        return this.nameProps_.getSuffix();
    }

    @Override
    public void setPrefix(String prefix) {
        this.nameProps_.setPrefix(prefix);
    }

    @Override
    public void setSeparator(String separator) {
        this.nameProps_.setSeparator(separator);
    }

    @Override
    public void setSuffix(String suffix) {
        this.nameProps_.setSuffix(suffix);
    }
}

