/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData.postgresql;

import com.harrand.dbwrench.object.index.ColumnFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PsqlColumnFunctionParser {
    public static final String REGEX_PATTERN = "USING.*?\\(.*$";

    public ColumnFunction parseColumnFunction(String indexDefText, String optionText, int colPosInIndex) {
        String columnFunctionText = "(ERROR extracting column function)";
        String columnsText = this.getColumnsText(indexDefText, optionText);
        String bracketsRemovedText = this.getStartEndBracketsRemoved(columnsText);
        List<String> columnTexts = this.getColumnsTexts(bracketsRemovedText);
        columnFunctionText = columnTexts.get(colPosInIndex);
        return new ColumnFunction(columnFunctionText);
    }

    private List<String> getColumnsTexts(String columnsText) {
        ArrayList<String> columnTexts = new ArrayList<String>();
        int bracketDepth = 0;
        StringBuilder sbColumnText = new StringBuilder();
        for (char ch : columnsText.toCharArray()) {
            boolean isInBrackets;
            boolean isComma = ch == ',';
            boolean isStartBracket = ch == '(';
            boolean isEndBracket = ch == ')';
            boolean bl = isInBrackets = bracketDepth < 0;
            if (isStartBracket) {
                --bracketDepth;
            }
            if (isEndBracket) {
                ++bracketDepth;
            }
            if (isComma && !isInBrackets) {
                columnTexts.add(sbColumnText.toString().trim());
                sbColumnText = new StringBuilder();
                continue;
            }
            sbColumnText.append(ch);
        }
        if (sbColumnText.length() > 0) {
            columnTexts.add(sbColumnText.toString().trim());
        }
        return columnTexts;
    }

    private String getColumnsText(String indexDefText, String optionText) {
        Pattern pattern = Pattern.compile(REGEX_PATTERN);
        Matcher matcher = pattern.matcher(indexDefText);
        String columnsText = "(Error) Could not extract columns text";
        if (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            String optionToEndText = indexDefText.substring(start, end).trim();
            columnsText = optionToEndText.replace(optionText, "");
        }
        return columnsText;
    }

    private String getStartEndBracketsRemoved(String columnsText) {
        String bracketsRemovedText = columnsText.trim().substring(1, columnsText.length() - 2);
        return bracketsRemovedText;
    }
}

