/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData.helper.psql.proc;

public class PSqlProcArgument {
    private String nm;
    private String typeStr;
    private String mode;
    public static final String IN_MODE = "i";
    public static final String INOUT_MODE = "b";
    public static final String OUT_MODE = "o";
    public static final String TABLE_MODE = "t";
    public static final String VARIADIC_MODE = "v";
    public static final String UNDEFINED_MODE = "u";
    public static final String INOUT_TEXT = "INOUT";
    public static final String IN_TEXT = "IN";
    public static final String OUT_TEXT = "OUT";
    public static final String VARIADIC_TEXT = "VARIADIC";

    public PSqlProcArgument(String nm, String typeStr, String mode) {
        this.nm = nm;
        this.typeStr = typeStr;
        this.mode = mode;
    }

    public String getModeText() {
        if (this.isModeUndefined()) {
            return "";
        }
        if (this.isInput()) {
            return IN_TEXT;
        }
        if (this.isOutput()) {
            return OUT_TEXT;
        }
        if (this.isInOut()) {
            return INOUT_TEXT;
        }
        if (this.isTableMode()) {
            return "";
        }
        if (this.isVariadic()) {
            return VARIADIC_TEXT;
        }
        return "PSqlProcArg.unknown mode";
    }

    public boolean isTableMode() {
        return this.is(TABLE_MODE);
    }

    public boolean isInput() {
        return this.is(IN_MODE);
    }

    public boolean isOutput() {
        return this.is(OUT_MODE);
    }

    public boolean isInOut() {
        return this.is(INOUT_MODE);
    }

    public boolean isVariadic() {
        return this.is(VARIADIC_MODE);
    }

    public boolean isModeUndefined() {
        return this.is(UNDEFINED_MODE);
    }

    public String getFormattedText() {
        StringBuffer sb = new StringBuffer();
        if (!this.isModeUndefined()) {
            sb.append(this.getModeText()).append(" ");
        }
        if (this.getNm() != null) {
            sb.append(this.getNm()).append(" ");
        }
        if (this.getTypeStr() != null) {
            sb.append(this.getTypeStr());
        }
        String text = sb.toString().trim();
        return text;
    }

    public String getNm() {
        return this.nm;
    }

    public String getTypeStr() {
        return this.typeStr;
    }

    private boolean is(String findMode) {
        return this.mode.equalsIgnoreCase(findMode);
    }
}

