/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.CustomTypeIdCtrl;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.JdbcMetaDataCtrl;
import com.harrand.dbwrench.metaData.helper.OracleTriggerParser;
import com.harrand.dbwrench.metaData.ignore.OracleIgnoreCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

public class OracleMetaDataCtrl
extends JdbcMetaDataCtrl {
    public static final String CREATE_OR_REPLACE_STR = "CREATE OR REPLACE";
    private IDataTypeConverter dataTypeConverter_;
    private OracleIgnoreCtrl ignoreCtrl;
    private Database newDb_;
    private HashMap<String, String> tblCmms;
    private HashMap<String, String> colCmms;
    private static final String META_CTRL_NM = "OracleMetaCtrl";
    public static final String TRG_CREATE_REPLACE_STR = "CREATE OR REPLACE\n";

    public OracleMetaDataCtrl(JdbcConfig config) {
        super(config);
        this.dataTypeConverter_ = config.getDataTypeConverter();
        this.ignoreCtrl = new OracleIgnoreCtrl(this.getConfig().getSchemaIgnoreCtrl());
    }

    @Override
    public Database reverseEngineer() throws Exception {
        this.conn_ = ConnectionFactory.getConnection(this.getConfig());
        this.getConfig().setVersion(this.getDbmsVersion());
        super.doPreRevEngTasks();
        this.newDb_ = super.createNewDb();
        this.newDb_.remove(Schema.getClassName(), "schemaA");
        this.addDbItems();
        super.doPostRevEngTasks();
        this.conn_.close();
        this.newDb_.getNotifyMgr().setEnabled(true);
        return this.newDb_;
    }

    private void addDbItems() {
        this.addSchemas();
        this.setComments();
        this.addTables();
        this.addDataTypes();
        this.addColumns();
        this.addPKs();
        if (this.isFkRevEngEnabled()) {
            this.addFKs();
        }
        if (this.isIndexRevEngEnabled()) {
            this.addIndexes();
        }
        if (this.isTriggerRevEngEnabled()) {
            this.addTriggers();
        }
        if (this.isUC_RevEngEnabled()) {
            this.addUniqueConstraints();
        }
        if (this.isSeqRevEngEnabled()) {
            this.addSeqs();
        }
        if (this.isViewRevEngEnabled()) {
            this.addViews();
        }
        if (this.isProcRevEngEnabled()) {
            this.addProcs();
        }
    }

    private void addSchemas() {
        String sql = "select USERNAME from \nSYS.ALL_USERS";
        String stepNm = "usernames";
        ResultSet rs = this.doSqlWithFilter(sql, "USERNAME", stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    String schNm = rs.getString("USERNAME");
                    Schema sch = new Schema(schNm);
                    this.newDb_.add(sch);
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private void addTables() {
        String sql = "select owner, table_name, tablespace_name \nfrom all_tables \n";
        String stepNm = "tables";
        ResultSet rs = this.doSqlWithFilter(sql, null, stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String schNm = rs.getString("owner");
                        String tblNm = rs.getString("table_name");
                        Table tbl = new Table(tblNm);
                        tbl.setUseManualSort(true);
                        String cmm = this.tblCmms.get(schNm + "." + tblNm);
                        if (cmm != null) {
                            tbl.setComment(cmm);
                        }
                        Schema sch = this.newDb_.getSchema(schNm);
                        sch.add(tbl);
                        this.notifyObserversDisp("engineer.reverse.milestone.table.added", tblNm);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private void addDataTypes() {
        String sql = "select owner, type_name, type_oid \nfrom all_types \n";
        String stepNm = "data types";
        ResultSet rs = this.doSqlWithFilter(sql, null, stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String schNm = rs.getString("owner");
                        String typeNm = rs.getString("type_name");
                        CustomType type = CustomTypeIdCtrl.instance().createCustomType(this.newDb_, typeNm, "");
                        Schema sch = this.newDb_.getSchema(schNm);
                        sch.add(type);
                        this.notifyObserversDisp("engineer.reverse.milestone.type.added", typeNm);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private void addColumns() {
        String stepNm;
        String sql = "select c.table_name, c.column_name, c.data_type, \n c.data_length, c.data_precision, c.data_scale, c.nullable, c.column_id, \n c.data_default, t.owner \nfrom all_tab_columns c \n join all_tables t \n  on c.table_name = t.table_name \n   and c.owner = t.owner \nwhere \n" + this.getSchFilterStr("c", null) + " \n" + "order by t.owner, c.table_name, c.column_id";
        ResultSet rs = this.doSql(sql, stepNm = "columns", false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String cmmRaw;
                        String defaultRaw = rs.getString("data_default");
                        String schNm = rs.getString("owner");
                        String tblNm = rs.getString("table_name");
                        String colNm = rs.getString("column_name");
                        Schema sch = this.newDb_.getSchema(schNm);
                        String typeDesc = rs.getString("data_type");
                        IDataType dataType = this.dataTypeConverter_.getDataType(this.newDb_, sch, typeDesc);
                        Integer precision = this.getNullSafeInt(rs.getString("data_precision"));
                        Integer length = dataType.isLengthUsed() ? this.getNullSafeInt(rs.getString("data_length")) : null;
                        length = this.convertUnicodeLength(dataType, length);
                        length = this.selectLengthOrPrecision(dataType, length, precision);
                        Integer scale = length != null && dataType.isScaleUsed() ? this.getNullSafeInt(rs.getString("data_scale")) : null;
                        String nullStr = rs.getString("nullable");
                        boolean nullable = nullStr.equalsIgnoreCase("Y");
                        String defaultStr = "";
                        if (defaultRaw != null) {
                            defaultStr = this.processColDefault(defaultRaw);
                        }
                        String cmm = (cmmRaw = this.colCmms.get(schNm + "." + tblNm + "." + colNm)) != null ? cmmRaw : "";
                        String constNm = null;
                        Table tbl = sch.getTable(tblNm);
                        Column col = new Column(colNm, dataType, length, nullable, false, defaultStr, scale, cmm, constNm);
                        col.setUnique(false);
                        tbl.add(col);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private Integer selectLengthOrPrecision(IDataType dataType, Integer length, Integer precision) {
        Integer lengthObj = length;
        int typeId = dataType.getId();
        if (typeId == 780 || typeId == 6) {
            lengthObj = precision;
        }
        return lengthObj;
    }

    private void setComments() {
        this.setTblCmms();
        this.setColCmms();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setTblCmms() {
        String stepNm;
        this.tblCmms = new HashMap();
        String sql = "select owner, table_name, table_type, comments \nfrom all_tab_comments \nwhere comments is not null and \n" + this.getSchFilterStr(null, null);
        ResultSet rs = this.doSql(sql, stepNm = "table comments", false);
        if (rs == null) return;
        try {
            while (true) {
                if (!rs.next()) {
                    this.close(rs);
                    return;
                }
                try {
                    String schNm = rs.getString("owner");
                    String tblNm = rs.getString("table_name");
                    String cmm = rs.getString("comments");
                    if (cmm == null) continue;
                    this.tblCmms.put(schNm + "." + tblNm, cmm);
                }
                catch (Exception e) {
                    this.processError(e, stepNm);
                }
            }
        }
        catch (Exception e) {
            this.processError(e, stepNm);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setColCmms() {
        String stepNm;
        this.colCmms = new HashMap();
        String sql = "select owner, table_name, column_name, comments \nfrom all_col_comments  \nwhere table_name NOT LIKE 'BIN$%' and \n comments is not null and \n" + this.getSchFilterStr(null, null);
        ResultSet rs = this.doSql(sql, stepNm = "column comments", false);
        if (rs == null) return;
        try {
            while (true) {
                if (!rs.next()) {
                    this.close(rs);
                    return;
                }
                try {
                    String schNm = rs.getString("owner");
                    String tblNm = rs.getString("table_name");
                    String colNm = rs.getString("column_name");
                    String cmm = rs.getString("comments");
                    if (cmm == null) continue;
                    String fqn = schNm + "." + tblNm + "." + colNm;
                    this.colCmms.put(fqn, cmm);
                }
                catch (Exception e) {
                    this.processError(e, stepNm);
                }
            }
        }
        catch (Exception e) {
            this.processError(e, stepNm);
        }
    }

    private void addPKs() {
        String sql = "select c.constraint_name, c.constraint_type, \n c.table_name, c.owner, col.column_name, col.position \nfrom all_constraints c \n join all_cons_columns col on \n  (c.constraint_name = col.constraint_name) and \n  (c.owner = col.owner) \nwhere \n c.constraint_type = 'P' and \n" + this.getSchFilterStr("c", null) + " and \n" + " c.constraint_name NOT LIKE 'BIN$%' " + " \n" + "order by c.owner, c.table_name, c.constraint_name, col.position";
        String stepNm = "primary keys";
        ArrayList<String[]> strArrays = new ArrayList<String[]>();
        ResultSet rs = this.doSql(sql, stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String schNm = rs.getString("owner");
                        String tblNm = rs.getString("table_name");
                        String colNm = rs.getString("column_name");
                        String pkNm = rs.getString("constraint_name");
                        String pos = rs.getString("position");
                        String[] strArray = new String[]{schNm, tblNm, colNm, pos, pkNm};
                        strArrays.add(strArray);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
        this.itemBldr_.addPks(this.newDb_, strArrays);
    }

    private void addFKs() {
        String sql = "select fk.owner, fk.constraint_name, fk.table_name, \n fk.r_owner, fk.r_constraint_name, fk.delete_rule, \n pk.owner as pk_owner, pk.table_name as pk_table_name, \n col.column_name, col.position \nfrom all_constraints fk, all_constraints pk, all_cons_columns col \nwhere fk.constraint_type = 'R' \n and fk.r_constraint_name = pk.constraint_name \n and fk.r_owner  = pk.owner \n and pk.constraint_type = 'P' \n and fk.constraint_name = col.constraint_name \n and fk.owner = col.owner \n and " + this.getSchFilterStr("fk", null) + " \n" + "order by fk.owner, fk.constraint_name, fk.table_name, col.position";
        String stepNm = "foreign keys";
        ArrayList<String[]> strArrays = new ArrayList<String[]>();
        HashMap<String, Integer> fkDelActionMap = new HashMap<String, Integer>();
        ResultSet rs = this.doSql(sql, stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String schNm = rs.getString("owner");
                        String tblNm = rs.getString("table_name");
                        String colNm = rs.getString("column_name");
                        String fkNm = rs.getString("constraint_name");
                        String posStr = rs.getString("position");
                        String delActionStr = rs.getString("delete_rule");
                        Integer delActionId = this.getActionId(delActionStr);
                        int pos = StrHelper.getNullSafeInt(posStr) - 1;
                        String pkSchNm = rs.getString("pk_owner");
                        String pkTblNm = rs.getString("pk_table_name");
                        Schema pkSch = this.newDb_.getSchema(pkSchNm);
                        Table pkTbl = pkSch.getTable(pkTblNm);
                        PrimaryKey pk = pkTbl.getPrimaryKey();
                        Column pkCol = pk.getPkColumns(pkTbl).get(pos);
                        String pkColNm = pkCol.getName();
                        String[] strArray = new String[]{fkNm, pkSchNm, schNm, pkTblNm, tblNm, pkColNm, colNm};
                        strArrays.add(strArray);
                        fkDelActionMap.put(fkNm, delActionId);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
        this.itemBldr_.setFkDelActionMap(fkDelActionMap);
        this.itemBldr_.addFks(this.newDb_, strArrays);
    }

    private Integer getActionId(String actionStr) {
        int id = 3;
        if (actionStr.equals("NO ACTION")) {
            id = 3;
        } else if (actionStr.equals("CASCADE")) {
            id = 0;
        } else if (actionStr.equals("RESTRICT")) {
            id = 1;
        } else if (actionStr.equals("SET NULL")) {
            id = 2;
        } else if (actionStr.equals("SET DEFAULT")) {
            id = 4;
        }
        Integer idObj = new Integer(id);
        return idObj;
    }

    private void addIndexes() {
        this.notifyObserversDisp("engineer.reverse.status.index");
        String sql = "select i.owner, i.table_name, i.index_name, \nc.column_name, c.column_position, c.descend, \ni.uniqueness, i.clustering_factor \nfrom all_indexes i \n join all_ind_columns c on i.index_name = c.index_name \nwhere \n i.index_name not like 'SYS_C%' AND \n" + this.getSchFilterStr("i", null) + " \n" + "order by i.owner, i.table_name, i.index_name, c.column_position";
        String stepNm = "indexes";
        ArrayList<Object[]> objArrays = new ArrayList<Object[]>();
        ResultSet rs = this.doSql(sql, stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String schNm = rs.getString("owner");
                        String tblNm = rs.getString("table_name");
                        String idxNm = rs.getString("index_name");
                        String colNm = rs.getString("column_name");
                        String pos = rs.getString("column_position");
                        String uniqueStr = rs.getString("uniqueness");
                        String clusterStr = rs.getString("clustering_factor");
                        Boolean unique = new Boolean(uniqueStr.equalsIgnoreCase("unique"));
                        int i_clustered = clusterStr != null ? 1 : 0;
                        Integer clustered = new Integer(i_clustered);
                        Object[] objArray = new Object[]{schNm, tblNm, idxNm, colNm, unique, clustered};
                        objArrays.add(objArray);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
        this.itemBldr_.addIndexes(this.newDb_, objArrays);
    }

    private void addUniqueConstraints() {
        String sql = "select c.constraint_name, c.constraint_type, \n c.table_name, c.owner, col.column_name, col.position \nfrom all_constraints c \n join all_cons_columns col on \n  (c.constraint_name = col.constraint_name) and \n  (c.owner = col.owner) \nwhere \n c.constraint_type = 'U' and \n" + this.getSchFilterStr("c", null) + " and \n" + " c.constraint_name NOT LIKE 'BIN$%' " + " \n" + "order by c.owner, c.table_name, c.constraint_name, col.position";
        String stepNm = "primary keys";
        ArrayList<String[]> strArrays = new ArrayList<String[]>();
        ResultSet rs = this.doSql(sql, stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String schNm = rs.getString("owner");
                        String tblNm = rs.getString("table_name");
                        String colNm = rs.getString("column_name");
                        String conNm = rs.getString("constraint_name");
                        String[] strArray = new String[]{schNm, tblNm, colNm, conNm};
                        strArrays.add(strArray);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
        this.itemBldr_.addUniqueConstraints(this.newDb_, strArrays);
    }

    private void addSeqs() {
        this.notifyObserversDisp("engineer.reverse.status.seqs");
        String sql = "select sequence_owner, sequence_name, \n min_value, increment_by \nfrom all_sequences";
        String stepNm = "sequences";
        ResultSet rs = this.doSqlWithFilter(sql, "sequence_owner", stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String schNm = rs.getString("sequence_owner");
                        String seqNm = rs.getString("sequence_name");
                        int increment = rs.getInt("increment_by");
                        Sequence seq = new Sequence(seqNm, increment, "");
                        Schema sch = this.newDb_.getSchema(schNm);
                        sch.add(seq);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private void addViews() {
        this.notifyObserversDisp("engineer.reverse.status.views");
        String sql = "select view_name, owner, text \nfrom all_views ";
        String stepNm = "views";
        ResultSet rs = this.doSqlWithFilter(sql, null, stepNm, false);
        if (rs != null) {
            try {
                while (rs.next()) {
                    try {
                        String schNm = rs.getString("owner");
                        String vwNm = rs.getString("view_name");
                        String src = rs.getString("text");
                        View view = new View(vwNm, src);
                        Schema sch = this.newDb_.getSchema(schNm);
                        sch.add(view);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private void addProcs() {
        this.notifyObserversDisp("engineer.reverse.status.procs");
        String sql = "select p.owner, p.object_name, s.line, s.text \nfrom all_procedures p \n join all_source s \n  on p.object_name = s.name \n   and p.owner = s.owner \nwhere \ns.type = 'PROCEDURE' and \n" + this.getSchFilterStr("p", null) + " \n" + " order by p.owner, p.object_name, s.line";
        String stepNm = "procedures";
        ResultSet rs = this.doSql(sql, stepNm, false);
        if (rs != null) {
            try {
                String lastSchNm = "";
                String lastProcNm = "";
                StringBuffer srcSb = new StringBuffer();
                while (rs.next()) {
                    try {
                        boolean isSame;
                        String schNm = rs.getString("owner");
                        String procNm = rs.getString("object_name");
                        String text = rs.getString("text");
                        boolean isSameSchNm = lastSchNm.equals(schNm);
                        boolean isSameProcNm = lastProcNm.equals(procNm);
                        boolean bl = isSame = isSameSchNm && isSameProcNm;
                        if (!isSame) {
                            this.checkAddProc(lastSchNm, lastProcNm, srcSb.toString());
                            srcSb = new StringBuffer();
                            lastSchNm = schNm;
                            lastProcNm = procNm;
                        }
                        srcSb.append(text);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.checkAddProc(lastSchNm, lastProcNm, srcSb.toString());
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private void addTriggers() {
        this.notifyObserversDisp("engineer.reverse.status.triggers");
        String sql = "select t.owner, t.trigger_name, t.trigger_type, t.triggering_event,\n s.line, s.text, t.table_name \nfrom all_triggers t \n join all_source s \n  on t.trigger_name = s.name \n   and t.owner = s.owner \nwhere \ns.type = 'TRIGGER' and \n" + this.getSchFilterStr("t", null) + " \n" + " order by t.owner, t.trigger_name, s.line";
        String stepNm = "triggers";
        ResultSet rs = this.doSql(sql, stepNm, false);
        if (rs != null) {
            try {
                String lastSchNm = "";
                String lastTblNm = "";
                String lastTrgNm = "";
                StringBuffer srcSb = new StringBuffer();
                String typeStr = "";
                String eventsStr = "";
                while (rs.next()) {
                    try {
                        boolean isSame;
                        String schNm = rs.getString("owner");
                        String tblNm = rs.getString("table_name");
                        String trgNm = rs.getString("trigger_name");
                        String text = rs.getString("text");
                        typeStr = rs.getString("trigger_type");
                        eventsStr = rs.getString("triggering_event");
                        boolean isSameSchNm = lastSchNm.equals(schNm);
                        boolean isSameTrgNm = lastTrgNm.equals(trgNm);
                        boolean bl = isSame = isSameSchNm && isSameTrgNm;
                        if (!isSame) {
                            this.checkAddTrg(lastSchNm, lastTblNm, lastTrgNm, srcSb.toString(), eventsStr, typeStr);
                            srcSb = new StringBuffer(TRG_CREATE_REPLACE_STR);
                            lastSchNm = schNm;
                            lastTrgNm = trgNm;
                            lastTblNm = tblNm;
                        }
                        srcSb.append(text);
                    }
                    catch (Exception e) {
                        this.processError(e, stepNm);
                    }
                }
                this.checkAddTrg(lastSchNm, lastTblNm, lastTrgNm, srcSb.toString(), eventsStr, typeStr);
                this.close(rs);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private void checkAddProc(String schNm, String procNm, String src) {
        if (Validator.isStringValid(src)) {
            String fullSrc = "CREATE OR REPLACE " + src;
            Proc proc = new Proc(fullSrc, "", procNm);
            Schema sch = this.newDb_.getSchema(schNm);
            sch.add(proc);
        }
    }

    private void checkAddTrg(String schNm, String tblNm, String trgNm, String src, String eventsStr, String typeStr) {
        String stepNm = "building trigger";
        if (Validator.isStringValid(src)) {
            try {
                OracleTriggerParser parser = new OracleTriggerParser();
                boolean onDel = parser.parseOnDelete(eventsStr);
                boolean onIns = parser.parseOnInsert(eventsStr);
                boolean onUpd = parser.parseOnUpdate(eventsStr);
                boolean execBefore = parser.parseExecBefore(typeStr);
                boolean forEachRow = parser.parseForRow(typeStr);
                Trigger trg = new Trigger(trgNm, onDel, onIns, onUpd, src, execBefore, forEachRow);
                Schema sch = this.newDb_.getSchema(schNm);
                Table tbl = sch.getTable(tblNm);
                tbl.add(trg);
            }
            catch (Exception e) {
                this.processError(e, stepNm);
            }
        }
    }

    private Integer convertUnicodeLength(IDataType dataType, Integer length) {
        int typeId = dataType.getId();
        if (typeId == 724 || typeId == 782) {
            Integer halfLength = new Integer(length / 2);
            return halfLength;
        }
        return length;
    }

    private String processColDefault(String rawDefault) {
        String processed = new String(rawDefault);
        processed = processed.trim();
        processed = StrHelper.removeEnclosingQuotes(processed);
        return processed;
    }

    private ResultSet doSqlWithFilter(String sql, String ownerColNm, String stepNm, boolean debugPrint) {
        String fullSql = sql + " \n" + "where \n" + this.getSchFilterStr(null, ownerColNm);
        if (debugPrint) {
            this.debugPrintSql(fullSql, stepNm);
        }
        return this.doSql(fullSql, stepNm, false);
    }

    private ResultSet doSql(String sql, String stepNm, boolean debugPrint) {
        if (debugPrint) {
            this.debugPrintSql(sql, stepNm);
        }
        ResultSet rs = null;
        try {
            rs = ConnectionFactory.doSql(this.conn_, sql);
        }
        catch (Exception e) {
            this.processError(e, stepNm);
        }
        return rs;
    }

    private void close(ResultSet rs) {
        ConnectionFactory.close(rs);
    }

    private void debugPrintSql(String fullSql, String stepNm) {
        LogUtil.logMsg("OrcMeta: " + stepNm + ", sql:\n" + fullSql);
    }

    private Integer getNullSafeInt(String str) {
        return StrHelper.getNullSafeInt(str);
    }

    private void processError(Exception e, String revEngStep) {
        String fullMsg = e.getMessage() + " (rev. eng. of " + revEngStep + ")";
        this.notifyObserversDisp("engineer.reverse.milestone.err", fullMsg);
        this.logError(fullMsg, META_CTRL_NM);
        if (LogUtil.isTestMode()) {
            StrHelper.throwProgExcept("OracleMetaDataCtrl.error: (" + revEngStep + ") \n" + "msg: " + e.getMessage());
        }
    }

    private String getSchFilterStr(String tblAbbr, String ownerColNm) {
        return this.ignoreCtrl.getIgnoreSchStr(tblAbbr, ownerColNm);
    }
}

