/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData;

import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.jdbc.JdbcUtil;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.CustomTypeIdCtrl;
import com.harrand.dbwrench.jdbc.DataType;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.JdbcMetaDataCtrl;
import com.harrand.dbwrench.metaData.helper.SqlSvrVersionHelper;
import com.harrand.dbwrench.metaData.ignore.SqlSvrIgnoreCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.dbwrench.script.converter.MsSqlServerDataTypeConverter;
import com.harrand.dbwrench.script.misc.SqlSvrCmmSwitchMgr;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class MsSqlServerMetaDataCtrl
extends JdbcMetaDataCtrl {
    private IDataTypeConverter dataTypeConverter_;
    protected Version dbmsVersion_ = null;
    protected String dbmsVersionStr_ = "";
    private SqlSvrCmmSwitchMgr switchMgr_ = SqlSvrCmmSwitchMgr.instance();
    private SqlSvrIgnoreCtrl ignoreCtrl;
    private Map tblComments_ = new HashMap();
    private Map fkComments_ = new HashMap();
    private Map procComments_ = new HashMap();
    private Map colComments_ = new HashMap();
    private Map colAttNumsMap_ = new HashMap();
    public static final String PARSE_FAILED = "Parse Failed";
    private static final String META_CTRL_NM = "MsSqlSvrMetaCtrl";
    public static final String SCHEMA_SQL_2000 = "SELECT DISTINCT su.name AS 'SchNm' \nFROM sysusers su \nJOIN sysobjects so ON su.uid = so.uid \nWHERE so.name NOT LIKE 'sys%' \nAND so.name NOT LIKE 'sp_%' \nAND (so.xtype = 'U' or so.xtype = 'V' or so.xtype = 'P')";
    public static final String SCHEMA_CMM_SQL_2005 = "SELECT sch.name AS 'SchNm', \nep.name AS PropNm, \nep.value AS 'Cmm' \nFROM sys.extended_properties AS ep \nJOIN sys.schemas AS sch ON ep.MAJOR_ID = sch.schema_id \nWHERE ((ep.name = 'Comment') OR (ep.name = 'MS_Description'))\nAND ep.class_desc = 'SCHEMA'";
    public static final String SCHEMA_CMM_SQL_2000 = "SELECT sp.value AS 'Cmm', \nsp.name AS PropNm, \nsu.name AS 'SchNm' \nFROM sysproperties AS sp \nJOIN sysusers AS su ON sp.smallid = su.uid \nWHERE sp.id = 0 \nAND sp.type = 2 \nAND ((sp.name = 'Comment') OR (sp.name = 'MS_Description')) ";
    public static final String CMM_FIRST_SQL_2000 = "SELECT \nsu.name AS SchNm, \nobject_name(sp.id) AS ObjNm, \nsp.value AS Cmm, \nsp.name AS PropNm, \nso.xtype AS xType \nFROM sysproperties sp \nJOIN sysobjects so ON so.id = sp.id \nJOIN sysusers su ON su.uid = so.uid \nWHERE ((sp.name = 'Comment') OR (sp.name = 'MS_Description')) \nAND smallid = 0 \nORDER BY sp.name";
    public static final String CMM_FIRST_SQL_2005 = "SELECT \nsch.name AS SchNm, \nOBJECT_NAME(EXP.MAJOR_ID) AS ObjNm, \nEXP.value AS Cmm, \nEXP.name AS PropNm, \no.type AS xType \nFROM sys.extended_properties AS EXP \nJOIN sys.objects AS o ON o.object_id = EXP.MAJOR_ID \nJOIN sys.schemas AS sch ON o.schema_id = sch.schema_id \nWHERE EXP.class_desc = 'OBJECT_OR_COLUMN' \nAND EXP.MINOR_ID = 0 \nAND ((EXP.name = 'Comment') OR (EXP.name = 'MS_Description')) \nORDER BY EXP.name";
    public static final String CMM_SECOND_SQL_2000 = "SELECT \nsu.name AS SchNm, \nobject_name(sp.id) AS 'Level1Nm', \nsc.name AS 'ItemNm', \nsp.value AS Cmm, \nsp.name AS PropNm, \nsp.id, \nsp.smallid \nFROM sysproperties sp \nJOIN sysobjects so ON so.id = sp.id \nJOIN sysusers su ON su.uid = so.uid \nJOIN syscolumns sc ON ( sp.smallId = sc.colid AND sp.id = sc.id) \nWHERE ((sp.name = 'Comment') OR (sp.name = 'MS_Description')) \nAND smallid > 0 \nORDER BY sp.name";
    public static final String CMM_SECOND_SQL_2005 = "SELECT \nsch.name AS SchNm, \no.name AS Level1Nm, \nC.name AS ItemNm, \nEXP.name AS PropNm, \nEXP.value AS Cmm \nFROM   sys.extended_properties AS EXP \nJOIN sys.columns AS C \nON    C.object_id = EXP.MAJOR_ID \nAND   C.column_id = EXP.MINOR_ID \nJOIN sys.objects AS o ON EXP.MAJOR_ID = o.object_id \nJOIN sys.schemas AS sch ON o.schema_id = sch.schema_id \nWHERE EXP.class_desc = 'OBJECT_OR_COLUMN' \nAND ((EXP.name = 'Comment') OR (EXP.name = 'MS_Description')) \nORDER BY EXP.name";
    public static final String DEFAULTS_SQL_2005 = "SELECT\tsoo_c.name\tAS CONSTRAINT_SCHEMA \n,soo_t.name\tAS TABLE_SCHEMA \n,t_obj.name \tAS TABLE_NM \n,col.name          AS COLUMN_NM \n,c_obj.name\tAS CONSTRAINT_NAME \n,com.text          AS DEFAULT_CLAUSE \nFROM   sysobjects      AS c_obj \nJOIN   syscomments     AS com ON \tc_obj.id = com.id \nJOIN   sysobjects      AS t_obj ON c_obj.parent_obj = t_obj.id \nJOIN   sysconstraints  AS con ON c_obj.id\t= con.constid \nJOIN   syscolumns\tAS col ON t_obj.id = col.id \nAND con.colid = col.colid \nJOIN sys.schemas AS soo_c ON soo_c.schema_id = c_obj.uid \nJOIN sys.schemas AS soo_t ON soo_t.schema_id = t_obj.uid \nWHERE c_obj.xtype\t= 'D'";
    public static final String DEFAULTS_SQL_2000 = "SELECT\tuser_name(c_obj.uid)\t\tAS CONSTRAINT_SCHEMA \n,user_name(t_obj.uid)\t\tAS TABLE_SCHEMA \n,t_obj.name \t\t\tAS TABLE_NM \n,col.name\t\t\t\tAS COLUMN_NM \n,c_obj.name\t\t\tAS CONSTRAINT_NAME \n,com.text\t\t\t\tAS DEFAULT_CLAUSE \nFROM\tsysobjects\t c_obj \nJOIN \tsyscomments\tAS com ON \tc_obj.id = com.id \nJOIN \tsysobjects \tAS t_obj ON c_obj.parent_obj = t_obj.id  \nJOIN   sysconstraints  AS con ON c_obj.id\t= con.constid \nJOIN \tsyscolumns\tAS col ON t_obj.id = col.id \nAND con.colid = col.colid \nWHERE c_obj.xtype\t= 'D' \n";

    public MsSqlServerMetaDataCtrl(JdbcConfig config) {
        super(config);
        this.dataTypeConverter_ = config.getDataTypeConverter();
        this.ignoreCtrl = new SqlSvrIgnoreCtrl(this.getConfig().getSchemaIgnoreCtrl());
    }

    @Override
    public Database reverseEngineer() throws Exception {
        long startTime = System.currentTimeMillis();
        this.conn_ = ConnectionFactory.getConnection(this.getConfig());
        this.dbmsVersion_ = null;
        this.loadVersion();
        this.setComments();
        this.setColAttNums();
        Database newDb = super.reverseEngineer();
        newDb.getNotifyMgr().setEnabled(false);
        if (this.isProcRevEngEnabled()) {
            this.addProcs(newDb);
        }
        if (this.isTriggerRevEngEnabled()) {
            this.addTriggers(newDb);
        }
        super.doPostRevEngTasks();
        this.conn_.close();
        newDb.getNotifyMgr().setEnabled(true);
        return newDb;
    }

    @Override
    public Database revEngForSync() throws Exception {
        return null;
    }

    @Override
    protected DatabaseMetaData getDatabaseMetaData() {
        return null;
    }

    @Override
    protected void addSchemas(Database newDb) {
        this.notifyObserversDisp("engineer.reverse.status.schemas");
        this.removeDefaultSchema(newDb);
        String sql = "SELECT DISTINCT sch.name AS 'SchNm' \nFROM sys.schemas sch \n\tJOIN sysobjects so ON sch.schema_id = so.uid \nWHERE " + this.getSchemaFilter("sch.name", true) + "so.name NOT LIKE 'sys%' \n" + "\tAND so.name NOT LIKE 'sp_%' \n" + "\tAND (so.xtype = 'U' or so.xtype = 'V' or so.xtype = 'P')";
        if (!this.isSql2005orNewer()) {
            sql = SCHEMA_SQL_2000;
        }
        Map schemaCmm = this.getSchemaComments();
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("SchNm");
                    Schema schema = new Schema(schNm);
                    newDb.add(schema);
                    Object objCmm = schemaCmm.get(schNm);
                    if (objCmm instanceof String) {
                        schema.setComment((String)objCmm);
                    }
                    this.notifyObserversDisp("engineer.reverse.milestone.schema.added", schNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private boolean isSql2005orNewer() {
        return SqlSvrVersionHelper.is2005orNewer(this.getConfig().getVersion());
    }

    private void setComments() {
        this.switchMgr_.clear();
        this.setCommentsTopLevel();
        this.setCommentsSecondLevel();
    }

    private void setCommentsTopLevel() {
        this.procComments_ = new HashMap();
        this.tblComments_ = new HashMap();
        this.fkComments_ = new HashMap();
        String sql = this.isSql2005orNewer() ? CMM_FIRST_SQL_2005 : CMM_FIRST_SQL_2000;
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("SchNm");
                    String objNm = rs.getString("objNm");
                    String xtype = rs.getString("xtype").trim();
                    String cmm = rs.getString("cmm");
                    String propNm = rs.getString("PropNm");
                    String dotNote = StrHelper.getDotNote(schNm, objNm);
                    String mapNm = "";
                    if (xtype.equals("P")) {
                        this.procComments_.put(dotNote, cmm);
                        mapNm = Proc.getClassName();
                    } else if (xtype.equals("F")) {
                        this.fkComments_.put(dotNote, cmm);
                        mapNm = ForeignKey.getClassName();
                    } else if (xtype.equals("U")) {
                        this.tblComments_.put(dotNote, cmm);
                        mapNm = Table.getClassName();
                    }
                    this.switchMgr_.addEntry(mapNm, dotNote, propNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    private void setCommentsSecondLevel() {
        long start = System.currentTimeMillis();
        this.colComments_ = new HashMap();
        String sql = this.isSql2005orNewer() ? CMM_SECOND_SQL_2005 : CMM_SECOND_SQL_2000;
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("SchNm");
                    String level1Nm = rs.getString("Level1Nm");
                    String itemNm = rs.getString("itemNm");
                    String cmm = rs.getString("Cmm");
                    String propNm = rs.getString("PropNm");
                    String dotNote = schNm + "." + level1Nm + "." + itemNm;
                    this.colComments_.put(dotNote, cmm);
                    this.switchMgr_.addEntry(Column.getClassName(), dotNote, propNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    private Map getSchemaComments() {
        String sql = this.isSql2005orNewer() ? SCHEMA_CMM_SQL_2005 : SCHEMA_CMM_SQL_2000;
        HashMap<String, String> cmmMap = new HashMap<String, String>();
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("SchNm");
                    String cmm = rs.getString("Cmm");
                    String propNm = rs.getString("PropNm");
                    cmmMap.put(schNm, cmm);
                    this.switchMgr_.addEntry(Schema.getClassName(), schNm, propNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return cmmMap;
    }

    @Override
    protected void addTables(DatabaseMetaData dbmd, Database db) {
        this.notifyObserversDisp("engineer.reverse.status.tables");
        long start = System.currentTimeMillis();
        String sql = "SELECT * \nFROM INFORMATION_SCHEMA.TABLES \nWHERE " + this.getSchemaFilter("TABLE_SCHEMA", true) + "TABLE_TYPE ='BASE TABLE' \n";
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("TABLE_SCHEMA");
                    String tblNm = rs.getString("TABLE_NAME");
                    if (!this.isUserTable(tblNm)) continue;
                    Schema schema = db.getSchema(schNm);
                    Table table = new Table(tblNm);
                    String dotNote = schNm + "." + tblNm;
                    table.setUseManualSort(true);
                    Object cmmObj = this.tblComments_.get(dotNote);
                    if (cmmObj != null) {
                        table.setComment((String)cmmObj);
                    }
                    this.tableNms_.add(schNm + "." + tblNm);
                    schema.add(table);
                    this.notifyObserversDisp("engineer.reverse.milestone.table.added", tblNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    private void setColAttNums() {
        this.colAttNumsMap_ = new HashMap();
        String sql = "SELECT \n\tobj.name AS 'tblNm', \n\tcol.name AS 'colNm', \n\tcol.colid, \n\tcol.id AS 'tblId' \nFROM syscolumns AS col \n\tJOIN sysobjects AS obj ON col.id = obj.id \nWHERE obj.xtype = 'U'";
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String tblNm = rs.getString("tblNm");
                    int tblId = rs.getInt("tblId");
                    String colNm = rs.getString("colNm");
                    int attNum = rs.getInt("colid");
                    String colIdDotNot = Integer.toString(tblId) + "." + Integer.toString(attNum);
                    this.colAttNumsMap_.put(colIdDotNot, colNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    @Override
    protected void addIndexes(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.index");
        long start = System.currentTimeMillis();
        String schJoin = this.isSql2005orNewer() ? "\tJOIN sys.schemas AS soo on soo.schema_id = o.uid" : "\tJOIN sysusers AS soo on soo.uid = o.uid";
        String sql = "SELECT \n\ti.name AS 'indexNm', \n\ti.status, \n\tsoo.name AS 'schNm', \n\tobject_name(ik.id) AS 'tblNm', \n\tc.name AS 'colNm', \n\tik.keyno AS 'keyNum', \n\ti.indid, \n\t(i.status & 2) AS 'unique' \nFROM sysindexes i \n\tJOIN sysobjects o ON i.id = o.id \n" + schJoin + " \n" + "\tJOIN sysindexkeys ik on i.id = ik.id \n" + "\t\tAND i.indid = ik.indid \n" + "\tJOIN syscolumns c ON ik.id = c.id \n" + "\t\tAND ik.colid = c.colid \n" + "WHERE " + this.getSchemaFilter("soo.name", true) + "\tobject_name(ik.id) NOT LIKE 'sys%' \n" + "\tAND object_name(ik.id) NOT LIKE 'queue%' \n" + "\tAND soo.name != 'sys' \n" + "\tAND i.name NOT LIKE '_WA_Sys_%' \n" + "\tAND i.status != 2066 \n" + "\tAND i.status != 18450 \n" + "\tAND i.status != 4098 \n" + "ORDER BY 'tblNm', ik.keyno";
        ArrayList<Object[]> objArrays = new ArrayList<Object[]>();
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("schNm");
                    String tblNm = rs.getString("tblNm");
                    String idxNm = rs.getString("indexNm");
                    String colNm = rs.getString("colNm");
                    int unique = rs.getInt("unique");
                    int indid = rs.getInt("indid");
                    Integer clusteredInt = indid == 1 ? new Integer(1) : new Integer(0);
                    Boolean uniqueBool = unique == 2 ? new Boolean(true) : new Boolean(false);
                    Object[] objArray = new Object[]{schNm, tblNm, idxNm, colNm, uniqueBool, clusteredInt};
                    objArrays.add(objArray);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            this.itemBldr_.addIndexes(db, objArrays);
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    @Override
    protected void addColumns(Database db) {
        List autoNumberCols = this.getAutoNumberColumns(db);
        Map defaultNmsMap = this.getDefaultNms(db);
        String sql = "SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, \n\tORDINAL_POSITION, COLUMN_DEFAULT, IS_NULLABLE, \n\tDATA_TYPE, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION, \n\tNUMERIC_SCALE, DOMAIN_CATALOG, DOMAIN_SCHEMA, DOMAIN_NAME \nFROM INFORMATION_SCHEMA.COLUMNS \nWHERE " + this.getSchemaFilter("TABLE_SCHEMA", true) + "table_name NOT IN \n " + "\t(Select DISTINCT table_name FROM INFORMATION_SCHEMA.VIEWS) \n" + "\tAND table_name <> 'sysdiagrams' \n" + "ORDER BY TABLE_NAME, ORDINAL_POSITION";
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            String colNm = null;
            String tblDotNote = null;
            while (rs.next()) {
                try {
                    String schNm = rs.getString("TABLE_SCHEMA");
                    String tblNm = rs.getString("TABLE_NAME");
                    colNm = rs.getString("COLUMN_NAME");
                    Schema sch = db.getSchema(schNm);
                    String dataTypeStr = rs.getString("DATA_TYPE");
                    String domainCatalog = rs.getString("DOMAIN_CATALOG");
                    String domainSchNm = rs.getString("DOMAIN_SCHEMA");
                    String domainNm = rs.getString("DOMAIN_NAME");
                    String dataTypeDesc = this.getDataTypeDesc(db, dataTypeStr, domainCatalog, domainSchNm, domainNm);
                    IDataType dataType = this.dataTypeConverter_.getDataType(db, sch, dataTypeDesc);
                    String charMaxStr = rs.getString("CHARACTER_MAXIMUM_LENGTH");
                    String precStr = rs.getString("NUMERIC_PRECISION");
                    String scaleStr = rs.getString("NUMERIC_SCALE");
                    if (this.getIsMaxType(dataType, charMaxStr)) {
                        dataType = this.getMaxType(dataType.getId());
                    }
                    Integer[] intObjs = this.getLengthScale(dataType, precStr, scaleStr, charMaxStr);
                    Integer length = intObjs[0];
                    Integer scale = intObjs[1];
                    if (!dataType.isStandardType()) {
                        length = null;
                        scale = null;
                    }
                    String defaultRaw = rs.getString("COLUMN_DEFAULT");
                    String defaultValue = this.parseDefault(defaultRaw);
                    String nullStr = rs.getString("IS_NULLABLE");
                    boolean isNullable = nullStr.equals("YES");
                    String dotNote = schNm + "." + tblNm + "." + colNm;
                    boolean autoNumber = autoNumberCols.contains(dotNote);
                    Object commentObj = this.colComments_.get(dotNote);
                    String comment = commentObj != null ? commentObj.toString() : "";
                    String defaultNm = defaultNmsMap.containsKey(dotNote) ? (String)defaultNmsMap.get(dotNote) : "";
                    Table table = sch.getTable(tblNm);
                    tblDotNote = table.getDotNote();
                    ITestResult result = table.add(new Column(colNm, dataType, length, isNullable, autoNumber, defaultValue, scale, comment, defaultNm));
                    this.checkResult(result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String objDesc = this.getNullSafe(tblDotNote) + "." + this.getNullSafe(colNm);
                    this.logError(e, META_CTRL_NM, objDesc);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            long processTime = System.currentTimeMillis();
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private Integer[] getLengthScale(IDataType dataType, String precisionStr, String scaleStr, String charMaxStr) {
        Integer length = null;
        if (dataType.isLengthUsed()) {
            if (charMaxStr != null) {
                length = new Integer(charMaxStr);
                if (this.getIsMaxType(dataType, charMaxStr)) {
                    length = null;
                }
            } else {
                length = precisionStr != null ? new Integer(precisionStr) : new Integer(1);
            }
        }
        Integer scale = dataType.isScaleUsed() ? this.getNullSafeInt(scaleStr) : null;
        length = dataType.isScaleUsed() ? this.getNullSafeInt(precisionStr) : length;
        return new Integer[]{length, scale};
    }

    private Integer getNullSafeInt(String str) {
        return StrHelper.getNullSafeInt(str);
    }

    private boolean getIsMaxType(IDataType dataType, String charMaxStr) {
        return dataType.isLengthUsed() && charMaxStr != null && charMaxStr.equals("-1");
    }

    private DataType getMaxType(int currentTypeId) {
        DataType maxType = BasicTypesSvr.instance().getType(731);
        if (currentTypeId == -3) {
            maxType = BasicTypesSvr.instance().getType(730);
        } else if (currentTypeId == 724) {
            maxType = BasicTypesSvr.instance().getType(729);
        }
        return maxType;
    }

    private String getDataTypeDesc(Database db, String dataTypeStr, String domainCatalog, String domainSchNm, String domainNm) {
        String dataTypeDesc = dataTypeStr;
        if (Validator.isStringValid(domainNm)) {
            boolean isExternalType = this.isExternalType(db, domainCatalog);
            if (isExternalType) {
                dataTypeDesc = "(From External DB)";
            } else {
                dataTypeDesc = domainNm;
                this.checkAddDataType(db, domainSchNm, domainNm);
            }
        }
        return dataTypeDesc;
    }

    private boolean isExternalType(Database db, String domainCatalog) {
        String catNmLc;
        String dbNmLc = db.getName().toLowerCase();
        boolean isExternal = !dbNmLc.equals(catNmLc = domainCatalog.toLowerCase());
        return isExternal;
    }

    private void checkAddDataType(Database db, String domainSchNm, String domainNm) {
        boolean hasSchema = db.contains(Schema.getClassName(), domainSchNm);
        if (hasSchema) {
            Schema schDomain = db.getSchema(domainSchNm);
            MsSqlServerDataTypeConverter sqlSvrConv = (MsSqlServerDataTypeConverter)this.dataTypeConverter_;
            boolean isInexactMatch = sqlSvrConv.getInexactTypeId(domainNm) != null;
            boolean contains = schDomain.contains(CustomType.getClassName(), domainNm);
            if (!isInexactMatch && !contains) {
                CustomType newType = CustomTypeIdCtrl.instance().createCustomType(db, domainNm, "");
                schDomain.add(newType);
            }
        } else {
            String msg = super.getCustomTypeSchemaNotFoundMsg(domainNm, domainSchNm);
            this.notifyObserversDisp("engineer.reverse.milestone.warn", msg);
        }
    }

    private List getAutoNumberColumns(Database db) {
        String schJoin = this.isSql2005orNewer() ? "\tJOIN sys.schemas AS soo ON soo.schema_id = o.uid" : "\tJOIN sysusers AS soo ON soo.uid = o.uid";
        String sql = "SELECT DISTINCT \n\tobject_name(sc.id) AS 'tblNm', \n\tsoo.name AS 'schNm', \n\tsc.name AS 'colNm', \n\t(sc.status & 128) AS autonumber, \n\tcolumnproperty(sc.id, sc.[name], 'IsRowGUIDCol') AS 'IsRowGuidCol' \nFROM syscolumns AS sc \n\tJOIN sysobjects AS o ON sc.id = o.id \n" + schJoin + " \n" + "WHERE (sc.status & 128) = 128 \n" + "\tor columnproperty(sc.id, sc.[name], 'IsRowGUIDCol') = 1 \n" + "ORDER BY tblNm, colNm \n";
        ArrayList<String> dotNotes = new ArrayList<String>();
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("schNm");
                    String tblNm = rs.getString("tblNm");
                    String colNm = rs.getString("colNm");
                    String colDotNote = schNm + "." + tblNm + "." + colNm;
                    dotNotes.add(colDotNote);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return dotNotes;
    }

    private Map getDefaultNms(Database db) {
        HashMap<String, String> nmsMap = new HashMap<String, String>();
        String sql = this.isSql2005orNewer() ? DEFAULTS_SQL_2005 : DEFAULTS_SQL_2000;
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("TABLE_SCHEMA");
                    String tblNm = rs.getString("TABLE_NM");
                    String colNm = rs.getString("COLUMN_NM");
                    String defaultNm = rs.getString("CONSTRAINT_NAME");
                    String colDotNote = schNm + "." + tblNm + "." + colNm;
                    nmsMap.put(colDotNote, defaultNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return nmsMap;
    }

    @Override
    protected void addPks(Database db) {
        long start = System.currentTimeMillis();
        long sqlTime = 0L;
        long processTime = 0L;
        String schJoin = this.isSql2005orNewer() ? "\tJOIN sys.schemas AS soo ON soo.schema_id = pk.uid" : "\tJOIN sysusers AS soo ON soo.uid = pk.uid";
        String sql = "SELECT \n\tobject_name(pk.id) AS 'pkNm', \n\tsoo.name AS 'schNm', \n\tobject_name(pk.parent_obj) AS 'tblNm', \n\tc.name AS 'colNm', \n\tik.keyno AS 'keyNum' \nFROM sysindexes i \n\tJOIN sysobjects o ON i.id = o.id \n\tJOIN sysobjects pk ON i.name = pk.name \n\t\tAND pk.parent_obj = i.id \n\t\tAND pk.xtype = 'PK' \n\tJOIN sysindexkeys ik ON i.id = ik.id \n\t\tAND i.indid = ik.indid \n\tJOIN syscolumns c ON ik.id = c.id \n\t\tAND ik.colid = c.colid \n" + schJoin + " \n" + "WHERE " + this.getSchemaFilter("soo.name", true) + " object_name(pk.parent_obj) NOT LIKE 'sys%' \n" + "ORDER BY 'tblNm', ik.keyno;";
        try {
            ArrayList<String[]> strArrays = new ArrayList<String[]>();
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            sqlTime = System.currentTimeMillis();
            while (rs.next()) {
                try {
                    String[] strArray = new String[]{rs.getString("schNm"), rs.getString("tblNm"), rs.getString("colNm"), rs.getString("keyNum"), rs.getString("pkNm")};
                    strArrays.add(strArray);
                }
                catch (Exception e) {
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            this.itemBldr_.addPks(db, strArrays);
            processTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    @Override
    protected void addUniqueConstraints(Database db) {
        String schJoin = this.isSql2005orNewer() ? "\tJOIN sys.schemas AS soo ON soo.schema_id = uc.uid" : "\tJOIN sysusers AS soo ON soo.uid = uc.uid";
        String sql = "SELECT \n\tobject_name(uc.id) AS 'ucNm', \n\tsoo.name AS 'schNm', \n\tobject_name(uc.parent_obj) AS 'tblNm', \n\tc.name AS 'colNm', \n\tik.keyno AS 'keyNum' \nFROM sysindexes i \n\tJOIN sysobjects o ON i.id = o.id \n\tJOIN sysobjects uc ON i.name = uc.name \n\t\tAND uc.parent_obj = i.id \n\t\tAND uc.xtype = 'UQ' \n\tJOIN sysindexkeys ik ON i.id = ik.id \n\t\tAND i.indid = ik.indid \n\tJOIN syscolumns c ON ik.id = c.id \n\t\tAND ik.colid = c.colid \n" + schJoin + " \n" + "WHERE " + this.getSchemaFilter("soo.name", true) + " object_name(uc.parent_obj) NOT LIKE 'sys%' \n" + "ORDER BY 'tblNm', ik.keyno;";
        try {
            ArrayList<String[]> strArrays = new ArrayList<String[]>();
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String[] strArray = new String[]{rs.getString("schNm"), rs.getString("tblNm"), rs.getString("colNm"), rs.getString("ucNm")};
                    strArrays.add(strArray);
                }
                catch (Exception e) {
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            this.itemBldr_.addUniqueConstraints(db, strArrays);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private String parseDefault(String defaultRaw) {
        String defaultStr = Validator.isStringValid(defaultRaw) ? (StrHelper.isNumeric(defaultRaw = defaultRaw.substring(1, defaultRaw.length() - 1)) ? defaultRaw : (defaultRaw.indexOf("()") > 0 ? defaultRaw : (defaultRaw = defaultRaw.substring(1, defaultRaw.length() - 1)))) : "";
        return defaultStr;
    }

    protected void checkAutoIncrementColumns(List tables) {
    }

    @Override
    protected void addForeignKeys(DatabaseMetaData dbmd, Database db) {
        this.notifyObserversDisp("engineer.reverse.status.fks");
        long start = System.currentTimeMillis();
        String fkIgnoreSchStr = this.ignoreCtrl.getFkIgnoreSchStr("sop.name", "soc.name");
        String infoJoin = "\tJOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS AS rc \n\t\tON soc.name = rc.CONSTRAINT_SCHEMA \n\t\tAND object_name(constid) = rc.CONSTRAINT_NAME";
        String schJoin = this.isSql2005orNewer() ? "\tJOIN sys.schemas AS sop ON sop.schema_id = op.uid \n\tJOIN sys.schemas AS soc ON soc.schema_id = oc.uid \n" : "\tJOIN sysusers AS sop ON sop.uid = op.uid \n\tJOIN sysusers AS soc ON soc.uid = oc.uid \n";
        String sql = "SELECT object_name(constid) AS 'fkNm', \n\tobject_name(fkeyid) AS 'ChdTblNm', \n\tobject_name(rkeyid) AS 'ParTblNm', \n\tfkeyid AS 'ChdTblId', \n\trkeyid AS 'ParTblId', \n\tsop.name AS 'parSchNm', \n\tsoc.name AS 'chdSchNm', \n\tfkey AS 'ChdColId', \n\trkey AS 'ParColId', \n\tkeyno AS 'KeyNo' , \n\trc.UPDATE_RULE AS 'UPDATE_RULE', \n\trc.DELETE_RULE AS 'DELETE_RULE'\nFROM sysforeignkeys \n\tJOIN sysobjects AS op ON op.id = rkeyid \n\tJOIN sysobjects AS oc ON oc.id = fkeyid \n" + schJoin + infoJoin + " \n" + fkIgnoreSchStr + "ORDER BY 'fkNm', keyno" + " \n";
        try {
            String colClazz = Column.getClassName();
            ArrayList<String[]> strArrays = new ArrayList<String[]>();
            HashMap<String, Integer> fkDelActionMap = new HashMap<String, Integer>();
            HashMap<String, Integer> fkUpdActionMap = new HashMap<String, Integer>();
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String parSchNm = rs.getString("parSchNm");
                    String chdSchNm = rs.getString("chdSchNm");
                    String parTblNm = rs.getString("ParTblNm");
                    String chdTblNm = rs.getString("ChdTblNm");
                    int parTblId = rs.getInt("ParTblId");
                    int chdTblId = rs.getInt("ChdTblId");
                    int parColId = rs.getInt("ParColId");
                    int chdColId = rs.getInt("ChdColId");
                    String fkNm = rs.getString("fkNm");
                    Schema parSch = db.getSchema(parSchNm);
                    Table parTbl = parSch.getTable(parTblNm);
                    String parAttIdKey = Integer.toString(parTblId) + "." + Integer.toString(parColId);
                    String parColNm = (String)this.colAttNumsMap_.get(parAttIdKey);
                    Schema chdSch = db.getSchema(chdSchNm);
                    Table chdTbl = chdSch.getTable(chdTblNm);
                    String chdAttIdKey = Integer.toString(chdTblId) + "." + Integer.toString(chdColId);
                    String chdColNm = (String)this.colAttNumsMap_.get(chdAttIdKey);
                    String delActionStr = rs.getString("DELETE_RULE");
                    Integer delActionId = this.getActionId(delActionStr);
                    String updActionStr = rs.getString("UPDATE_RULE");
                    Integer updActionId = this.getActionId(updActionStr);
                    fkDelActionMap.put(fkNm, delActionId);
                    fkUpdActionMap.put(fkNm, updActionId);
                    String[] strArray = new String[]{fkNm, parSchNm, chdSchNm, parTblNm, chdTblNm, parColNm, chdColNm};
                    strArrays.add(strArray);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
            this.itemBldr_.setFkCommentMap(this.fkComments_);
            this.itemBldr_.setFkDelActionMap(fkDelActionMap);
            this.itemBldr_.setFkUpdActionMap(fkUpdActionMap);
            this.itemBldr_.addFks(db, strArrays);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    @Override
    protected Map getFkComments() {
        return this.fkComments_;
    }

    private Integer getActionId(String actionStr) {
        int id = 3;
        if (actionStr.equals("NO ACTION")) {
            id = 3;
        } else if (actionStr.equals("CASCADE")) {
            id = 0;
        } else if (actionStr.equals("RESTRICT")) {
            id = 1;
        } else if (actionStr.equals("SET NULL")) {
            id = 2;
        } else if (actionStr.equals("SET DEFAULT")) {
            id = 4;
        }
        Integer idObj = new Integer(id);
        return idObj;
    }

    @Override
    protected void addViews(DatabaseMetaData dbmd, Database db) {
        this.notifyObserversDisp("engineer.reverse.status.views");
        long start = System.currentTimeMillis();
        Map firstViews = this.getViewFirstPass(dbmd, db);
        Map secondViews = this.getViewsSecondPass(firstViews);
        Iterator it = secondViews.keySet().iterator();
        while (it.hasNext()) {
            try {
                String dotNote = (String)it.next();
                String[] parts = dotNote.split("\\.");
                String schNm = parts[0];
                String vwNm = parts[1];
                String vwSql = (String)secondViews.get(dotNote);
                vwSql = XmlHelper.stripNonValidXMLCharacters(vwSql, "View", vwNm);
                View view = new View(vwNm, vwSql);
                Schema schema = db.getSchema(schNm);
                schema.add(view);
                this.notifyObserversDisp("engineer.reverse.milestone.view.added", dotNote);
            }
            catch (Exception e) {
                this.logError(e, META_CTRL_NM);
                this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            }
        }
        long finish = System.currentTimeMillis();
    }

    protected Map getViewFirstPass(DatabaseMetaData dbmd, Database db) {
        HashMap<String, String> viewMap = new HashMap<String, String>();
        String sql = "SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE " + this.getSchemaFilter("TABLE_SCHEMA", true) + "table_name NOT LIKE 'sys%'";
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String schNm = rs.getString("TABLE_SCHEMA");
                    String vwNm = rs.getString("TABLE_NAME");
                    String dotNote = schNm + "." + vwNm;
                    String fullText = rs.getString("VIEW_DEFINITION");
                    String viewSql = fullText != null ? this.parseViewSql(fullText) : null;
                    viewMap.put(dotNote, viewSql);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
            ConnectionFactory.close(stmt);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return viewMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getViewsSecondPass(Map firstViews) {
        StringBuffer sbSql = new StringBuffer();
        ArrayList<String> queriedNms = new ArrayList<String>();
        for (String dotNote : firstViews.keySet()) {
            Object viewSql = firstViews.get(dotNote);
            boolean requery = false;
            requery = viewSql != null ? this.isTextProbablyCut((String)viewSql) : true;
            if (!requery) continue;
            queriedNms.add(dotNote);
            sbSql.append("exec sp_helptext '" + dotNote + "';\n");
        }
        String sql = sbSql.toString();
        HashMap<String, String> secondViews = new HashMap<String, String>(firstViews);
        if (queriedNms.isEmpty()) {
            return secondViews;
        }
        try {
            Statement stmt = this.conn_.createStatement();
            int count = 0;
            boolean results = stmt.execute(sql);
            while (results) {
                try {
                    String dotNote = (String)queriedNms.get(count);
                    StringBuffer sbText = new StringBuffer();
                    ResultSet rs = stmt.getResultSet();
                    int rsRow = 0;
                    while (rs.next()) {
                        String partialText = rs.getString("Text");
                        sbText.append(partialText);
                    }
                    String viewSql = this.parseViewSql(sbText.toString());
                    viewSql.trim();
                    secondViews.put(dotNote, viewSql);
                    ++rsRow;
                    ConnectionFactory.close(rs);
                    ++count;
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
                finally {
                    results = stmt.getMoreResults();
                }
            }
            ConnectionFactory.close(stmt);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return secondViews;
    }

    private boolean isTextProbablyCut(String text) {
        int textLength = text.length();
        return textLength > 3900 && textLength < 4100;
    }

    private String parseViewSql(String fullText) {
        String viewSql = "";
        int selectIdx = -1;
        try {
            selectIdx = fullText.toLowerCase().indexOf("select");
            viewSql = fullText.substring(selectIdx);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return viewSql;
    }

    private void addProcs(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.procs");
        String sql = "SELECT SPECIFIC_CATALOG, SPECIFIC_SCHEMA, \n\tSPECIFIC_NAME, ROUTINE_DEFINITION \nFROM INFORMATION_SCHEMA.ROUTINES \nWHERE " + this.getSchemaFilter("SPECIFIC_SCHEMA", true) + "SPECIFIC_CATALOG = '" + db.getName() + "' \n" + "\tAND SPECIFIC_NAME NOT LIKE 'sp_%' \n" + "\tAND SPECIFIC_NAME NOT LIKE 'dt_%' \n" + "\tAND SPECIFIC_NAME NOT LIKE 'fn_%' \n" + "ORDER BY SPECIFIC_SCHEMA, SPECIFIC_NAME";
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String comment;
                    String schNm = rs.getString("SPECIFIC_SCHEMA");
                    String procText = rs.getString("ROUTINE_DEFINITION");
                    String procNm = rs.getString("SPECIFIC_NAME");
                    String dotNote = schNm + "." + procNm;
                    Object commentObj = this.procComments_.get(dotNote);
                    String string = comment = commentObj != null ? commentObj.toString() : "";
                    if (this.isTextProbablyCut(procText)) {
                        procText = this.getLongText(procNm);
                    }
                    procText = XmlHelper.stripNonValidXMLCharacters(procText, "Procedure", dotNote);
                    Proc proc = new Proc(procText, comment, "defaultRevEng");
                    Schema schema = db.getSchema(schNm);
                    if (schema != null) {
                        schema.add(proc);
                        this.notifyObserversDisp("engineer.reverse.milestone.proc.added", proc.getName());
                        continue;
                    }
                    LogUtil.logErr("MsSqlMetaCtrl.Error adding proc to schema. ---------");
                    LogUtil.logErr("MsSqlMetaCtrl.procNm: " + this.getNullSafe(procNm));
                    LogUtil.logErr("MsSqlMetaCtrl.schemaNm: " + this.getNullSafe(schNm));
                    LogUtil.logErr("MsSqlMetaCtrl.procText: " + this.getNullSafe(procText));
                    LogUtil.logErr("MsSqlMetaCtrl --------------------------------------");
                    this.notifyObserversDisp("engineer.reverse.milestone.err", "Adding proc: " + this.getNullSafe(procNm));
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private String getSchemaFilter(String schFieldFullNm, boolean addTrailingAnd) {
        return this.ignoreCtrl.getIgnoreSchStr(schFieldFullNm, addTrailingAnd);
    }

    private String getNullSafe(String str) {
        return StrHelper.getNullSafeString(str);
    }

    private String getLongText(String itemNm) {
        String sql = "exec sp_helptext '" + itemNm + "';\n";
        StringBuffer sbText = new StringBuffer();
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String partialText = rs.getString("Text");
                    sbText.append(partialText);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return sbText.toString();
    }

    private String getUserName() {
        String userName = "";
        String userNameRaw = this.getConfig().getUserName();
        userName = Validator.isStringValid(userNameRaw) && !userNameRaw.equalsIgnoreCase("sa") ? userNameRaw : "dbo";
        return userName;
    }

    private void addTriggers(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.triggers");
        this.addTriggersDisp(db);
    }

    private String getTriggerTextSlow(String trgDotNote) {
        String trgSql = null;
        String sql = "sp_helptext '" + trgDotNote + "'";
        try {
            StringBuilder sb = new StringBuilder();
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs != null && rs.next()) {
                sb.append(rs.getString("Text"));
            }
            ConnectionFactory.close(stmt);
            String rawText = sb.toString();
            trgSql = this.parseTriggerText(rawText);
            trgSql = XmlHelper.stripNonValidXMLCharacters(trgSql, "Trigger", trgDotNote);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return trgSql;
    }

    @Override
    public Version getDbmsVersion() throws Exception {
        if (this.dbmsVersion_ == null) {
            this.loadVersion();
        }
        return this.dbmsVersion_;
    }

    private void loadVersion() throws Exception {
        boolean createdOwnConn = false;
        this.dbmsVersionStr_ = "unknown";
        this.dbmsVersion_ = null;
        String sql = "SELECT @@version AS 'version';";
        try {
            if (this.conn_ == null) {
                this.conn_ = ConnectionFactory.getConnection(this.getConfig());
                createdOwnConn = true;
            }
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                try {
                    String dbmsVersionStr = rs.getString("version");
                    this.dbmsVersion_ = this.parseVersion(dbmsVersionStr);
                    this.getConfig().setVersion(this.dbmsVersion_);
                }
                catch (Exception e) {
                    String errMsg = "Sql Server version could not be parsed from: " + this.dbmsVersionStr_;
                    this.logError(errMsg, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", errMsg);
                }
            }
            ConnectionFactory.close(rs);
            ConnectionFactory.close(stmt);
            if (createdOwnConn) {
                ConnectionFactory.close(this.conn_);
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private Version parseVersion(String str) {
        return SqlSvrVersionHelper.parseVersionFromQueryStr(str);
    }

    private void addTriggersDisp(Database db) {
        StringBuffer sb = new StringBuffer();
        for (String dotNote : this.tableNms_) {
            sb.append("SELECT '" + dotNote + "' AS 'tblNm';\n");
            sb.append("exec sp_helptrigger '" + dotNote + "';\n");
        }
        String sql = sb.toString();
        if (sql.length() == 0) {
            return;
        }
        try {
            String lastTblNmDotNote = "";
            Statement stmt = this.conn_.createStatement();
            boolean results = stmt.execute(sql);
            while (results) {
                ResultSet rs = stmt.getResultSet();
                int colCount = JdbcUtil.getColumnCount(rs);
                if (colCount == 1) {
                    if (rs.next()) {
                        lastTblNmDotNote = rs.getString(1);
                    }
                } else {
                    Schema schema = db.getSchemaFromDotNote(lastTblNmDotNote);
                    Table table = db.getTableFromDotNote(lastTblNmDotNote);
                    ArrayList tableTriggers = new ArrayList();
                    while (rs.next()) {
                        try {
                            String trgName = rs.getString("trigger_name");
                            boolean onDelete = rs.getBoolean("isdelete");
                            boolean onInsert = rs.getBoolean("isinsert");
                            boolean onUpdate = rs.getBoolean("isupdate");
                            String dotNote = schema.getName() + "." + trgName;
                            String trgSql = this.getTriggerTextSlow(dotNote);
                            Trigger newTrg = new Trigger(trgName, onDelete, onInsert, onUpdate, trgSql, false, false);
                            ITestResult result = table.add(newTrg);
                            this.checkResult(result);
                            this.notifyObserversDisp("engineer.reverse.milestone.trigger.added", dotNote);
                        }
                        catch (Exception e) {
                            this.logError(e, META_CTRL_NM);
                            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                        }
                    }
                }
                ConnectionFactory.close(rs);
                results = stmt.getMoreResults();
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private String parseTriggerText(String fullText) {
        String splitStr;
        String sqlText = PARSE_FAILED;
        String ucText = fullText.toUpperCase();
        String cleanText = ucText;
        int splitIndex = cleanText.indexOf(splitStr = " AS ");
        if (splitIndex < 0) {
            splitStr = " AS\n";
            splitIndex = cleanText.indexOf(splitStr);
        }
        if (splitIndex < 0) {
            splitStr = "\nAS\n";
            splitIndex = cleanText.indexOf(splitStr);
        }
        if (splitIndex < 0) {
            splitStr = "\r\nAS\r\n";
            splitIndex = cleanText.indexOf(splitStr);
        }
        if (splitIndex > 0) {
            sqlText = fullText.substring(splitIndex + splitStr.length());
        }
        return sqlText;
    }

    private String parseTriggerName(String fullText) {
        String name = "Error - parse failed";
        String createStr = " trigger ";
        String fullTextLc = fullText.toLowerCase();
        LogUtil.logMsg("sqlMeta.fullTextLc: " + fullTextLc);
        int createLength = createStr.length();
        int createEndPos = fullTextLc.indexOf(createStr) + createLength;
        int endSpacePos = fullTextLc.indexOf(" ", createEndPos);
        int endCrPos = fullTextLc.indexOf("\n", createEndPos);
        int nameEndPos = endSpacePos;
        if (endCrPos > 0 && endCrPos < endSpacePos) {
            nameEndPos = endCrPos;
        }
        String rawNm = fullText.substring(createEndPos, nameEndPos).trim();
        LogUtil.logMsg("sqlMeta.createEndPos: " + createEndPos + ", nameEndPos: " + nameEndPos + ", nm: " + rawNm);
        String firstChar = rawNm.substring(0, 1);
        name = firstChar.equals("[") ? rawNm.substring(1, rawNm.length() - 1) : rawNm;
        return name;
    }
}

