/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc.validators;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import java.util.ArrayList;

public class JdbcConfigValidator {
    public static final String HAS_A_LEADING_SPACE = " has a leading space. ";
    public static final String HAS_A_TRAILING_SPACE = " has a trailing space. ";
    public static final String HAS_NO_EXTRA_SPACES_DETAIL = " has no extra spaces. ";
    private JdbcConfig cfg;
    public static final String SUCCESS_TITLE = "Connection Config Successfully Validated";
    public static final String FAILED_TITLE = "Connection Config Validation Failed";
    public static final String HAS_EXTRA_SPACES = "Has Extra Spaces";
    public static final String HAS_NO_EXTRA_SPACES = "No Extra Spaces";

    public ITestResult validate(JdbcConfig cfg) {
        this.cfg = cfg;
        ArrayList<ITestResult> results = new ArrayList<ITestResult>();
        results.add(this.checkExtraSpacesDisp());
        ITestResult finalResult = DataEntryResult.aggregateResults(results, SUCCESS_TITLE, FAILED_TITLE);
        return finalResult;
    }

    private ITestResult checkExtraSpacesDisp() {
        ArrayList<ITestResult> results = new ArrayList<ITestResult>();
        results.add(this.checkExtraSpaces(this.cfg.getServer(), "Server"));
        results.add(this.checkExtraSpaces(this.cfg.getObjectInstanceName(), "Database"));
        results.add(this.checkExtraSpaces(Integer.toString(this.cfg.getPort()), "Port"));
        results.add(this.checkExtraSpaces(this.cfg.getUserName(), "User Name"));
        results.add(this.checkExtraSpaces(this.cfg.getOptionalParams(), "OptParam"));
        results.add(this.checkExtraSpaces(this.cfg.getDsn(), "Dsn"));
        ITestResult aggregateResult = DataEntryResult.aggregateResults(results, HAS_NO_EXTRA_SPACES, HAS_EXTRA_SPACES);
        return aggregateResult;
    }

    private ITestResult checkExtraSpaces(String fieldText, String fieldNm) {
        int length;
        boolean passed = true;
        DataEntryResult result = new DataEntryResult(passed, HAS_NO_EXTRA_SPACES, fieldNm + HAS_NO_EXTRA_SPACES_DETAIL);
        if (fieldText.length() == 0) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        if (fieldText.substring(0, 1).equals(" ")) {
            passed = false;
            sb.append(fieldNm).append(HAS_A_LEADING_SPACE);
        }
        if (fieldText.substring((length = fieldText.length()) - 1, length).equals(" ")) {
            passed = false;
            sb.append(fieldNm).append(HAS_A_TRAILING_SPACE);
        }
        if (!passed) {
            result = new DataEntryResult(passed, HAS_EXTRA_SPACES, sb.toString());
        }
        return result;
    }
}

