/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.coreclasses.script.ISendReceiveDriver;
import com.harrand.coreclasses.text.scanner.ISingleWordScanner;
import com.harrand.coreclasses.text.scanner.SqlKeywordScanner;
import com.harrand.coregui.Icons;
import com.harrand.dbwrench.db.JdbcHelper;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrench.translate.QueryTranslation;
import com.harrand.dbwrench.translate.TranslatorCtrl;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

@Deprecated
public final class JdbcSendReceiveDriver
implements ISendReceiveDriver,
IObserver {
    private Connection conn_;
    private IConnectionConfig config_;
    private String inMessage_;
    private boolean errorFlag_ = false;
    private IObservable observable_;
    private Object[][] data_;
    private TranslatorCtrl translatorCtrl_ = new TranslatorCtrl();
    private DbUser user_;
    public static final String TITLE = App.getRes("sql.comm.label");

    public JdbcSendReceiveDriver(DbUser user) {
        this.observable_ = new BasicObservable();
        this.user_ = user;
        this.user_.addObserver(this);
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void closeConnection() throws Exception {
        ConnectionFactory.close(this.conn_);
    }

    @Override
    public String getInMessage() {
        return this.inMessage_;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public boolean getErrorFlag() {
        return this.errorFlag_;
    }

    @Override
    public void openConnection() throws Exception {
        if (this.config_ == null) {
            throw new Exception(App.getRes("connection.config.not.specified") + "\n" + "Use the menu: Tools > Connections to define server " + "connections.");
        }
        this.conn_ = ConnectionFactory.getConnection(this.config_);
        if (this.conn_.isClosed()) {
            throw new Exception(App.getRes("connection.did.not.open.msg"));
        }
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IConnectionConfig.class.getName())) {
            this.notifyObservers(chain);
        }
    }

    @Override
    public void sendMessage(String msg) {
        String translationDesc = "";
        try {
            String sql;
            JdbcConfig jdbcConfig;
            Dbms toDbms;
            QueryTranslation translation;
            this.clearResults();
            if (!this.isConnected()) {
                this.openConnection();
            }
            if ((translation = this.translatorCtrl_.getTranslation(msg, toDbms = (jdbcConfig = (JdbcConfig)this.config_).getDbms(), jdbcConfig)) != null) {
                sql = translation.getQuery().getQueryText();
                translationDesc = translation.toString();
            } else {
                sql = msg;
            }
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            this.buildDataArray(rs, msg, translationDesc);
            this.errorFlag_ = false;
        }
        catch (Exception e) {
            this.inMessage_ = FileHelper.getRes("err.title") + ": \n" + e.getMessage() + "\n" + App.getRes("command.sent.msg") + translationDesc + ": \n" + msg;
            this.data_ = this.getEmptyDataMatrix();
            this.errorFlag_ = true;
        }
        this.notifyObservers(new UpdateChain(this.data_));
    }

    private void buildDataArray(ResultSet rs, String msg, String translationDesc) throws Exception {
        String translationStr = Validator.isStringValid(translationDesc) ? " (" + translationDesc + ") " : "";
        String finishedStr = App.getRes("command.finished.title") + translationStr;
        if (rs != null) {
            this.data_ = JdbcHelper.rsToMatrix(rs);
            this.inMessage_ = this.data_.length > 1 && this.data_[0].length > 0 ? finishedStr + ": \n" + msg : finishedStr + " [" + App.getRes("empty.resultset.msg") + "]" + ": \n" + msg;
        } else {
            this.inMessage_ = finishedStr + ": \n" + msg;
            this.data_ = this.getEmptyDataMatrix();
        }
    }

    private Object[][] getEmptyDataMatrix() {
        return new Object[][]{{" "}};
    }

    private void clearResults() {
        this.inMessage_ = "";
        this.errorFlag_ = false;
    }

    @Override
    public void setConnectionConfig(IConnectionConfig config) throws Exception {
        if (this.isConnected()) {
            this.closeConnection();
        }
        this.config_ = config;
        this.openConnection();
    }

    @Override
    public Object[][] getInData() {
        return this.data_;
    }

    @Override
    public boolean isConnected() {
        boolean retval;
        try {
            retval = this.conn_ != null && !this.conn_.isClosed();
        }
        catch (Exception e) {
            retval = false;
            LogUtil.printStackTrace(e);
        }
        return retval;
    }

    @Override
    public List getConnectionConfigs() {
        List list = this.user_.values(JdbcConfig.clazz());
        if (list == null) {
            return new ArrayList();
        }
        return list;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.SQL_COMM;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return App.getRes("sql.comm.tooltip");
    }

    @Override
    public ISingleWordScanner getKeywordScanner() {
        return SqlKeywordScanner.instance();
    }
}

