/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.coreclasses.element.InternetLink;
import com.harrand.coreclasses.interfaces.ITestCtrl;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.dbwrench.db.JdbcHelper;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.util.FileHelper;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public final class JdbcConfigTestCtrl
implements ITestCtrl {
    public static final String FAQ_URL = "http://www.dbwrench.com/faq/faq_base.shtml#connections";
    public static final String SAMPLES_URL = "http://www.dbwrench.com/faq/sample_conns/conns_sample_base.shtml";
    private JdbcConfig config_;

    public JdbcConfigTestCtrl(JdbcConfig config) {
        this.config_ = config;
    }

    @Override
    public void doTest() throws Exception {
        this.validateObj(this.config_);
        this.testConnection(this.config_);
    }

    private void testConnection(IConnectionConfig config) throws Exception {
        try {
            Connection conn = ConnectionFactory.getConnection(config);
            ConnectionFactory.close(conn);
        }
        catch (Exception e) {
            String cleanMsg = JdbcHelper.cleanMySqlConnErrMsg(e.getMessage());
            throw new Exception(cleanMsg);
        }
    }

    @Override
    public String getTitle() {
        return FileHelper.getResource("test.connection.title");
    }

    private void validateObj(Object obj) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException(FileHelper.getResource("connection.not.defined"));
        }
    }

    @Override
    public List<InternetLink> getHelpLinks() {
        ArrayList<InternetLink> links = new ArrayList<InternetLink>();
        links.add(new InternetLink("View sample connection configurations", SAMPLES_URL));
        links.add(new InternetLink("View connection configuration FAQ", FAQ_URL));
        return links;
    }
}

