/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.coreclasses.db.DbConfig;
import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.IDotNotable;
import com.harrand.coreclasses.interfaces.IIconable;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.coreclasses.text.escape.IStrEscapeCtrl;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.element.schema.SchemaIgnoreCtrl;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.IDbmsFunctionality;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.metaData.JdbcMetaDataCtrl;
import com.harrand.dbwrench.metaData.MsSqlServerMetaDataCtrl;
import com.harrand.dbwrench.metaData.MySqlMetaDataCtrl;
import com.harrand.dbwrench.metaData.OdbcAccessMetaDataCtrl;
import com.harrand.dbwrench.metaData.OracleMetaDataCtrl;
import com.harrand.dbwrench.metaData.PostgreSqlMetaDataCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.script.compare.BasicDbmsCompareCtrl;
import com.harrand.dbwrench.script.compare.IDbmsCompareCtrl;
import com.harrand.dbwrench.script.compare.MsAccessCompareCtrl;
import com.harrand.dbwrench.script.compare.MySqlCompareCtrl;
import com.harrand.dbwrench.script.compare.OracleCompareCtrl;
import com.harrand.dbwrench.script.compare.PsqlCompareCtrl;
import com.harrand.dbwrench.script.compare.SqlSvrCompareCtrl;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.dbwrench.script.converter.MsAccessDataTypeConverter;
import com.harrand.dbwrench.script.converter.MsSqlServerDataTypeConverter;
import com.harrand.dbwrench.script.converter.MySqlDataTypeConverter;
import com.harrand.dbwrench.script.converter.OracleDataTypeConverter;
import com.harrand.dbwrench.script.converter.PostgreSqlDataTypeConverter;
import com.harrand.dbwrench.script.svrSync.ISvrSyncCtrl;
import com.harrand.dbwrench.script.svrSync.MySqlSvrSyncCtrl;
import com.harrand.dbwrench.script.svrSync.PsqlSvrSyncCtrl;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class JdbcConfig
implements IConnectionConfig,
Identifiable,
IIconable,
IDbmsFunctionality,
IXmlable,
IConfirmRemove {
    private Dbms dbms_;
    private String server_;
    private String dsn_;
    private String dbName_;
    private String userName_;
    private String pWord_;
    private String driverClassName_;
    private String optionalParams_ = "";
    private int port_;
    private boolean ssl_ = false;
    private Version version_ = null;
    private SchemaIgnoreCtrl schemaIgnoreCtrl = new SchemaIgnoreCtrl();
    private PostgreSqlDataTypeConverter psqlDataTypeConv_;
    private static MsSqlServerDataTypeConverter msSqlServerDataTypeConverter__ = new MsSqlServerDataTypeConverter();
    private static MsAccessDataTypeConverter msAccessDataTypeConverter__ = new MsAccessDataTypeConverter();
    private static MySqlDataTypeConverter mysqlDataTypeConverter__ = new MySqlDataTypeConverter();
    private static OracleDataTypeConverter oracleDataTypeConv_ = new OracleDataTypeConverter();
    public static List genericConfigs__ = null;
    public static final String XML_PLURAL = "JdbcConfigs";
    public static final String LOCAL_HOST = "localhost";
    public static final String HD_NAME = "Name";
    public static final String HD_DBMS = "DBMS";
    public static final String XML_DBMS = "DbmsName";
    public static final String HD_SERVER = "Server";
    public static final String HD_DB_NAME = "Database";
    public static final String HD_DSN = "Dsn";
    public static final String HD_DRIVER = "Driver";
    public static final String HD_USER_NAME = "User Name";
    public static final String XML_USER_NAME = "UserName";
    public static final String HD_PASSWORD = "Password";
    public static final String HD_OPTIONAL = "OptParam";
    public static final String HD_PORT = "Port";
    public static final String HD_SSL = "ssl";
    public static final Version VER_PG_PROC_ARG_NMS = new Version("8.0.0");

    public JdbcConfig(String dbmsName, String server, String dbName, String dsn, String userName, String passWord, int port, String driverClassName) throws IllegalArgumentException {
        this.dbms_ = Dbms.getDbms(dbmsName);
        this.server_ = server;
        this.dbName_ = dbName;
        this.dsn_ = dsn;
        this.userName_ = userName;
        this.pWord_ = passWord;
        this.port_ = port;
        this.driverClassName_ = driverClassName;
        this.psqlDataTypeConv_ = new PostgreSqlDataTypeConverter(this);
        this.checkValues();
    }

    public void setSSL(boolean ssl) {
        this.ssl_ = ssl;
    }

    public void setOptionalParams(String optionalParams) {
        this.optionalParams_ = optionalParams;
    }

    private void checkValues() throws IllegalArgumentException {
        if (!Validator.isStringValid(this.driverClassName_)) {
            throw new IllegalArgumentException(App.getResource("err.jdbc.driver.not.specified"));
        }
        boolean isAccess = this.dbms_.getName().equalsIgnoreCase("MS Access");
        if (isAccess && !this.isGeneric() && !Validator.isStringValid(this.dsn_)) {
            throw new IllegalArgumentException("An ODBC DSN name must be specified");
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdbcConfig)) {
            return false;
        }
        JdbcConfig other = (JdbcConfig)o;
        if (other.getDbmsId() != this.getDbmsId()) {
            return false;
        }
        if (!other.getServer().equals(this.getServer())) {
            return false;
        }
        if (!other.getObjectInstanceName().equals(this.getObjectInstanceName())) {
            return false;
        }
        if (!other.getDsn().equals(this.getDsn())) {
            return false;
        }
        if (!other.getUserName().equals(this.getUserName())) {
            return false;
        }
        if (!other.getPassword().equals(this.getPassword())) {
            return false;
        }
        if (!other.getOptionalParams().equals(this.getOptionalParams())) {
            return false;
        }
        if (other.getPort() != this.getPort()) {
            return false;
        }
        return other.getDriverClassName().equals(this.getDriverClassName());
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    public static String clazz() {
        return "JdbcConfig";
    }

    public Dbms getDbms() {
        return this.dbms_;
    }

    public String getDsn() {
        return this.dsn_;
    }

    public String getOptionalParams() {
        return this.optionalParams_;
    }

    @Override
    public boolean getSSL() {
        return this.ssl_;
    }

    public SchemaIgnoreCtrl getSchemaIgnoreCtrl() {
        return this.schemaIgnoreCtrl;
    }

    public void setSchemaIgnoreCtrl(SchemaIgnoreCtrl schemaIgnoreCtrl) {
        this.schemaIgnoreCtrl = schemaIgnoreCtrl;
    }

    public String toString() {
        String str = this.dbms_.getName() + ": ";
        str = this.dsn_.length() > 0 ? str + this.dsn_ : str + "\\\\" + this.server_ + "\\" + this.getObjectInstanceName();
        return str;
    }

    public String toStringDetailed() {
        StringBuffer sb = new StringBuffer(this.dbms_.getName());
        sb.append(", ").append(this.getServer());
        sb.append(", ").append(this.getObjectInstanceName());
        sb.append(", ").append(this.getDsn());
        sb.append(", ").append(this.getUserName());
        sb.append(", ").append(this.getPassword());
        sb.append(", ").append(this.getPort());
        sb.append(", ").append(this.getDriverClassName());
        sb.append(", ").append(this.getSSL());
        sb.append(", ").append(this.getOptionalParams());
        return sb.toString();
    }

    public static JdbcConfig fromXml(Element element) {
        String dbmsName = XmlHelper.getFirstElementValue(element, XML_DBMS);
        String server = XmlHelper.getFirstElementValue(element, HD_SERVER);
        String dbName = XmlHelper.getFirstElementValue(element, HD_DB_NAME);
        String dsn = XmlHelper.getFirstElementValue(element, HD_DSN);
        String driverClassName = XmlHelper.getFirstElementValue(element, HD_DRIVER);
        String userName = XmlHelper.getFirstElementValue(element, XML_USER_NAME);
        String pwd = XmlHelper.getFirstElementValue(element, HD_PASSWORD);
        String optionalParams = XmlHelper.getFirstElementValue(element, HD_OPTIONAL);
        int port = XmlHelper.getElementValueInt(XmlHelper.getFirstElementByTagName(element, HD_PORT));
        boolean ssl = XmlHelper.getAttrBool(element, HD_SSL);
        JdbcConfig newCfg = new JdbcConfig(dbmsName, server, dbName, dsn, userName, pwd, port, driverClassName);
        newCfg.setSSL(ssl);
        newCfg.setOptionalParams(optionalParams);
        Element elmIgnoreCtrl = XmlHelper.getFirstElementByTagName(element, "ignoreSchemas");
        if (elmIgnoreCtrl != null) {
            newCfg.setSchemaIgnoreCtrl(SchemaIgnoreCtrl.fromXml(elmIgnoreCtrl));
        }
        return newCfg;
    }

    @Override
    public Properties getProps() {
        Properties props = new Properties();
        props.setProperty("user", this.getUserName());
        props.setProperty("password", this.getPassword());
        this.addSqlSvrOptProps(props);
        return props;
    }

    private void addSqlSvrOptProps(Properties props) {
        if (this.isSqlSvr() && this.areOptionalParametersSet()) {
            String[] params = this.optionalParams_.split(";");
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                String[] parts = param.split("=");
                if (parts.length == 2) {
                    String key = parts[0];
                    String value = parts[1];
                    props.setProperty(key, value);
                    continue;
                }
                LogUtil.logErr("Connection Config warning: SQL Server optional parameters names and values need to be separated by '='. \n\t These optional parameters seem invalid: " + param);
            }
        }
    }

    public IMetaDataCtrl getMetaDataCtrl() {
        IMetaDataCtrl ctrl = null;
        String dbmsName = this.dbms_.getName();
        if (dbmsName.equals("MySql")) {
            ctrl = new MySqlMetaDataCtrl(this);
        } else if (dbmsName.equals("PostgreSql")) {
            ctrl = new PostgreSqlMetaDataCtrl(this);
        } else if (dbmsName.equals("MS Access")) {
            ctrl = this.getMsAccessMetaDataCtrl();
        } else if (dbmsName.equals("MS SQL Server")) {
            ctrl = new MsSqlServerMetaDataCtrl(this);
        } else if (dbmsName.equals("Oracle")) {
            ctrl = new OracleMetaDataCtrl(this);
        } else {
            LogUtil.logErr("JdbcConfig.getMetaDataCtrl dbmsName: " + dbmsName + " did not match known Dbms names.");
        }
        return ctrl;
    }

    private IMetaDataCtrl getMsAccessMetaDataCtrl() {
        if (this.isOdbcDriver()) {
            return new OdbcAccessMetaDataCtrl(this);
        }
        return new JdbcMetaDataCtrl(this);
    }

    public boolean canConnect() {
        boolean success = false;
        try {
            Connection conn = ConnectionFactory.getConnection(this);
            if (conn != null) {
                success = true;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return success;
    }

    public boolean isOdbcDriver() {
        return this.driverClassName_.toUpperCase().indexOf("ODBC") >= 0;
    }

    public DbConfig asDbConfig() {
        DbConfig dbConfig = new DbConfig(this.dbms_.getId(), this.getServer(), this.getObjectInstanceName(), this.getUserName(), this.getPassword());
        return dbConfig;
    }

    public void setVersion(Version version) {
        this.version_ = version;
    }

    public Version getVersion() {
        return this.version_;
    }

    public static JdbcConfig getGenericConfig(String dbmsName) {
        Dbms dbms = Dbms.getDbms(dbmsName);
        String driverName = dbms.getDefaultDriverName();
        JdbcConfig cfg = new JdbcConfig(dbmsName, "[Generic]", "", "", "", "", 0, driverName);
        if (dbmsName != "MS Access") {
            cfg.setVersion(JdbcConfig.getDefaultVersion(dbmsName));
        }
        return cfg;
    }

    public static List getGenericConfigs() {
        if (genericConfigs__ == null) {
            genericConfigs__ = new ArrayList();
            genericConfigs__.add(JdbcConfig.getGenericConfig("PostgreSql"));
            genericConfigs__.add(JdbcConfig.getGenericConfig("MySql"));
            genericConfigs__.add(JdbcConfig.getGenericConfig("MS SQL Server"));
            genericConfigs__.add(JdbcConfig.getGenericConfig("Oracle"));
            genericConfigs__.add(JdbcConfig.getGenericConfig("MS Access"));
        }
        return genericConfigs__;
    }

    private static Version getDefaultVersion(String dbmsName) {
        Version version = null;
        if (dbmsName.equals("MS SQL Server")) {
            version = new Version("2005");
        } else if (dbmsName.equals("PostgreSql")) {
            version = new Version("8.0");
        } else if (dbmsName.equals("MySql")) {
            version = new Version("5.0");
        }
        return version;
    }

    public boolean isGeneric() {
        return this.getServer().equalsIgnoreCase("[Generic]");
    }

    public boolean isSqlSvr() {
        return this.dbms_.isSqlSvr();
    }

    public boolean isPsql() {
        return this.dbms_.isPsql();
    }

    public boolean isMySql() {
        return this.dbms_.isMySql();
    }

    public boolean isOracle() {
        return this.dbms_.isOracle();
    }

    public boolean isMsAccess() {
        return this.dbms_.isMsAccess();
    }

    public boolean isSqlSvr2005() {
        boolean isSqll2005 = false;
        if (this.isSqlSvr() && this.version_ != null && this.version_.getLevel1() == 2005) {
            isSqll2005 = true;
        }
        return isSqll2005;
    }

    public boolean isSqlSvr2000() {
        boolean isMatch = false;
        if (this.isSqlSvr() && this.version_ != null && this.version_.getLevel1() == 2000) {
            isMatch = true;
        }
        return isMatch;
    }

    public boolean isPsql81() {
        boolean is81 = false;
        if (this.isPsql() && this.version_ != null && this.version_.getLevel1() == 8 && this.version_.getLevel2() == 1) {
            is81 = true;
        }
        return is81;
    }

    public boolean isPsql8() {
        boolean isMatch = false;
        if (this.isPsql() && this.version_ != null && this.version_.getLevel1() == 8) {
            isMatch = true;
        }
        return isMatch;
    }

    public boolean isPsql83() {
        boolean isMatch = false;
        if (this.isPsql() && this.version_ != null && this.version_.getLevel1() == 8 && this.version_.getLevel2() == 3) {
            isMatch = true;
        }
        return isMatch;
    }

    public boolean isPsql9() {
        boolean isMatch = false;
        if (this.isPsql() && this.version_ != null && this.version_.getLevel1() == 9) {
            isMatch = true;
        }
        return isMatch;
    }

    public boolean isMySql5() {
        boolean isVersion = false;
        if (this.isMySql() && this.version_ != null && this.version_.getLevel1() == 5) {
            isVersion = true;
        }
        return isVersion;
    }

    public boolean isMySql55() {
        boolean isVersion = false;
        if (this.isMySql() && this.version_ != null && this.version_.getLevel1() == 5 && this.version_.getLevel2() == 5) {
            isVersion = true;
        }
        return isVersion;
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName_;
    }

    @Override
    public String getServer() {
        return this.server_;
    }

    @Override
    public String getObjectInstanceName() {
        return this.dbName_;
    }

    @Override
    public String getUserName() {
        return this.userName_;
    }

    @Override
    public String getPassword() {
        return this.pWord_;
    }

    @Override
    public int getPort() {
        return this.port_;
    }

    public static String getClassName() {
        return JdbcConfig.clazz();
    }

    @Override
    public String getConnectionString() {
        int id = this.dbms_.getId();
        String str = "jdbc:";
        String portStr = this.getPortStr();
        switch (id) {
            case 2: {
                str = str + "odbc:" + this.dsn_;
                break;
            }
            case 3: {
                str = str + "jtds:sqlserver://" + this.server_ + portStr + ";databasename=" + this.dbName_;
                break;
            }
            case 0: {
                str = str + "mysql://" + this.server_ + portStr + "/" + this.dbName_;
                str = this.attachOptParams(str);
                break;
            }
            case 1: {
                str = str + "postgresql://" + this.server_ + portStr + "/" + this.dbName_;
                str = this.attachOptParams(str);
                break;
            }
            case 4: {
                boolean isConnViaService = this.isOracleConnViaService(this.server_);
                String delim = isConnViaService ? "/" : ":";
                str = str + "oracle:thin:@" + this.server_ + portStr + delim + this.dbName_;
                str = this.attachOptParams(str);
                break;
            }
            default: {
                StrHelper.throwProgrammingException("JdbcConfig.getConnectionString() - Unrecognized Dbms Id.");
            }
        }
        return str;
    }

    private boolean areOptionalParametersSet() {
        return Validator.isStringValid(this.optionalParams_);
    }

    private String attachOptParams(String str) {
        String outStr = str;
        if (this.areOptionalParametersSet()) {
            String delim = ";";
            if (this.isMySql()) {
                delim = "?";
            }
            outStr = str + delim + this.optionalParams_;
        }
        return outStr;
    }

    private String getPortStr() {
        return this.port_ > 0 ? ":" + this.port_ : "";
    }

    public String getReplaceStr() {
        return this.dbms_.getReplaceStr();
    }

    public ISvrSyncCtrl getSvrSyncCtrl() {
        ISvrSyncCtrl ctrl = null;
        switch (this.getDbmsId()) {
            case 2: {
                ctrl = null;
                break;
            }
            case 3: {
                ctrl = null;
                break;
            }
            case 0: {
                ctrl = new MySqlSvrSyncCtrl(this);
                break;
            }
            case 1: {
                ctrl = new PsqlSvrSyncCtrl(this);
                break;
            }
            default: {
                StrHelper.throwProgrammingException("JdbcConfig.getSvrSyncCtrl() - Unrecognized Dbms Id.");
            }
        }
        return ctrl;
    }

    public String getProcWord() {
        return this.dbms_.getProcWord();
    }

    public String getFormattedName(INamed named) {
        return this.dbms_.getFormattedName(named);
    }

    public String getForEngNm(Identifiable idf) {
        if (idf instanceof ISchemaObj && this.supportsSchemas()) {
            boolean doDblQuote = this.getDoDblQuote(idf);
            IStrEscapeCtrl strEscapeCtrl = this.getStrEscapeCtrl();
            ISchemaObj schemObj = (ISchemaObj)((Object)idf);
            String forEngNm = schemObj.getForEngNm(idf.getName(), this.supportsSchemas(), doDblQuote, strEscapeCtrl);
            return forEngNm;
        }
        if (this.isOracle() && idf instanceof Index) {
            Index idx = (Index)idf;
            Schema sch = idx.getTable().getSchema();
            return this.getFormattedName(sch.getName() + "." + idx.getName());
        }
        return this.getFormattedName(idf.getName());
    }

    private IStrEscapeCtrl getStrEscapeCtrl() {
        return this.dbms_.getStrEscapeCtrl();
    }

    public String getForEngNmMaybeDotNoted(Identifiable idf) {
        String rawNm = idf.getName();
        String idfNmOnly = null;
        boolean doDblQuote = this.getDoDblQuote(idf);
        if (rawNm.indexOf(".") > 0) {
            String[] parts = rawNm.split("\\.");
            idfNmOnly = parts[0];
        } else {
            idfNmOnly = rawNm;
        }
        if (idf instanceof ISchemaObj && this.supportsSchemas()) {
            ISchemaObj schemObj = (ISchemaObj)((Object)idf);
            IStrEscapeCtrl strEscapeCtrl = this.getStrEscapeCtrl();
            String forEngNm = schemObj.getForEngNm(idfNmOnly, this.supportsSchemas(), doDblQuote, strEscapeCtrl);
            return forEngNm;
        }
        return this.getFormattedName(idfNmOnly);
    }

    private boolean getDoDblQuote(Identifiable idf) {
        String fullNm = idf instanceof IDotNotable ? ((IDotNotable)((Object)idf)).getDotNote() : idf.getName();
        return this.dbms_.checkDblQuotePsqlNm(fullNm);
    }

    public boolean getDblEnquoteOn() {
        return this.dbms_.getDblEnquoteOn();
    }

    public String getFormattedName(String name) {
        return this.dbms_.getFormattedName(name);
    }

    public String getFormattedCsv(List names) {
        return this.dbms_.getFormattedCsv(names);
    }

    public String getFormattedIndexColumnNamesCsv(Index index) {
        ArrayList<String> colNms = new ArrayList<String>();
        for (IIndexColumn indexColumn : index.getIndexColumns()) {
            String inIndexDdl;
            if (indexColumn == null || (inIndexDdl = indexColumn.getInIndexDdl()) == null) continue;
            colNms.add(inIndexDdl);
        }
        return this.dbms_.getFormattedCsv(colNms);
    }

    public String getNowStr() {
        return this.dbms_.getNowStr();
    }

    @Override
    public String getMapName() {
        return JdbcConfig.clazz();
    }

    @Override
    public String getName() {
        return this.getConnectionString();
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public String getDesc() {
        String desc = this.dbms_.getName() + ":" + this.server_ + this.getPortStr() + "/" + this.dbName_;
        return desc;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(this.getMapName());
        XmlHelper.addElementSimple(doc, element, HD_NAME, this.getName());
        XmlHelper.addElementSimple(doc, element, XML_DBMS, this.dbms_.getName());
        XmlHelper.addElementSimple(doc, element, HD_SERVER, this.server_);
        XmlHelper.addElementSimple(doc, element, HD_DB_NAME, this.dbName_);
        XmlHelper.addElementSimple(doc, element, HD_DSN, this.dsn_);
        XmlHelper.addElementSimple(doc, element, HD_DRIVER, this.driverClassName_);
        XmlHelper.addElementSimple(doc, element, XML_USER_NAME, this.userName_);
        XmlHelper.addElementSimple(doc, element, HD_PASSWORD, this.pWord_);
        XmlHelper.addElementSimple(doc, element, HD_PORT, this.port_);
        XmlHelper.addElementSimple(doc, element, HD_OPTIONAL, this.optionalParams_);
        XmlHelper.setAttr(element, HD_SSL, this.ssl_);
        element.appendChild(this.schemaIgnoreCtrl.asXmlElement(doc));
        return element;
    }

    @Override
    public URL getIconUrl() {
        return this.dbms_.getIconUrl();
    }

    @Override
    public String getAutoNumberSql(Column column, int seed, int increment) {
        return this.dbms_.getAutoNumberSql(column, seed, increment);
    }

    @Override
    public String getLimitOneSql(String tableName) {
        return this.dbms_.getLimitOneSql(tableName);
    }

    @Override
    public boolean supportsForeignKey() {
        return this.dbms_.supportsForeignKey();
    }

    @Override
    public boolean supportsStoredProcedure() {
        return this.dbms_.supportsStoredProcedure();
    }

    public boolean supportsCustomTypes() {
        return this.dbms_.supportsCustomTypes();
    }

    @Override
    public boolean supportsTransaction() {
        return this.dbms_.supportsTransaction();
    }

    @Override
    public boolean supportsTrigger() {
        return this.dbms_.supportsTrigger();
    }

    @Override
    public boolean supportsUseDatabase() {
        return this.dbms_.supportsUseDatabase();
    }

    @Override
    public boolean supportsClusteredIndex() {
        return this.dbms_.supportsClusteredIndex();
    }

    @Override
    public boolean supportsMixedCase() {
        return this.dbms_.supportsMixedCase();
    }

    @Override
    public boolean supportsSchemas() {
        return this.dbms_.supportsSchemas();
    }

    @Override
    public boolean supportsSequences() {
        return this.dbms_.supportsSequences();
    }

    public boolean supportsPgProcArgNms() {
        if (!this.isPsql()) {
            return false;
        }
        if (this.getVersion() == null) {
            return false;
        }
        return this.getVersion().compareTo(VER_PG_PROC_ARG_NMS) >= 0;
    }

    @Override
    public boolean supportsView() {
        if (this.isMySql5()) {
            return true;
        }
        return this.dbms_.supportsView();
    }

    public boolean getUseSchemaPrefix(Schema schema) {
        if (this.isSqlSvr()) {
            return true;
        }
        return this.supportsSchemas() && schema.getDbHasManySchemas();
    }

    public IDataTypeConverter getDataTypeConverter() {
        if (this.isSqlSvr()) {
            return msSqlServerDataTypeConverter__;
        }
        if (this.isMsAccess()) {
            return msAccessDataTypeConverter__;
        }
        if (this.isPsql()) {
            return this.psqlDataTypeConv_;
        }
        if (this.isOracle()) {
            return oracleDataTypeConv_;
        }
        if (this.isMySql()) {
            mysqlDataTypeConverter__.setConfig(this);
            return mysqlDataTypeConverter__;
        }
        return null;
    }

    public IDbmsCompareCtrl getDbmsCompareCtrl() {
        BasicDbmsCompareCtrl ctrl = null;
        switch (this.getDbmsId()) {
            case 2: {
                ctrl = new MsAccessCompareCtrl(this);
                break;
            }
            case 3: {
                ctrl = new SqlSvrCompareCtrl(this);
                break;
            }
            case 0: {
                ctrl = new MySqlCompareCtrl(this);
                break;
            }
            case 1: {
                ctrl = new PsqlCompareCtrl(this);
                break;
            }
            case 4: {
                ctrl = new OracleCompareCtrl(this);
                break;
            }
            default: {
                StrHelper.throwProgrammingException("JdbcConfig.getDbmsCompareCtrl() - Unrecognized Dbms Id.");
            }
        }
        return ctrl;
    }

    public boolean supportsMixedCase(String mapNm) {
        if (mapNm.equalsIgnoreCase(View.getClassName())) {
            return this.isSqlSvr();
        }
        if (mapNm.equalsIgnoreCase(PrimaryKey.getClassName())) {
            return this.supportsMixedCasePkName();
        }
        if (mapNm.equalsIgnoreCase(Table.getClassName())) {
            return this.supportsMixedCaseTableName();
        }
        return this.supportsMixedCase();
    }

    @Override
    public boolean supportsMixedCasePkName() {
        return this.dbms_.supportsMixedCasePkName();
    }

    @Override
    public boolean supportsMixedCaseTableName() {
        return this.dbms_.supportsMixedCaseTableName();
    }

    @Override
    public int getDbmsId() {
        return this.getDbms().getId();
    }

    private boolean isOracleConnViaService(String server) {
        String startStr = server.substring(0, 2);
        boolean isViaService = startStr.equalsIgnoreCase("//");
        return isViaService;
    }

    public boolean supportUniqueConstraint() {
        return this.dbms_.supportsUniqueConstraint();
    }
}

