/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.db.ConnectionResult;
import com.harrand.coreclasses.db.DbDataResult;
import com.harrand.coreclasses.db.SqlHelper;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.dbwrench.db.JdbcHelper;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class ConnectionFactory {
    private static ConnectionFactory ref = new ConnectionFactory();
    private static String url_;
    private static String driverClassName_;
    private static List configs_;

    private ConnectionFactory() {
    }

    public static Connection getConnection(IConnectionConfig config) throws SQLException {
        Connection conn = null;
        ConnectionFactory.setDriverClassName(config.getDriverClassName());
        ConnectionFactory.setUrl(config.getConnectionString());
        conn = !Validator.isStringValid(config.getUserName()) ? DriverManager.getConnection(url_) : (config.getSSL() ? ConnectionFactory.getSSL_Conn(config) : ConnectionFactory.getPwdConn(config));
        return conn;
    }

    private static Connection getSSL_Conn(IConnectionConfig config) throws SQLException {
        Properties props = config.getProps();
        JdbcConfig jdbcConfig = (JdbcConfig)config;
        if (jdbcConfig.isPsql()) {
            props.setProperty("ssl", "true");
            ConnectionFactory.useNonValidatingPsqlSSL_Factory(props);
        } else if (jdbcConfig.isSqlSvr()) {
            props.setProperty("ssl", "authenticate");
        } else if (jdbcConfig.isMySql()) {
            props.setProperty("useSSL", "true");
            props.setProperty("requireSSL", "true");
        }
        return DriverManager.getConnection(url_, props);
    }

    private static Connection getPwdConn(IConnectionConfig config) throws SQLException {
        return DriverManager.getConnection(url_, config.getProps());
    }

    private static void useNonValidatingPsqlSSL_Factory(Properties props) {
        if (LogUtil.isTestMode()) {
            LogUtil.logErr("ConnFactory: Using NON VALIDATED SSL factory !!!!");
            props.setProperty("sslfactory", "org.postgresql.ssl.NonValidatingFactory");
        }
    }

    public static ConnectionResult getConnResult(IConnectionConfig config) {
        Connection conn = null;
        DataEntryResult basicResult = new DataEntryResult(true);
        try {
            conn = ConnectionFactory.getConnection(config);
        }
        catch (SQLException ex) {
            basicResult = new DataEntryResult(false, "ConnectionFactory.getConnResult() failed", ex.getMessage());
        }
        ConnectionResult connResult = new ConnectionResult(basicResult, conn);
        return connResult;
    }

    public static void printMySqlDriverVersion() {
        ArrayList<Driver> drivers = Collections.list(DriverManager.getDrivers());
        for (int i = 0; i < drivers.size(); ++i) {
            Driver driver = (Driver)drivers.get(i);
            String name = driver.getClass().getName();
            if (name.indexOf("mysql") < 0) continue;
            int majorVersion = driver.getMajorVersion();
            int n = driver.getMinorVersion();
        }
    }

    public static ResultSet doSql(Connection conn, String sql) throws Exception {
        ResultSet rs;
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            rs = stmt.getResultSet();
        }
        catch (SQLException e) {
            String fullMsg = "Sql: " + sql + "\n" + e.getMessage();
            throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
        }
        return rs;
    }

    public static ResultSet doSql(JdbcConfig config, String sql) {
        ResultSet rs = null;
        try {
            Connection dataConn = ConnectionFactory.getConnection(config);
            rs = ConnectionFactory.doSql(dataConn, sql);
            ConnectionFactory.close(dataConn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    @Deprecated
    public static DbDataResult doSqlGetResult(Connection conn, String sql) {
        DataEntryResult basicResult = new DataEntryResult(true);
        boolean nullRs = false;
        Object[][] data = SqlHelper.getEmptyDataMatrix();
        try {
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            if (rs != null) {
                data = JdbcHelper.rsToMatrix(rs);
            } else {
                nullRs = true;
            }
        }
        catch (Exception e) {
            basicResult = new DataEntryResult(false, "SQL Command Error", e.getMessage());
        }
        return null;
    }

    public static int doUpdateSql(IConnectionConfig dbConfig, String sql) throws Exception {
        int result = -1;
        Connection conn = null;
        String errMsg = null;
        try {
            conn = ConnectionFactory.getConnection(dbConfig);
            PreparedStatement stmt = conn.prepareStatement(sql);
            boolean bl = stmt.execute();
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (conn != null) {
            ConnectionFactory.close(conn);
        }
        if (errMsg != null) {
            throw new Exception(errMsg);
        }
        return result;
    }

    public static boolean rsContains(ResultSet rs, String value) {
        boolean found = false;
        try {
            int columnCount = rs.getMetaData().getColumnCount();
            while (rs.next() && !found) {
                for (int c = 1; c <= columnCount; ++c) {
                    String instr;
                    int columnType = rs.getMetaData().getColumnType(c);
                    if (columnType != 1 && columnType != 12 || !(instr = rs.getString(c)).equalsIgnoreCase(value)) continue;
                    found = true;
                }
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return found;
    }

    public static void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
            }
        }
    }

    public static void close(Statement stmt) {
        try {
            stmt.close();
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    public static void close(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private static void loadDriver() throws SQLException {
        try {
            Class.forName(driverClassName_);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(App.getResource("err.jdbc.driver.failed.load") + ": " + driverClassName_);
        }
    }

    public static int getRowCount(ResultSet rs) throws Exception {
        int rowCount = 0;
        while (rs.next()) {
            ++rowCount;
        }
        rs.beforeFirst();
        return rowCount;
    }

    public static int getRowCount(IConnectionConfig config, String tableName) {
        int rowCount = -1;
        String sql = "SELECT COUNT(*) as 'rowcount' FROM " + tableName;
        if (ConnectionFactory.isPsql(config)) {
            sql = "SELECT COUNT(*) as \"rowcount\" FROM " + tableName;
        }
        try {
            Connection conn = ConnectionFactory.getConnection(config);
            ResultSet rs = ConnectionFactory.doSql(conn, sql);
            rs.next();
            rowCount = rs.getInt("rowcount");
        }
        catch (Exception e) {
            System.out.println("ConnectionFactory.getRowCount Error: " + e.getMessage());
        }
        return rowCount;
    }

    public static boolean isMySql(IConnectionConfig config) {
        String strDriverNm = config.getDriverClassName();
        return strDriverNm.indexOf("mysql") >= 0;
    }

    public static boolean isPsql(IConnectionConfig config) {
        String strDriverNm = config.getDriverClassName();
        return strDriverNm.indexOf("postgresql") >= 0;
    }

    private static void setUrl(String url) {
        url_ = url;
    }

    private static void setDriverClassName(String driverClassName) throws SQLException {
        driverClassName_ = driverClassName;
        ConnectionFactory.loadDriver();
    }

    public static String getUrl() {
        return url_;
    }

    public static String getDriveClassName() {
        return driverClassName_;
    }
}

