/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.list.PunctuationLastComparator;
import com.harrand.dbwrench.jdbc.DataType;
import com.harrand.dbwrench.security.App;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class BasicTypesSvr {
    private static BasicTypesSvr instance__ = new BasicTypesSvr();
    private static Map instanceMap__;
    private static Map idMap__;
    public static final String EXT_DB_TYPE_STR = "(From External DB)";
    public static final int DATE_TIME = 700;
    public static final int MONEY = 701;
    public static final int MEDINT = 702;
    public static final int TEXT = 703;
    public static final int UNIQUE_ID = 704;
    public static final int ENUM = 706;
    public static final int TINY_BLOB = 707;
    public static final int MED_BLOB = 708;
    public static final int LONG_BLOB = 709;
    public static final int TINY_TEXT = 710;
    public static final int MED_TEXT = 711;
    public static final int LONG_TEXT = 712;
    public static final int IMAGE = 721;
    public static final int NCHAR = 722;
    public static final int NTEXT = 723;
    public static final int NVARCHAR = 724;
    public static final int SQL_VARIANT = 725;
    public static final int SMALL_DATE_TIME = 726;
    public static final int XML = 728;
    public static final int NVARCHAR_MAX = 729;
    public static final int VARBINARY_MAX = 730;
    public static final int VARCHAR_MAX = 731;
    public static final int SET = 740;
    public static final int BYTEA = 760;
    public static final int BOX = 761;
    public static final int CIRCLE = 762;
    public static final int CIDR = 763;
    public static final int INET = 764;
    public static final int INTERVAL = 765;
    public static final int LINE = 766;
    public static final int LSEG = 767;
    public static final int MACADDR = 768;
    public static final int PATH = 769;
    public static final int POINT = 770;
    public static final int POLYGON = 771;
    public static final int TIMESTAMP_TZ = 772;
    public static final int TIME_TZ = 773;
    public static final int UUID = 774;
    public static final int TS_VECTOR = 775;
    public static final int TS_QUERY = 776;
    public static final int SERIAL = 777;
    public static final int BIG_SERIAL = 778;
    public static final int GEOMETRY = 779;
    public static final int NUMBER = 780;
    public static final int VARCHAR2 = 781;
    public static final int NVARCHAR2 = 782;
    public static final int CLOB = 783;
    public static final int NCLOB = 784;
    public static final int RAW = 785;
    public static final int JSON = 786;
    public static final int JSONB = 787;
    public static final int FROM_EXTERNAL_DB = 798;
    public static final int UNKNOWN = 799;
    public static final int BIGINT = -5;
    public static final int BINARY = -2;
    public static final int BIT = -7;
    public static final int BLOB = 2004;
    public static final int BOOLEAN = 16;
    public static final int CHAR = 1;
    public static final int DATE = 91;
    public static final int DECIMAL = 3;
    public static final int DOUBLE = 8;
    public static final int FLOAT = 6;
    public static final int INTEGER = 4;
    public static final int NUMERIC = 2;
    public static final int REAL = 7;
    public static final int SMALLINT = 5;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int TINYINT = -6;
    public static final int VARBINARY = -3;
    public static final int VARCHAR = 12;
    public static final Integer BIT_DEFAULT_LENGTH;
    public static final Integer BINARY_DEFAULT_LENGTH;
    public static final Integer CHAR_DEFAULT_LENGTH;
    public static final Integer NUMERIC_DEFAULT_LENGTH;
    public static final Integer DECIMAL_DEFAULT_LENGTH;
    public static final Integer NUMERIC_DEFAULT_SCALE;
    public static final Integer DECIMAL_DEFAULT_SCALE;

    private BasicTypesSvr() {
        this.ensureInit();
    }

    public static BasicTypesSvr instance() {
        return instance__;
    }

    public DataType getType(int id) {
        this.checkId(id);
        String desc = (String)idMap__.get(new Integer(id));
        if (desc == null) {
            System.out.println("DataType.instance.not find id:" + id);
        }
        return this.getType(desc);
    }

    public DataType getType(String desc) {
        if (desc == null) {
            System.out.println("DataType.instance: Desc is NULL!");
        }
        return (DataType)instanceMap__.get(desc);
    }

    public String getDesc(int id) {
        return (String)idMap__.get(new Integer(id));
    }

    public int getIdFromDesc(String desc) {
        int id = 799;
        if (desc.equalsIgnoreCase("int")) {
            return 4;
        }
        for (Integer keyInt : idMap__.keySet()) {
            String mapDesc = this.getDesc(keyInt);
            if (!desc.equalsIgnoreCase(mapDesc)) continue;
            return keyInt;
        }
        return id;
    }

    private void ensureInit() {
        if (idMap__ == null) {
            this.initDataTypes();
        }
    }

    private void initDataTypes() {
        this.loadIdMap();
        this.buildInstances();
    }

    private void buildInstances() {
        instanceMap__ = new TreeMap(new PunctuationLastComparator());
        for (Integer intObj : idMap__.keySet()) {
            int id = intObj;
            String desc = this.getDesc(id);
            DataType dt = new DataType(id, desc);
            instanceMap__.put(dt.getDesc(), dt);
        }
    }

    private void putPair(int typeId) {
        String key = Integer.toString(typeId) + ".label";
        String label = App.getRes(key);
        idMap__.put(new Integer(typeId), label);
    }

    private void checkId(int id) {
        Integer intId = new Integer(id);
        Set keys = idMap__.keySet();
        if (!keys.contains(intId)) {
            StrHelper.throwProgrammingException("ID: " + intId + " is not a valid DataType ID.");
        }
    }

    public List getList() {
        return new ArrayList(instanceMap__.values());
    }

    public String[] getStringArray() {
        Object[] arrayStr = instanceMap__.keySet().toArray();
        int count = instanceMap__.size();
        String[] array = new String[instanceMap__.size()];
        for (int i = 0; i < count; ++i) {
            array[i] = (String)arrayStr[i];
        }
        return array;
    }

    private void loadIdMap() {
        idMap__ = new HashMap();
        this.putPair(-5);
        this.putPair(-2);
        this.putPair(-7);
        this.putPair(2004);
        this.putPair(16);
        this.putPair(1);
        this.putPair(91);
        this.putPair(3);
        this.putPair(8);
        this.putPair(6);
        this.putPair(4);
        this.putPair(2);
        this.putPair(7);
        this.putPair(5);
        this.putPair(92);
        this.putPair(93);
        this.putPair(-6);
        this.putPair(-3);
        this.putPair(12);
        this.putPair(703);
        this.putPair(700);
        this.putPair(704);
        this.putPair(701);
        this.putPair(702);
        this.putPair(706);
        this.putPair(707);
        this.putPair(708);
        this.putPair(709);
        this.putPair(710);
        this.putPair(711);
        this.putPair(712);
        this.putPair(721);
        this.putPair(722);
        this.putPair(723);
        this.putPair(724);
        this.putPair(725);
        this.putPair(726);
        this.putPair(728);
        this.putPair(740);
        this.putPair(760);
        this.putPair(761);
        this.putPair(762);
        this.putPair(763);
        this.putPair(764);
        this.putPair(765);
        this.putPair(766);
        this.putPair(767);
        this.putPair(768);
        this.putPair(769);
        this.putPair(770);
        this.putPair(771);
        this.putPair(772);
        this.putPair(773);
        this.putPair(799);
        this.putPair(798);
        this.putPair(774);
        this.putPair(775);
        this.putPair(776);
        this.putPair(777);
        this.putPair(778);
        this.putPair(731);
        this.putPair(729);
        this.putPair(730);
        this.putPair(780);
        this.putPair(781);
        this.putPair(782);
        this.putPair(783);
        this.putPair(784);
        this.putPair(785);
        this.putPair(779);
        this.putPair(786);
        this.putPair(787);
    }

    static {
        BIT_DEFAULT_LENGTH = new Integer(1);
        BINARY_DEFAULT_LENGTH = new Integer(1);
        CHAR_DEFAULT_LENGTH = new Integer(1);
        NUMERIC_DEFAULT_LENGTH = new Integer(10);
        DECIMAL_DEFAULT_LENGTH = new Integer(10);
        NUMERIC_DEFAULT_SCALE = new Integer(2);
        DECIMAL_DEFAULT_SCALE = new Integer(2);
    }
}

