/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.element;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.text.escape.IStrEscapeCtrl;
import com.harrand.dbwrench.element.ISchemaObj;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.SqlReservedWordGui;

public class BaseSchemaObj
implements ISchemaObj {
    private Schema schema_ = null;
    private final DbUser user = App.getUser();

    @Override
    public Schema getSchema() {
        return this.schema_;
    }

    @Override
    public void setSchema(Schema schema) {
        this.schema_ = schema;
    }

    public int getDbSchemaCount() {
        if (this.isSchemaSet()) {
            return this.schema_.getDbSchemaCount();
        }
        return 0;
    }

    private boolean isSchemaSet() {
        return this.schema_ != null;
    }

    @Override
    public String getForEngNm(String itemNm, boolean dbmsSupportsSchemas, boolean doDblQuote, IStrEscapeCtrl strEscapeCtrl) {
        String fullNm;
        String string = fullNm = doDblQuote ? this.dblEnquote(itemNm) : itemNm;
        if (this.isSchemaSet() && dbmsSupportsSchemas) {
            if (this.isAlwaysDotNoteConfig() || this.getDbHasManySchemas() || this.getAlwaysUseDotNoteToggled()) {
                fullNm = this.buildDotNote(doDblQuote, fullNm);
            } else if (!doDblQuote) {
                fullNm = this.escapeIfReserved(fullNm, strEscapeCtrl);
            }
        }
        return fullNm;
    }

    private boolean getAlwaysUseDotNoteToggled() {
        IOptionMgr forEngOptionMgr = this.user.getOptionMgr("forward.engineer.option.mgr");
        return forEngOptionMgr.getBoolValue("forward.engineer.always.prepend.schema");
    }

    private boolean getDbHasManySchemas() {
        if (this.isSchemaSet()) {
            return this.schema_.getDbHasManySchemas();
        }
        return false;
    }

    private String buildDotNote(boolean doDblQuote, String fullNm) {
        String schNmRaw = this.getSchema().getName();
        String schNm = doDblQuote ? this.dblEnquote(schNmRaw) : schNmRaw;
        String dotNote = schNm + "." + fullNm;
        return dotNote;
    }

    private String dblEnquote(String inStr) {
        return StrHelper.encloseDblQuotes(inStr);
    }

    public String getDotNote(ISchemaObj schemaObj) {
        Schema schema = this.getSchema();
        String schNm = schema != null ? schema.getName() + "." : "";
        String nm = schemaObj instanceof INamed ? ((INamed)((Object)schemaObj)).getName() : "";
        return schNm + nm;
    }

    @Override
    public ISchemaObj getDupSchemaNull() {
        return new BaseSchemaObj();
    }

    private boolean isAlwaysDotNoteConfig() {
        JdbcConfig cfg = ConnMgr.getInstance().getCurrentCfg();
        return cfg != null && cfg.isSqlSvr();
    }

    private String escapeIfReserved(String nmIn, IStrEscapeCtrl escapeCtrl) {
        SqlReservedWordGui sqlReserveds;
        String nmOut = nmIn;
        if (escapeCtrl != null && (sqlReserveds = SqlReservedWordGui.instance()).isReserved(nmIn)) {
            nmOut = escapeCtrl.escapeStr(nmIn);
        }
        return nmOut;
    }
}

