/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.View;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ViewDocBldr
implements IDocBldr {
    private Database db_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private HtmlHelper hh_;
    public static final String CSS_URL = "../css/doc.css";

    public ViewDocBldr(Database db, File baseFolder) {
        this.db_ = db;
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "views", "doc.views");
        this.hh_ = new HtmlHelper();
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.basicBldr_.setMileStone("Writing view HTML files...");
                this.writeIndexPage();
                this.writePagesDisp();
            }
            catch (Exception e) {
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    private List getHeaderItems(boolean showSchema) {
        ArrayList<String> items = new ArrayList<String>();
        items.add("Name");
        items.add("SQL");
        if (showSchema) {
            items.add("Schema");
        }
        return items;
    }

    private void writeIndexPage() throws Exception {
        File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), "index.html");
        this.setMileStone(file);
        Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, View.getClassName());
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
        Element elmGrid = doc.createElement("table");
        elmBody.appendChild(elmGrid);
        elmGrid.setAttribute("class", "flat");
        List items = this.getHeaderItems(true);
        elmGrid.appendChild(this.hh_.getBannerRow("Views", items.size()));
        Element elmHeader = this.hh_.getRowElement(items, "Header");
        elmGrid.appendChild(elmHeader);
        items.clear();
        List idfs = this.db_.getAllViews();
        BasicCollector.sortByNames(idfs);
        this.hh_.setRowAltProps(true, idfs.size());
        this.addSummaryRows(elmGrid, idfs, true);
        XmlHelper.writeElement(doc.getDocumentElement(), file);
    }

    private void writePagesDisp() throws Exception {
        List items = this.db_.getAllViews();
        int totalItems = items.size();
        int i = 0;
        for (View view : items) {
            Schema schema = view.getSchema();
            String viewName = view.getName();
            String fileNm = StrHelper.getDotNoteAsUnderScore(view.getDotNote());
            File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), fileNm + ".html");
            this.setStatus(file, ++i, totalItems);
            Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, view);
            this.hh_.setDoc(doc);
            Element elmBody = HtmlHelper.getBodyElement(doc);
            MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
            Element elmGrid = doc.createElement("table");
            elmBody.appendChild(elmGrid);
            elmGrid.setAttribute("class", "flat");
            elmGrid.appendChild(this.hh_.getBannerRow(schema.getPrefixIfMany() + viewName, "View"));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Name", view.getName()));
            String sql = view.getSql();
            sql = sql.replaceAll("\r\n", "\n");
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("SQL", this.hh_.getPreElm(sql)));
            XmlHelper.writeElement(doc.getDocumentElement(), file);
        }
    }

    private void addSummaryRows(Element elmGrid, List idfs, boolean showSchema) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (View view : idfs) {
            Schema schema = view.getSchema();
            items.clear();
            String viewName = view.getName();
            String fileNm = StrHelper.getDotNoteAsUnderScore(view.getDotNote());
            if (!showSchema) {
                fileNm = "../views/" + fileNm;
            }
            String url = fileNm + ".html";
            Element anchor = this.hh_.getAnchor(viewName, url, null);
            items.add(anchor);
            items.add(view.getSqlMaxLength(40));
            if (showSchema) {
                items.add(schema.getName());
            }
            Element elmRow = this.hh_.getRowElement(items, null);
            elmGrid.appendChild(elmRow);
        }
    }

    public Element getSummaryGrid(Document doc, List idfs) {
        if (idfs.isEmpty()) {
            return this.hh_.getNoneGrid(doc, "Views");
        }
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute("class", "flat");
        this.hh_.setDoc(doc);
        List headerItems = this.getHeaderItems(false);
        elmGrid.appendChild(this.hh_.getBannerRow("Views", headerItems.size()));
        Element elmHeader = this.hh_.getRowElement(headerItems, "header");
        elmGrid.appendChild(elmHeader);
        this.hh_.setRowAltProps(true, idfs.size());
        this.addSummaryRows(elmGrid, idfs, false);
        return elmGrid;
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "View", currentItem, totalItems);
    }
}

