/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.ColumnDocBldr;
import com.harrand.dbwrench.doc.DiagramDocBldr;
import com.harrand.dbwrench.doc.FkDocBldr;
import com.harrand.dbwrench.doc.IndexDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.doc.TriggerDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TableDocBldr
implements IDocBldr {
    private Database db_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private List items_ = new ArrayList();
    private HtmlHelper hh_;
    private ColumnDocBldr colBldr_;
    private IndexDocBldr indexBldr_;
    private TriggerDocBldr trgBldr_;
    private FkDocBldr fkBldr_;
    private DiagramDocBldr diagramBldr_;
    public static final String CSS_URL = "../css/doc.css";

    public TableDocBldr(Database db, File baseFolder) {
        this.db_ = db;
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "tables", "doc.tables");
        this.hh_ = new HtmlHelper();
        this.colBldr_ = new ColumnDocBldr(this.db_, null, this.baseFolder_);
        this.indexBldr_ = new IndexDocBldr(this.db_, null, this.baseFolder_);
        this.trgBldr_ = new TriggerDocBldr(this.db_, null, this.baseFolder_);
        this.fkBldr_ = new FkDocBldr(this.db_, this.baseFolder_);
        this.diagramBldr_ = new DiagramDocBldr(this.db_, this.baseFolder_);
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.basicBldr_.setMileStone("Writing table HTML files...");
                this.writeIndexPage();
                this.writePagesDisp();
            }
            catch (Exception e) {
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
        this.colBldr_.setDocCtrl(docCtrl);
        this.indexBldr_.setDocCtrl(docCtrl);
        this.trgBldr_.setDocCtrl(docCtrl);
        this.fkBldr_.setDocCtrl(docCtrl);
        this.diagramBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    private void writeIndexPage() throws Exception {
        File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), "index.html");
        this.setMileStone(file);
        Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, Table.getClassName());
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
        Element elmTable = doc.createElement("table");
        elmBody.appendChild(elmTable);
        elmTable.setAttribute("class", "flat");
        this.items_.clear();
        this.items_ = this.getHeaderItems(true);
        elmTable.appendChild(this.hh_.getBannerRow("Tables", this.items_.size()));
        elmTable.appendChild(this.hh_.getRowElement(this.items_, "header"));
        List tables = this.db_.getAllTables();
        BasicCollector.sortByNames(tables);
        this.hh_.setRowAltProps(true, tables.size());
        this.addTableCommentRows(elmTable, tables, true);
        XmlHelper.writeElement(doc.getDocumentElement(), file);
    }

    private List getHeaderItems(boolean showSchema) {
        ArrayList<String> headerItems = new ArrayList<String>();
        headerItems.add("Table Name");
        headerItems.add("Comment");
        if (showSchema) {
            headerItems.add("Schema");
        }
        return headerItems;
    }

    private void addTableCommentRows(Element elmTable, List tables, boolean showSchema) {
        Iterator itTbl = tables.iterator();
        while (itTbl.hasNext()) {
            this.items_.clear();
            Table table = (Table)itTbl.next();
            String tblName = table.getName();
            String dotNote = table.getDotNote();
            String url = StrHelper.getDotNoteAsUnderScore(dotNote) + ".html";
            if (!showSchema) {
                url = "../tables/" + url;
            }
            Element anchor = this.hh_.getAnchor(tblName, url, null);
            this.items_.add(anchor);
            this.items_.add(table.getComment());
            if (showSchema) {
                this.items_.add(table.getSchema().getName());
            }
            Element elmRow = this.hh_.getRowElement(this.items_, null);
            elmTable.appendChild(elmRow);
        }
    }

    private void writePagesDisp() throws Exception {
        List items = this.db_.getAllTables();
        Iterator it = items.iterator();
        int totalItems = items.size();
        int i = 0;
        while (it.hasNext()) {
            Table table = (Table)it.next();
            Schema schema = table.getSchema();
            String dotNote = table.getDotNote();
            String fileNm = StrHelper.getDotNoteAsUnderScore(dotNote);
            File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), fileNm + ".html");
            this.setStatus(file, ++i, totalItems);
            this.items_.clear();
            Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, table);
            Element elmBody = HtmlHelper.getBodyElement(doc);
            this.hh_.setDoc(doc);
            MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
            Element pageTitleGrid = doc.createElement("table");
            elmBody.appendChild(pageTitleGrid);
            pageTitleGrid.setAttribute("class", "pageTitle");
            Element elmName = XmlHelper.createElementSimple(doc, "td", table.getName());
            elmName.setAttribute("class", "title_nm");
            String tableCmm = table.getComment();
            int MAX_TABLE_COMMENT_LENGTH = 70;
            String rightText = Validator.isStringValid(tableCmm) ? StrHelper.getTruncatedWithEllipsis(tableCmm, 70, true) : "(Table)";
            Element elmType = XmlHelper.createElementSimple(doc, "td", rightText);
            elmType.setAttribute("class", "watermark_right");
            this.items_.clear();
            this.items_.add(elmName);
            this.items_.add(elmType);
            pageTitleGrid.appendChild(this.hh_.getRowElement(this.items_, "pageTitle"));
            elmBody.appendChild(doc.createElement("br"));
            elmBody.appendChild(this.colBldr_.getSummaryGrid(doc, table));
            if (this.indexBldr_.getDocEnabled()) {
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.indexBldr_.getSummaryGrid(doc, table));
            }
            if (this.fkBldr_.getDocEnabled()) {
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.fkBldr_.getSummaryGrid(doc, table, 1));
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.fkBldr_.getSummaryGrid(doc, table, 0));
            }
            if (this.trgBldr_.getDocEnabled()) {
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.trgBldr_.getSummaryGrid(doc, table));
            }
            if (this.diagramBldr_.getDocEnabled()) {
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.diagramBldr_.getSummaryGrid(doc, table));
            }
            XmlHelper.writeElement(doc.getDocumentElement(), file);
        }
    }

    public Element getSummaryGrid(Document doc, List tables) {
        if (tables.isEmpty()) {
            return this.hh_.getNoneGrid(doc, "Tables");
        }
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute("class", "flat");
        this.hh_.setDoc(doc);
        List headerItems = this.getHeaderItems(false);
        elmGrid.appendChild(this.hh_.getBannerRow("Tables", headerItems.size()));
        Element elmHeader = this.hh_.getRowElement(headerItems, "header");
        elmGrid.appendChild(elmHeader);
        this.hh_.setRowAltProps(true, tables.size());
        this.addTableCommentRows(elmGrid, tables, false);
        return elmGrid;
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "Table", currentItem, totalItems);
    }
}

