/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.doc.ProcDocBldr;
import com.harrand.dbwrench.doc.SeqDocBldr;
import com.harrand.dbwrench.doc.TableDocBldr;
import com.harrand.dbwrench.doc.ViewDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.View;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaDocBldr
implements IDocBldr {
    private Database db_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private HtmlHelper hh_;
    private List items_ = new ArrayList();
    public static final String CSS_URL = "../css/doc.css";
    private TableDocBldr tblBldr_;
    private ProcDocBldr procBldr_;
    private ViewDocBldr viewBldr_;
    private SeqDocBldr seqBldr_;

    public SchemaDocBldr(Database db, File baseFolder) {
        this.db_ = db;
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "schemas", "doc.schemas");
        this.hh_ = new HtmlHelper();
        this.tblBldr_ = new TableDocBldr(this.db_, this.baseFolder_);
        this.procBldr_ = new ProcDocBldr(this.db_, this.baseFolder_);
        this.viewBldr_ = new ViewDocBldr(this.db_, this.baseFolder_);
        this.seqBldr_ = new SeqDocBldr(this.db_, this.baseFolder_);
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.basicBldr_.setMileStone("Writing schema HTML files...");
                this.writeIndexPage();
                this.writePagesDisp();
            }
            catch (Exception e) {
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
        this.tblBldr_.setDocCtrl(docCtrl);
        this.viewBldr_.setDocCtrl(docCtrl);
        this.procBldr_.setDocCtrl(docCtrl);
        this.seqBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    private void writeIndexPage() throws Exception {
        File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), "index.html");
        this.setMileStone(file);
        Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, Schema.getClassName());
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
        Element elmGrid = doc.createElement("table");
        elmBody.appendChild(elmGrid);
        elmGrid.setAttribute("class", "flat");
        elmGrid.appendChild(this.hh_.getBannerRow("Schemas", 2));
        ArrayList<Object> items = new ArrayList<Object>();
        items.add("Name");
        items.add("Comment");
        Element elmHeader = this.hh_.getRowElement(items, "Header");
        elmGrid.appendChild(elmHeader);
        items.clear();
        this.hh_.setRowAltProps(true, this.db_.size(Schema.getClassName()));
        for (Schema schema : this.db_.values(Schema.getClassName())) {
            String schNm;
            items.clear();
            String fileNm = schNm = schema.getName();
            String url = fileNm + ".html";
            Element anchor = this.hh_.getAnchor(schNm, url, null);
            items.add(anchor);
            items.add(schema.getComment());
            Element elmRow = this.hh_.getRowElement(items, null);
            elmGrid.appendChild(elmRow);
        }
        XmlHelper.writeElement(doc.getDocumentElement(), file);
    }

    private void writePagesDisp() throws Exception {
        List items = this.db_.values(Schema.getClassName());
        int totalItems = items.size();
        int i = 0;
        for (Schema schema : items) {
            String schemaName;
            String fileNm = schemaName = schema.getName();
            File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), fileNm + ".html");
            this.setStatus(file, ++i, totalItems);
            Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, schema);
            this.hh_.setDoc(doc);
            Element elmBody = HtmlHelper.getBodyElement(doc);
            MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
            Element elmGrid = doc.createElement("table");
            elmBody.appendChild(elmGrid);
            elmGrid.setAttribute("class", "flat");
            Element pageTitleGrid = doc.createElement("table");
            elmBody.appendChild(pageTitleGrid);
            pageTitleGrid.setAttribute("class", "pageTitle");
            Element elmName = XmlHelper.createElementSimple(doc, "td", schema.getName());
            elmName.setAttribute("class", "title_nm");
            Element elmType = XmlHelper.createElementSimple(doc, "td", "(Schema)");
            elmType.setAttribute("class", "watermark_right");
            this.items_.clear();
            this.items_.add(elmName);
            this.items_.add(elmType);
            pageTitleGrid.appendChild(this.hh_.getRowElement(this.items_, "pageTitle"));
            if (this.tblBldr_.getDocEnabled()) {
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.tblBldr_.getSummaryGrid(doc, schema.values(Table.getClassName())));
            }
            if (this.procBldr_.getDocEnabled()) {
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.procBldr_.getSummaryGrid(doc, schema.values(Proc.getClassName())));
            }
            if (this.viewBldr_.getDocEnabled()) {
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.viewBldr_.getSummaryGrid(doc, schema.values(View.getClassName())));
            }
            if (this.seqBldr_.getDocEnabled()) {
                elmBody.appendChild(doc.createElement("br"));
                elmBody.appendChild(this.seqBldr_.getSummaryGrid(doc, schema.values(Sequence.getClassName())));
            }
            XmlHelper.writeElement(doc.getDocumentElement(), file);
        }
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "Schema", currentItem, totalItems);
    }
}

