/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IndexDocBldr
implements IDocBldr {
    private Database db_;
    private Table table_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private HtmlHelper hh_;
    public static final String CSS_URL = "../css/doc.css";
    public static final String HEADER = "Header";

    public IndexDocBldr(Database db, Table table, File baseFolder) {
        this.db_ = db;
        this.setTable(table);
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "indexes", "doc.indexes");
        this.hh_ = new HtmlHelper();
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    public void setTable(Table table) {
        this.table_ = table;
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.basicBldr_.setMileStone("Writing index HTML files...");
                this.writeIndexPage();
                this.writePagesDisp();
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    public Element getSummaryGrid(Document doc, Table table) {
        this.setTable(table);
        if (!table.hasIndexes()) {
            return this.hh_.getNoneGrid(doc, "Indexes");
        }
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute("class", "flat");
        this.hh_.setDoc(doc);
        List items = this.getHeaderItems();
        elmGrid.appendChild(this.hh_.getBannerRow("Indexes", items.size()));
        Element elmHeader = this.hh_.getRowElement(items, HEADER);
        elmGrid.appendChild(elmHeader);
        this.hh_.setRowAltProps(true, table.size(Index.getClassName()));
        for (Index index : table.values(Index.getClassName())) {
            Element elmRow = this.getAsRowElement(doc, table, index);
            elmGrid.appendChild(elmRow);
        }
        return elmGrid;
    }

    private List getHeaderItems() {
        ArrayList<String> items = new ArrayList<String>();
        items.add("Name");
        items.add(Table.getClassName());
        items.add("Columns");
        items.add("Unique");
        items.add("Clustered");
        return items;
    }

    private Element getAsRowElement(Document doc, Table tbl, Index index) {
        this.hh_.setDoc(doc);
        ArrayList<Object> items = new ArrayList<Object>();
        String name = index.getName();
        String dotNote = tbl.getDotNote() + "." + name;
        String fileNm = StrHelper.getDotNoteAsUnderScore(dotNote);
        String url = "../indexes/" + fileNm + ".html";
        Element anchor = this.hh_.getAnchor(name, url, null);
        items.add(anchor);
        String tblText = tbl.getSchema().getPrefixIfMany() + tbl.getName();
        Element tblAnchor = this.hh_.getAnchor(tblText, "../tables/" + StrHelper.getDotNoteAsUnderScore(tbl.getDotNote()) + ".html", null);
        items.add(tblAnchor);
        items.add(index.getIndexColumnDdlTextsCSV());
        items.add(this.hh_.getBooleanImageElm("../images/ok12d.gif", index.getUnique()));
        items.add(this.hh_.getBooleanImageElm("../images/ok12d.gif", index.getClusteredFlag()));
        Element elmRow = this.hh_.getRowElement(items, null);
        return elmRow;
    }

    private void writeIndexPage() throws Exception {
        File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), "index.html");
        this.setMileStone(file);
        Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, Index.getClassName());
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
        Element elmGrid = doc.createElement("table");
        elmBody.appendChild(elmGrid);
        elmGrid.setAttribute("class", "flat");
        List items = this.getHeaderItems();
        elmGrid.appendChild(this.hh_.getBannerRow("Indexes", items.size()));
        Element elmHeader = this.hh_.getRowElement(items, HEADER);
        elmGrid.appendChild(elmHeader);
        items.clear();
        this.hh_.setRowAltProps(true, this.db_.getTotalTableItems(Index.getClassName()));
        TreeMap indexMap = new TreeMap();
        for (Table table : this.db_.getAllTables()) {
            for (Index index : table.values(Index.getClassName())) {
                elmGrid.appendChild(this.getAsRowElement(doc, table, index));
            }
        }
        XmlHelper.writeElement(doc.getDocumentElement(), file);
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void writePagesDisp() throws Exception {
        ArrayList items = new ArrayList();
        int totalItems = this.db_.getTotalTableItems(Index.getClassName());
        int i = 0;
        Iterator itTable = this.db_.getAllTables().iterator();
        while (itTable.hasNext()) {
            this.setTable((Table)itTable.next());
            Schema schema = this.table_.getSchema();
            for (Index index : this.table_.values(Index.getClassName())) {
                String dotNote = this.table_.getDotNote() + "." + index.getName();
                String fileNm = StrHelper.getDotNoteAsUnderScore(dotNote);
                File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), fileNm + ".html");
                this.setStatus(file, ++i, totalItems);
                items.clear();
                String idxName = index.getName();
                Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.table_, index);
                this.hh_.setDoc(doc);
                Element elmBody = HtmlHelper.getBodyElement(doc);
                MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
                Element elmGrid = doc.createElement("table");
                elmBody.appendChild(elmGrid);
                elmGrid.setAttribute("class", "flat");
                elmGrid.appendChild(this.hh_.getBannerRow(idxName, "Index"));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Name", index.getName()));
                String tblText = schema.getPrefixIfMany() + this.table_.getName();
                Element tblAnchor = this.hh_.getAnchor(tblText, "../tables/" + StrHelper.getDotNoteAsUnderScore(this.table_.getDotNote()) + ".html", null);
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Table", tblAnchor));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Columns", index.getIndexColumnDdlTextsCSV()));
                Element elmBool = this.hh_.getBoolImgHorzElm("../images/ok12d.gif", index.getUnique());
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Unique", elmBool));
                elmBool = this.hh_.getBoolImgHorzElm("../images/ok12d.gif", index.getClusteredFlag());
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Clustered", elmBool));
                XmlHelper.writeElement(doc.getDocumentElement(), file);
            }
        }
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "Index", currentItem, totalItems);
    }
}

