/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrench.doc.ColumnDocBldr;
import com.harrand.dbwrench.doc.DatabaseDocBldr;
import com.harrand.dbwrench.doc.DiagramDocBldr;
import com.harrand.dbwrench.doc.FkDocBldr;
import com.harrand.dbwrench.doc.IndexDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.doc.ProcDocBldr;
import com.harrand.dbwrench.doc.SchemaDocBldr;
import com.harrand.dbwrench.doc.SeqDocBldr;
import com.harrand.dbwrench.doc.TableDocBldr;
import com.harrand.dbwrench.doc.TriggerDocBldr;
import com.harrand.dbwrench.doc.ViewDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.util.LogUtil;
import java.io.File;

public class DbDocCtrl
implements IDocCtrl {
    private Database db_;
    private File folder_;
    private String status_ = StrHelper.READY_STR;
    private String mileStone_;
    private BasicObservable observable_ = new BasicObservable();

    public DbDocCtrl(Database db) {
        this.setDatabase(db);
    }

    private void createDocsDisp() {
        this.checkSupportFiles();
        ITestResult result = this.writePagesDisp(new DatabaseDocBldr(this.db_, this.folder_));
        result = this.writePagesDisp(new DiagramDocBldr(this.db_, this.folder_));
        result = this.writePagesDisp(new SchemaDocBldr(this.db_, this.folder_));
        result = this.writePagesDisp(new TableDocBldr(this.db_, this.folder_));
        result = this.writePagesDisp(new ColumnDocBldr(this.db_, null, this.folder_));
        result = this.writePagesDisp(new IndexDocBldr(this.db_, null, this.folder_));
        result = this.writePagesDisp(new TriggerDocBldr(this.db_, null, this.folder_));
        result = this.writePagesDisp(new FkDocBldr(this.db_, this.folder_));
        result = this.writePagesDisp(new ProcDocBldr(this.db_, this.folder_));
        result = this.writePagesDisp(new ViewDocBldr(this.db_, this.folder_));
        result = this.writePagesDisp(new SeqDocBldr(this.db_, this.folder_));
        try {
            this.db_.write();
        }
        catch (Exception e) {
            this.setMileStone("Error Saving Database DocFolder: " + e.getMessage());
        }
        this.setMileStone("Database Documentation Complete");
    }

    private boolean isDbSet() {
        return this.db_ != null;
    }

    public void setDatabase(Database db) {
        this.db_ = db;
        this.folder_ = this.isDbSet() ? this.db_.getDocFolder() : null;
    }

    private ITestResult writePagesDisp(IDocBldr docBldr) {
        docBldr.setDocCtrl(this);
        return docBldr.writePages();
    }

    private void checkSupportFiles() {
        this.setMileStone("Checking Support Files");
        MiscDocBldr miscBldr = new MiscDocBldr();
        miscBldr.setDocCtrl(this);
        ITestResult result = miscBldr.checkSupportFiles(this.folder_);
        if (!result.getPassed()) {
            this.setMileStone(result.getDetail());
        }
    }

    @Override
    public void createDocs() {
        if (this.isDbSet()) {
            this.createDocsDisp();
        } else {
            LogUtil.logErr("Warning - DbDocCtrl: db not set.");
        }
    }

    @Override
    public File getFolder() {
        return this.folder_;
    }

    @Override
    public String getMilestone() {
        return this.mileStone_;
    }

    @Override
    public String getStatus() {
        return this.status_;
    }

    @Override
    public void setFolder(File folder) {
        this.folder_ = folder;
        if (this.isDbSet()) {
            this.db_.setDocFolder(this.folder_);
        }
    }

    @Override
    public void setMileStone(String mileStone) {
        this.mileStone_ = mileStone;
        this.notifyObservers(null);
    }

    @Override
    public void setStatus(String status) {
        this.status_ = status;
        this.notifyObservers(null);
    }

    @Override
    public void setWriteMileStone(File file) {
        this.setMileStone("Writing: " + file.getAbsolutePath());
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public IOptionMgr getDocOptionMgr() {
        if (this.isDbSet()) {
            return this.db_.getDocOptionMgr();
        }
        return null;
    }
}

