/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColumnDocBldr
implements IDocBldr {
    private Database db_;
    private Table table_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private List fkColumns_;
    private List items_ = new ArrayList();
    private HtmlHelper hh_;
    private boolean dbUsesEnum_ = false;
    private boolean dbUsesUnsigned_ = false;
    public static final String CSS_URL = "../css/doc.css";
    public static final String PK_ICON_SRC = "../images/pkb16.gif";
    public static final String CHECK_MARK_SRC = "../images/ok12d.gif";
    public static final String HEADER = "Header";
    public static final String FK_COL_NM = "FkCol";
    public static final String PK_COL_NM = "PkCol";

    public ColumnDocBldr(Database db, Table table, File baseFolder) {
        this.db_ = db;
        this.setTable(table);
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "columns", null);
        this.hh_ = new HtmlHelper();
        this.updateUsedFlags();
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    public void setTable(Table table) {
        this.table_ = table;
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.basicBldr_.setMileStone("Writing column HTML files...");
                this.writePagesDisp();
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    public Element getSummaryGrid(Document doc, Table table) {
        this.setTable(table);
        if (!table.hasColumns()) {
            return this.hh_.getNoneGrid(doc, "Columns");
        }
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute("class", "flat");
        this.fkColumns_ = table.getFkColNames();
        this.hh_.setDoc(doc);
        ArrayList<String> items = new ArrayList<String>();
        items.add("PK");
        items.add("Name");
        items.add("Data Type");
        items.add("NULLs");
        items.add("A/N");
        items.add("Default");
        items.add("Comment");
        items.add("FK");
        elmGrid.appendChild(this.hh_.getBannerRow("Columns", items.size()));
        Element elmHeader = this.hh_.getRowElement(items, HEADER);
        elmGrid.appendChild(elmHeader);
        this.hh_.setRowAltProps(true, table.size(Column.getClassName()));
        for (Column column : table.values(Column.getClassName())) {
            Element elmRow = this.getAsRowElement(doc, table, column);
            elmGrid.appendChild(elmRow);
        }
        return elmGrid;
    }

    private Element getAsRowElement(Document doc, Table tbl, Column column) {
        this.hh_.setDoc(doc);
        String colName = column.getName();
        boolean isFkCol = this.fkColumns_.contains(colName);
        boolean isPkCol = column.isPkField(this.table_);
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(this.getPkIconElement(column, false));
        String dotNote = tbl.getDotNote() + "." + colName;
        String fileNm = StrHelper.getDotNoteAsUnderScore(dotNote);
        String url = "../columns/" + fileNm + ".html";
        Element anchor = this.hh_.getAnchor(colName, url, null);
        items.add(anchor);
        items.add(column.getDataTypeDesc() + column.getLengthScaleEnclosed());
        items.add(this.hh_.getBooleanImageElm(CHECK_MARK_SRC, column.getIsNullable()));
        items.add(this.hh_.getBooleanImageElm(CHECK_MARK_SRC, column.getAutoNumber()));
        items.add(column.getDefault());
        items.add(column.getComment());
        items.add(this.hh_.getBooleanImageElm(CHECK_MARK_SRC, isFkCol));
        String classNm = null;
        if (isFkCol) {
            classNm = FK_COL_NM;
        }
        if (isPkCol) {
            classNm = PK_COL_NM;
        }
        Element elmRow = this.hh_.getRowElement(items, classNm);
        return elmRow;
    }

    private void writePagesDisp() throws Exception {
        ArrayList items = new ArrayList();
        int totalItems = this.db_.getTotalTableItems(Column.getClassName());
        int i = 0;
        Iterator itTable = this.db_.getAllTables().iterator();
        while (itTable.hasNext()) {
            this.setTable((Table)itTable.next());
            this.fkColumns_ = this.table_.getFkColNames();
            for (Column column : this.table_.values(Column.getClassName())) {
                items.clear();
                String columnName = column.getName();
                String dotNote = this.table_.getDotNote() + "." + columnName;
                String fileNm = StrHelper.getDotNoteAsUnderScore(dotNote);
                File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), fileNm + ".html");
                String columnFileName = StrHelper.getFileSafeStr(this.table_.getName() + "_" + columnName);
                boolean isFkCol = this.fkColumns_.contains(columnName);
                this.setStatus(file, ++i, totalItems);
                Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.table_, column);
                this.hh_.setDoc(doc);
                Element elmBody = HtmlHelper.getBodyElement(doc);
                Element elmGrid = doc.createElement("table");
                MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
                elmBody.appendChild(elmGrid);
                elmGrid.setAttribute("class", "flat");
                elmGrid.appendChild(this.hh_.getBannerRow(columnName, "Column"));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Name", columnName));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Comment", column.getComment()));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Data Type", column.getDataTypeDesc() + column.getLengthScaleEnclosed()));
                Element elmPk = this.getPkIconElement(column, true);
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Primary Key", elmPk));
                Element elmBool = this.hh_.getBoolImgHorzElm(CHECK_MARK_SRC, column.getIsNullable());
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Nulls", elmBool));
                elmBool = this.hh_.getBoolImgHorzElm(CHECK_MARK_SRC, column.getAutoNumber());
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Auto Num.", elmBool));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Default", column.getDefault()));
                if (this.dbUsesUnsigned_) {
                    elmBool = this.hh_.getBoolImgHorzElm(CHECK_MARK_SRC, !column.getSignedFlag());
                    elmGrid.appendChild(this.hh_.getKeyValueRowElm("Unsigned", elmBool));
                }
                if (this.dbUsesEnum_) {
                    elmGrid.appendChild(this.hh_.getKeyValueRowElm("ENUM Values", column.getEnumCsv()));
                }
                elmBool = this.hh_.getBoolImgHorzElm(CHECK_MARK_SRC, isFkCol);
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("FK", elmBool));
                XmlHelper.writeElement(doc.getDocumentElement(), file);
            }
        }
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "Column", currentItem, totalItems);
    }

    public boolean getDbUsesEnum() {
        return this.dbUsesEnum_;
    }

    public boolean getDbUsesUnsigned() {
        return this.dbUsesUnsigned_;
    }

    private Element getPkIconElement(Column column, boolean isHorzElm) {
        boolean isInPk;
        int colPos = column.getPkColumnPos(this.table_);
        boolean bl = isInPk = colPos > -1;
        if (isHorzElm) {
            Element elmPk = this.hh_.getBoolImgHorzElm(this.getPkIconSrc(colPos), isInPk);
            return elmPk;
        }
        return this.hh_.getBooleanImageElm(this.getPkIconSrc(colPos), isInPk);
    }

    private String getPkIconSrc(int colPos) {
        if (colPos > 0) {
            return "../images/pkIcons/pkb" + colPos + "_16.gif";
        }
        return PK_ICON_SRC;
    }

    private void updateUsedFlags() {
        this.dbUsesEnum_ = false;
        this.dbUsesUnsigned_ = false;
        boolean bothFound = false;
        Iterator itTbl = this.db_.getAllTables().iterator();
        while (itTbl.hasNext() && !bothFound) {
            Table table = (Table)itTbl.next();
            for (Column column : table.values(Column.getClassName())) {
                if (!column.getSignedFlag()) {
                    this.dbUsesUnsigned_ = true;
                }
                if (column.getDataTypeId() != 706) continue;
                this.dbUsesEnum_ = true;
            }
            bothFound = this.dbUsesEnum_ && this.dbUsesUnsigned_;
        }
    }
}

