/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.table.fill;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.TextOption;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.sketch.glyph.rect.fill.BasicRectangleFill;
import com.harrand.sketch.glyph.rect.fill.HeaderFooterFill;
import com.harrand.sketch.glyph.rect.fill.IRectangleFill;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public final class RectangleFillFactory {
    private static RectangleFillFactory instance = new RectangleFillFactory();
    private Map<String, IRectangleFill> rectangleFills;

    private RectangleFillFactory() {
        this.init();
    }

    public static RectangleFillFactory getInstance() {
        return instance;
    }

    public ArrayList<IRectangleFill> getRectangleFills() {
        return new ArrayList<IRectangleFill>(this.rectangleFills.values());
    }

    public IRectangleFill getRectangleFill(String name) {
        return this.rectangleFills.get(name);
    }

    private void init() {
        this.rectangleFills = new TreeMap<String, IRectangleFill>();
        this.addRectangleFill(new BasicRectangleFill());
        this.addRectangleFill(new HeaderFooterFill());
    }

    public IRectangleFill getDefaultRectangleFill() {
        return this.getRectangleFill("HeaderFooterFill");
    }

    public IRectangleFill getOptionMgrRectangleFill() {
        DbUser user = App.getUser();
        IOptionMgr optMgr = user.getOptionMgr("diagram.option.mgr");
        TextOption rectangleFillOption = (TextOption)optMgr.getOption(TextOption.clazz(), "diagram.db.table.rectangle.fill");
        if (rectangleFillOption != null) {
            return this.getRectangleFill(rectangleFillOption.getValue());
        }
        return this.getDefaultRectangleFill();
    }

    public IRectangleFill getBestGuessRectangleFill() {
        IRectangleFill guessRectangleFill = this.getOptionMgrRectangleFill();
        if (guessRectangleFill == null) {
            guessRectangleFill = this.getDefaultRectangleFill();
        }
        return guessRectangleFill;
    }

    private void addRectangleFill(IRectangleFill fill) {
        this.rectangleFills.put(fill.getName(), fill);
    }
}

