/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.table;

import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.element.FkUtil;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.core.box.DiagramBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import java.util.ArrayList;
import java.util.List;

public final class DbTableGlyphLinkBoxesBldr {
    public List<LinkBoxPair> getLinkBoxes(Diagram diagram, List<DbTableGlyph> dbTableGlyphs) {
        ArrayList<LinkBoxPair> linkBoxPairs = new ArrayList<LinkBoxPair>();
        Database db = LookupUtil.getLookupDb();
        FkUtil fkUtil = new FkUtil(db);
        for (DbTableGlyph tableGlyph : dbTableGlyphs) {
            Table table = tableGlyph.getTable();
            List<ForeignKey> fks = fkUtil.getAllRelationsForTable(table);
            for (ForeignKey fk : fks) {
                LinkBoxPair linkBoxPair;
                String fkName = fk.getDotNote();
                Link fkLink = diagram.getLink(fkName);
                if (fkLink == null || (linkBoxPair = this.createLinkBoxPair(fkLink, fk, diagram)) == null) continue;
                linkBoxPairs.add(linkBoxPair);
            }
        }
        return linkBoxPairs;
    }

    public LinkBoxPair createLinkBoxPair(Link fkLink, ForeignKey fk, Diagram diagram) {
        ForeignKeyGlyph fkGlyph = (ForeignKeyGlyph)fkLink;
        LinkBoxPair linkBoxPair = new LinkBoxPair(fkGlyph);
        Table parentTable = fk.getParTbl();
        Table childTable = fk.getChdTbl();
        DbTableGlyph parentTableGlyph = (DbTableGlyph)diagram.getGlyph(parentTable.getDotNote());
        DbTableGlyph childTableGlyph = (DbTableGlyph)diagram.getGlyph(childTable.getDotNote());
        if (parentTableGlyph != null && childTableGlyph != null) {
            this.setDiagramBoxes(linkBoxPair, parentTableGlyph, childTableGlyph);
            return linkBoxPair;
        }
        return null;
    }

    public void setDiagramBoxes(LinkBoxPair linkBoxPair, DbTableGlyph parentTableGlyph, DbTableGlyph childTableGlyph) {
        DiagramBox parentBox = new DiagramBox(parentTableGlyph.getName(), parentTableGlyph.getBounds2D());
        linkBoxPair.setParentBox(parentBox);
        DiagramBox childBox = new DiagramBox(childTableGlyph.getName(), childTableGlyph.getBounds2D());
        linkBoxPair.setChildBox(childBox);
    }
}

