/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.relation.notation.erNotation;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.TextOption;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.BachmanErNotation;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.BarkerErNotation;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.DbwErNotation;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.InfoEngErNotation;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class DbwErNotationFactory {
    private static DbwErNotationFactory instance = new DbwErNotationFactory();
    private Map<String, IErNotation> notations;

    private DbwErNotationFactory() {
        this.init();
    }

    public static DbwErNotationFactory getInstance() {
        return instance;
    }

    public ArrayList<IErNotation> getNotations() {
        return new ArrayList<IErNotation>(this.notations.values());
    }

    public IErNotation getNotation(String clsNm) {
        return this.notations.get(clsNm);
    }

    private void init() {
        this.notations = new TreeMap<String, IErNotation>();
        this.addNotation(new BachmanErNotation());
        this.addNotation(new BarkerErNotation());
        this.addNotation(new DbwErNotation());
        this.addNotation(new InfoEngErNotation());
    }

    public IErNotation getDefaultNotation() {
        return this.getNotation("BarkerErNotation");
    }

    public IErNotation getOptionMgrNotation() {
        IErNotation optionNotation = null;
        DbUser user = App.getUser();
        IOptionMgr optMgr = user.getOptionMgr("diagram.option.mgr");
        TextOption erNotationOption = (TextOption)optMgr.getOption(TextOption.clazz(), "diagram.er.notation");
        if (erNotationOption != null) {
            optionNotation = this.getNotation(erNotationOption.getValue());
        }
        return optionNotation;
    }

    public IErNotation getBestGuessNotation() {
        IErNotation guessNotation = this.getOptionMgrNotation();
        if (guessNotation == null) {
            guessNotation = this.getDefaultNotation();
        }
        return guessNotation;
    }

    private void addNotation(IErNotation notation) {
        this.notations.put(notation.getName(), notation);
    }
}

