/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.hilight;

import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.fk.FkNameDrawer;
import com.harrand.dbwrench.diagram.hilight.color.BlueColorScheme;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.dbwrench.diagram.table.ITableGlyph;
import com.harrand.dbwrench.diagram.table.extract.GlyphByTableExtractor;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.hilight.JointGlyphHiLighter;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.ThickArc;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.relation.glyph.JointGlyph;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;

public class FkGlyphHilighter {
    private final BoxLink boxLink;
    private final FkNameDrawer fkNmDrawer;
    private final JointGlyphHiLighter chdJointHiLighter;
    private final JointGlyphHiLighter parJointHiLighter;
    private IColorScheme colorScheme = BlueColorScheme.getInstance();
    private double zoomLevel_;
    public static final int THICKNESS = 4;

    public FkGlyphHilighter(BoxLink boxLink, FkNameDrawer fkNmDrawer) {
        this.boxLink = boxLink;
        this.fkNmDrawer = fkNmDrawer;
        JointGlyph chdJoint = this.getChildJointGlyph();
        JointGlyph parJoint = this.getParentJointGlyph();
        this.chdJointHiLighter = new JointGlyphHiLighter(chdJoint);
        this.parJointHiLighter = new JointGlyphHiLighter(parJoint);
    }

    public FkGlyphHilighter(BoxLink boxLink) {
        this(boxLink, null);
    }

    public void setColorScheme(IColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public List<IDrawable> getHilightShapes(Diagram diagram) {
        this.chdJointHiLighter.setJoint(this.getChildJointGlyph());
        this.parJointHiLighter.setJoint(this.getParentJointGlyph());
        this.zoomLevel_ = diagram.getZoom().getLevel();
        ArrayList<IDrawable> hilightShapes = new ArrayList<IDrawable>();
        hilightShapes.addAll(this.getThickShapesDisp());
        hilightShapes.addAll(this.getJointOutlinesDisp());
        if (this.isForeignKeyGlyph()) {
            hilightShapes.addAll(this.getFkColumnHiLights(diagram, (ForeignKeyGlyph)this.boxLink));
        }
        if (this.fkNmDrawer != null) {
            hilightShapes.addAll(this.fkNmDrawer.getHilightShapes());
        }
        return hilightShapes;
    }

    public boolean isForeignKeyGlyph() {
        return this.boxLink instanceof ForeignKeyGlyph;
    }

    /*
     * WARNING - void declaration
     */
    private List getThickShapesDisp() {
        ArrayList<IDrawable> thickShapes = new ArrayList<IDrawable>();
        List<? extends Shape> shapes = this.boxLink.getShapes();
        for (Shape shape : shapes) {
            void var5_5;
            Shape shape2;
            if (shape instanceof EnhancedShape) {
                shape2 = ((EnhancedShape)((Object)shape)).getShape();
            } else {
                if (!(shape instanceof Shape)) continue;
                shape2 = shape;
            }
            if (var5_5 instanceof Line2D) {
                Line2D line = (Line2D)var5_5;
                thickShapes.add(this.getEnhancedLine(line, 5, this.colorScheme.getColorC()));
                thickShapes.add(this.getEnhancedLine(line, 3, this.colorScheme.getColorB()));
                thickShapes.add(this.getEnhancedLine(line, 1, this.colorScheme.getColorA()));
            }
            if (!(var5_5 instanceof Arc2D)) continue;
            Arc2D arc = (Arc2D)var5_5;
            thickShapes.add(this.getThickArcDisp(arc, 5, this.colorScheme.getColorC()));
            thickShapes.add(this.getThickArcDisp(arc, 3, this.colorScheme.getColorB()));
            thickShapes.add(this.getThickArcDisp(arc, 1, this.colorScheme.getColorA()));
        }
        return thickShapes;
    }

    private JointGlyph getChildJointGlyph() {
        return (JointGlyph)this.boxLink.getJoint(this.boxLink.getChildJointName());
    }

    private JointGlyph getParentJointGlyph() {
        return (JointGlyph)this.boxLink.getJoint(this.boxLink.getParentJointName());
    }

    private ThickArc getThickArcDisp(Arc2D arc, int thickness, Color color) {
        Arc2D zoomedArc = (Arc2D)Zoomer.zoom(arc, this.zoomLevel_);
        return new ThickArc(zoomedArc, thickness, color);
    }

    private EnhancedShape getEnhancedLine(Line2D line, int thickness, Color color) {
        EnhancedShape eLine = new EnhancedShape(line, color);
        eLine.setThickness(thickness);
        eLine.setIsDashed(this.getUseDashedLines());
        return eLine;
    }

    private List getJointOutlinesDisp() {
        ArrayList jointLines = new ArrayList();
        jointLines.addAll(this.chdJointHiLighter.getHilightShapes(this.zoomLevel_));
        jointLines.addAll(this.parJointHiLighter.getHilightShapes(this.zoomLevel_));
        return jointLines;
    }

    private List getFkColumnHiLights(Diagram diagram, ForeignKeyGlyph foreignKeyGlyph) {
        EnhancedShape shape;
        RoundRectangle2D.Double roundRect;
        Rectangle2D rect;
        ArrayList<EnhancedShape> eShapes = new ArrayList<EnhancedShape>();
        ForeignKey fk = foreignKeyGlyph.getForeignKey();
        Table parTbl = fk.getParTbl();
        List<Column> parCols = fk.getParentColumns();
        Table chdTbl = fk.getChdTbl();
        List<Column> chdCols = fk.getChildColumns();
        List<Glyph> glyphs = diagram.getGlyphs(false);
        GlyphByTableExtractor extractor = new GlyphByTableExtractor();
        ITableGlyph parTblGlyph = extractor.getGlyphByTable(glyphs, parTbl);
        ITableGlyph chdTblGlyph = extractor.getGlyphByTable(glyphs, chdTbl);
        int round = 7;
        for (Column parCol : parCols) {
            rect = parTblGlyph.getColumnBounds(parCol.getName());
            if (rect == null) continue;
            roundRect = new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), round, round);
            shape = new EnhancedShape(roundRect, this.colorScheme.getColorA());
            eShapes.add(shape);
        }
        for (Column childCol : chdCols) {
            rect = chdTblGlyph.getColumnBounds(childCol.getName());
            if (rect == null) continue;
            roundRect = new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), round, round);
            shape = new EnhancedShape(roundRect, this.colorScheme.getColorA());
            eShapes.add(shape);
        }
        return eShapes;
    }

    private boolean getUseDashedLines() {
        if (this.isForeignKeyGlyph()) {
            return ((ForeignKeyGlyph)this.boxLink).getUseDashedLines();
        }
        return true;
    }
}

