/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.fk;

import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.core.GlyphTextLine;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.highLight.RoundRectHighLighter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FkNameDrawer
implements IDrawable {
    private ForeignKeyGlyph fkGlyph;
    private Diagram diagram;
    private IPositioningCoord nmPosCoord;
    private RoundRectHighLighter rectHighLighter = new RoundRectHighLighter();
    private Dimension canvasSz;
    private String fkNm;
    private BufferedImage BI;
    public static final int PAD = 4;
    public static final int ROUND_RADIUS = 8;

    public FkNameDrawer(Diagram diagram, ForeignKeyGlyph fkGlyph) {
        this.diagram = diagram;
        this.fkGlyph = fkGlyph;
        this.fkNm = fkGlyph.getForeignKeyName();
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        if (this.nmPosCoord != null) {
            if (!this.getShowFkNames()) {
                return;
            }
            this.createBI();
            Point drawPt = this.getTopLeft(g2);
            if (zoom.isOne()) {
                g2.drawImage((Image)this.BI, drawPt.x, drawPt.y, null);
            } else {
                this.drawImgZoomed(zoom, g2, this.fkNm, drawPt);
            }
        }
    }

    public void setNmPosCoord(IPositioningCoord nmPosCoord) {
        this.nmPosCoord = nmPosCoord;
    }

    public IPositioningCoord getNmPosCoord() {
        return this.nmPosCoord;
    }

    public List<IDrawable> getHilightShapes() {
        ArrayList<IDrawable> hilights = new ArrayList<IDrawable>();
        if (!this.getShowFkNames()) {
            return hilights;
        }
        this.createBI();
        RoundRectangle2D outline = this.getOutlineRect(this.getTopLeft(this.getBI_G2()));
        hilights.addAll(this.rectHighLighter.getHilightShapesLite(outline, this.getZoom()));
        hilights.add(this.getGlyphImage());
        return hilights;
    }

    private Zoom getZoom() {
        return this.diagram.getZoom();
    }

    public Collection getSvgShapes() {
        ArrayList<Object> shapes = new ArrayList<Object>();
        if (!this.getShowFkNames()) {
            return shapes;
        }
        shapes.add(this.getCanvasEnhancedRect());
        shapes.add(this.getGlyphTextLine());
        return shapes;
    }

    private EnhancedShape getCanvasEnhancedRect() {
        RoundRectangle2D outlineRect = this.getOutlineRect(this.getTopLeft(this.getBI_G2()));
        EnhancedShape eShape = new EnhancedShape(outlineRect, Color.WHITE);
        eShape.setIsStroked(false);
        return eShape;
    }

    private Graphics2D getBI_G2() {
        if (this.BI == null) {
            this.createBI();
        }
        return (Graphics2D)this.BI.getGraphics();
    }

    private Color getColor() {
        return this.fkGlyph.getColor("BackColor");
    }

    private Point getTopLeft(Graphics2D g2) {
        this.nmPosCoord.setG2(g2);
        return this.nmPosCoord.getTopLeft(this.getFont(), this.fkNm);
    }

    private Point getBottomLeft() {
        int height = GuiHelper.getSwingStringHeight(this.getFont());
        Point topLeft = this.getTopLeft(this.getBI_G2());
        return new Point(topLeft.x, topLeft.y + height);
    }

    private void drawImgZoomed(Zoom zoom, Graphics2D g2, String fkNm, Point bottomLeft) {
        double zmLevel = zoom.getLevel();
        Point zmPt = Zoomer.zoom(bottomLeft, zmLevel);
        AffineTransform tx = new AffineTransform();
        tx.scale(zmLevel, zmLevel);
        AffineTransformOp txOp = new AffineTransformOp(tx, 3);
        g2.drawImage(this.BI, txOp, zmPt.x, zmPt.y);
    }

    private GlyphImage getGlyphImage() {
        double zmLevel = this.getZoom().getLevel();
        Point zmTopLeft = Zoomer.zoom(this.getTopLeft(this.getBI_G2()), zmLevel);
        GlyphImage glyphImage = new GlyphImage(this.BI, zmTopLeft);
        double scaleUp = 1.6666666666666667;
        glyphImage.setScaleFactor(scaleUp * zmLevel);
        return glyphImage;
    }

    private void drawNm(Graphics2D gfx) {
        RoundRectangle2D outline = this.getOutlineRect(new Point(0, 0));
        GuiHelper.setAntiAliasOn(gfx);
        gfx.setFont(this.getFont());
        gfx.setPaint(Color.WHITE);
        gfx.fill(outline);
        gfx.setPaint(this.getColor());
        int y = this.canvasSz.height - 4;
        gfx.drawString(this.fkNm, 4, y);
        gfx.setPaint(Color.BLACK);
    }

    private void calcCanvasSz() {
        Font font = this.getFont();
        int width = GuiHelper.getSwingStringLength(this.fkNm, font) + 8;
        int height = GuiHelper.getSwingStringHeight(font) + 4;
        this.canvasSz = new Dimension(width, height);
    }

    private void createBI() {
        this.calcCanvasSz();
        this.BI = GuiHelper.getBufferedImage(this.canvasSz.width, this.canvasSz.height, true);
        this.drawNm(this.getBI_G2());
    }

    private RoundRectangle2D getOutlineRect(Point origin) {
        return new RoundRectangle2D.Double(origin.x, origin.y, this.canvasSz.width - 1, this.canvasSz.height - 1, 8.0, 8.0);
    }

    private Object getGlyphTextLine() {
        Point bottomLeft = this.getBottomLeft();
        Point textPt = new Point(bottomLeft.x + 4, bottomLeft.y);
        return new GlyphTextLine(this.fkNm, textPt, this.getFont(), GlyphTextLine.getAlignLeft(), this.getColor());
    }

    private Font getFont() {
        return this.diagram.getRenderConfig().getFont();
    }

    private boolean getShowFkNames() {
        return this.diagram.getDiagramProps().getShowFkNames();
    }

    public boolean contains(Point2D p) {
        if (!this.getShowFkNames()) {
            return false;
        }
        RoundRectangle2D outlineRect = this.getOutlineRect(this.getTopLeft(this.getBI_G2()));
        return outlineRect.contains(p);
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setName(String newName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

