/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.column;

import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.security.App;
import com.harrand.util.Validator;

public class ColumnDiagramTextFormatter {
    private Column column;
    public static final String NULL_DESC = "NULL";
    public static final String NOT_NULL_DESC = "NOT NULL";
    public static final String DEFAULT_DESC = "DEFAULT";

    public ColumnDiagramTextFormatter(Column column) {
        this.column = column;
    }

    public String getSignedText() {
        String str = this.column.getSignedFlag() ? "SIGNED" : "UNSIGNED";
        return str;
    }

    public String getIsNullText() {
        if (this.column.getIsNullable()) {
            return NULL_DESC;
        }
        return NOT_NULL_DESC;
    }

    public String getDefaultText() {
        boolean hasText = Validator.isStringValid(this.column.getDefault());
        String text = hasText ? "[" + App.getRes("default.abbr") + ": " + this.column.getDefault() + "]" : "";
        return text;
    }

    public String getAutoNumberText() {
        boolean hasText = this.column.getAutoNumber();
        String text = hasText ? "(" + this.column.getAutoNumberDesc() + ")" : "";
        return text;
    }

    public String getCommentText() {
        boolean hasText = Validator.isStringValid(this.column.getComment());
        String text = hasText ? "(" + this.column.getComment() + ")" : "";
        return text;
    }

    public String getIsArrayText() {
        String isArrayStr = "";
        if (this.column.getIsArray()) {
            isArrayStr = "[] ";
        }
        return isArrayStr;
    }

    public String getLengthScaleText() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.column.getLengthStr());
        if (this.column.getScale() != null) {
            sb.append(", ");
            sb.append(this.column.getScaleStr());
        }
        sb.append(")");
        String str = sb.toString();
        return str;
    }
}

