/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.bldr;

import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.Icons;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.column.ColumnTextLineStore;
import com.harrand.dbwrench.diagram.table.TableGlyphWidthCalc;
import com.harrand.dbwrench.diagram.table.TableTitleStringBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.diagram.clickAction.bldr.DbTableGlyphClickActionCtrl;
import com.harrand.dbwrenchgui.diagram.text.textLine.table.TableTitleTextLine;
import com.harrand.sketch.command.clickAction.action.IClickAction;
import com.harrand.sketch.command.clickAction.action.IClickActionProvider;
import com.harrand.sketch.command.clickAction.draw.ClickActionPosCalc;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.core.GlyphTextLine;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.glyph.GlyphPosUtil;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DbTableSubGlyphBldr {
    private DbTableGlyphClickActionCtrl clickActionCtrl;
    private final DbTableGlyph tableGlyph;
    private final ClickActionPosCalc clickActionPosCalc = new ClickActionPosCalc();
    private final TableGlyphWidthCalc tableGlyphWidthCalc;
    private Map<String, ColumnTextLineStore> columnTextLineStores = new HashMap<String, ColumnTextLineStore>();
    private TableTitleStringBldr tableTitleStrBldr = new TableTitleStringBldr();
    private Table table;
    private PrimaryKey pk;
    private GlyphPosUtil posUtil;
    private static final BufferedImage FK_BI = Icons.getBufferedImage("Fk");
    private static final BufferedImage IDX_BI = Icons.getBufferedImage("Index");
    private static final BufferedImage TBL_BI = Icons.getBufferedImage("Table");
    private static final BufferedImage NULLABLE_BI = Icons.getBufferedImage("nullable");
    public static final int ADD_COL_ICON_POS = 2;
    public static final int DELETE_COL_ICON_POS = 1;
    public static final int NULL_RIGHT_POS = 3;
    public static final int FK_RIGHT_POS = 1;
    public static final int IDX_RIGHT_POS = 2;
    public static final int SHOW_DATA_RIGHT_POS = 1;
    public static final int DELETE_TBL_CENTER_POS = 1;
    public static final int TBL_PROPS_LEFT_POS = 1;

    public DbTableSubGlyphBldr(DbTableGlyph tableGlyph) {
        this.tableGlyph = tableGlyph;
        this.table = tableGlyph.getTable();
        this.posUtil = this.tableGlyph.getPosUtil();
        this.refreshPk();
        this.clickActionCtrl = this.tableGlyph.getClickActionCtrl();
        this.tableGlyphWidthCalc = new TableGlyphWidthCalc(tableGlyph);
    }

    public DbTableGlyphClickActionCtrl getTableGlyphClickActionCtrl() {
        return this.clickActionCtrl;
    }

    public void clearColumnTextLineStores() {
        this.columnTextLineStores.clear();
    }

    public List<GlyphTextLine> getColumnGlyphTexts(Column column, Point cursor) {
        ColumnTextLineStore columnTextLineStore = this.getColumnTextLineStore(column);
        List<GlyphTextLine> glyphTexts = columnTextLineStore.getColumnGlyphTexts(column, cursor);
        if (!this.areClickActionsEnabled()) {
            return glyphTexts;
        }
        for (GlyphTextLine glyphText : glyphTexts) {
            if (!(glyphText instanceof IClickActionProvider)) continue;
            this.getClickActionFromProvider(glyphText, column);
        }
        return glyphTexts;
    }

    private ColumnTextLineStore getColumnTextLineStore(Column column) {
        String colNm = column.getName();
        ColumnTextLineStore columnTextLineStore = null;
        if (this.columnTextLineStores.containsKey(colNm)) {
            columnTextLineStore = this.columnTextLineStores.get(colNm);
        } else {
            columnTextLineStore = new ColumnTextLineStore(this.tableGlyph, column);
            this.columnTextLineStores.put(colNm, columnTextLineStore);
        }
        return columnTextLineStore;
    }

    private boolean areClickActionsEnabled() {
        return this.clickActionCtrl.getIsEnabled();
    }

    private void getClickActionFromProvider(GlyphTextLine glyphText, Identifiable idf) {
        IClickActionProvider provider = (IClickActionProvider)((Object)glyphText);
        String clickActionNm = provider.getClickActionNm(idf);
        boolean clickActionExists = this.clickActionCtrl.getHasClickAction(clickActionNm);
        IClickAction clickAction = clickActionExists ? this.clickActionCtrl.getClickAction(clickActionNm) : this.clickActionCtrl.getNewClickAction(provider, idf);
        Point2D cursor = glyphText.getStart();
        clickAction.setOrigin(this.getClickActionOriginFromCursor(cursor, this.getLineHeight()));
    }

    public GlyphImage getPkGlyph(Column col, Point cursor) {
        GlyphImage pkGlyph = null;
        this.refreshPk();
        if (this.pk != null && this.pk.containsColumnName(col.getName())) {
            int colPos = col.getPkColumnPos(this.table);
            if (colPos > -1) {
                colPos = 0;
            }
            BufferedImage buffImg = Icons.getPkBufferedImg(colPos);
            pkGlyph = this.posUtil.getLeftAlignedGlyphImg(buffImg, cursor.y, "pk_icon", this.getTableGlyphOrigin());
        }
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getSetPkClickAction(col);
            clickAction.setOrigin(this.getClickActionOriginFromCursor(cursor, this.getLineHeight()));
        }
        return pkGlyph;
    }

    public GlyphImage getNullableGlyph(Column col, Point cursor) {
        GlyphImage glyphImage = null;
        Point2D topLeft = this.posUtil.getRightPositionTopLeft(3, cursor.y);
        boolean isNull = col.getIsNullable();
        if (isNull) {
            glyphImage = this.posUtil.createGlyphImg(NULLABLE_BI, topLeft, "nullable_icon");
        }
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getSetNullClickAction(col);
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public GlyphImage getFkGlyph(Column col, Point cursor) {
        GlyphImage glyphImage = null;
        Point2D topLeft = this.posUtil.getRightPositionTopLeft(1, cursor.y);
        boolean isFkColumn = this.table.getIsFkCol(col.getName());
        if (isFkColumn) {
            glyphImage = this.posUtil.createGlyphImg(FK_BI, topLeft, "fk_icon");
        }
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getSetFkClickAction(col);
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public GlyphImage getIndexGlyph(Column col, Point cursor) {
        GlyphImage glyphImage = null;
        Point2D topLeft = this.posUtil.getRightPositionTopLeft(2, cursor.y);
        boolean isIndexCol = this.table.getIsIndexColumn(col);
        if (isIndexCol) {
            glyphImage = this.posUtil.createGlyphImg(IDX_BI, topLeft, "index_icon");
            glyphImage.setScaleFactor(this.getScaleFactor());
        }
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getSetIndexClickAction(col);
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public GlyphImage getDeleteColumnGlyph(Column col, Point cursor) {
        GlyphImage glyphImage = null;
        Point2D topLeft = this.posUtil.getAfterColumnNmTopLeft(col.getName(), cursor.y, 1);
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getDeleteColumnClickAction(col);
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public GlyphImage getAddColumnGlyph(Column col, int colInsertPos, Point cursor) {
        GlyphImage glyphImage = null;
        Point2D topLeft = this.posUtil.getAfterColumnNmTopLeft(col.getName(), cursor.y, 2);
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getAddColumnClickAction(colInsertPos);
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public GlyphTextLine getTableGlyphText(String titleStr) {
        Point2D btmLeft = this.posUtil.getTableNmBtmLeft(titleStr);
        Font headerFont = this.getRenderConfig().getHeaderFont();
        TableTitleTextLine textLine = new TableTitleTextLine(this.getTable(), titleStr, btmLeft, headerFont);
        textLine.setCoordSpace(this.getTableGlyphOrigin());
        if (this.areClickActionsEnabled()) {
            this.getClickActionFromProvider(textLine, this.getTable());
        }
        return textLine;
    }

    public GlyphImage getTableDetailsGlyph() {
        Point2D topLeft = this.posUtil.getTableLeftPositionTopLeft(1);
        GlyphImage glyphImage = this.posUtil.createGlyphImg(TBL_BI, topLeft, "table_icon");
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getTableDetailsClickAction();
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public GlyphImage getTablePropsGlyph() {
        Point2D topLeft = this.posUtil.getTableLeftPositionTopLeft(1);
        GlyphImage glyphImage = this.posUtil.createGlyphImg(TBL_BI, topLeft, "table_icon");
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getTablePropsClickAction();
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public GlyphImage getDeleteTableGlyph(double tblNmStartX) {
        GlyphImage glyphImage = null;
        Point2D topLeft = this.posUtil.getAfterTableNmTopLeft(this.getTitleStr(), tblNmStartX, 1);
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getDeleteTableClickAction();
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public GlyphImage getShowDataGlyph() {
        GlyphImage glyphImage = null;
        Point2D topLeft = this.posUtil.getTableRightPositionTopLeft(1);
        if (this.areClickActionsEnabled()) {
            IClickAction clickAction = this.clickActionCtrl.getShowDataClickAction();
            clickAction.setOrigin(this.getClickActionOriginFromTopLeft(topLeft));
        }
        return glyphImage;
    }

    public String getTitleStr() {
        return this.tableTitleStrBldr.getTitleStr(this.getTable(), this.getVb());
    }

    public int getMaxWidth() {
        return (int)this.getTableGlyphWidth();
    }

    private Table getTable() {
        return this.tableGlyph.getTable();
    }

    private double getTableGlyphWidth() {
        return new TableGlyphWidthCalc(this.tableGlyph).getWidth();
    }

    private RenderConfig getRenderConfig() {
        return this.tableGlyph.getRenderConfig();
    }

    private DbVerbosity getVb() {
        return (DbVerbosity)this.getRenderConfig().getVerbosityConfig();
    }

    private Point getTableGlyphOrigin() {
        return this.tableGlyph.getStart();
    }

    private void refreshPk() {
        this.pk = this.table.getPrimaryKey();
    }

    private double getScaleFactor() {
        return this.getRenderConfig().getScaleFactor();
    }

    private double getLineHeight() {
        return this.getRenderConfig().getLineHeight();
    }

    private Point2D getClickActionOriginFromCursor(Point cursor, double lineHeight) {
        return this.clickActionPosCalc.getClickActionOriginFromCursor(cursor, lineHeight);
    }

    private Point2D getClickActionOriginFromCursor(Point2D cursor, double lineHeight) {
        return this.clickActionPosCalc.getClickActionOriginFromCursor(cursor, lineHeight);
    }

    private Point2D getClickActionOriginFromTopLeft(Point2D topLeft) {
        return this.clickActionPosCalc.getClickActionOriginFromGlyphImg(topLeft);
    }
}

