/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.bldr;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.diagram.autoLayout.DbLayoutCtrl;
import com.harrand.dbwrench.diagram.bldr.DbTableLayoutDisp;
import com.harrand.dbwrench.diagram.bldr.DefaultDbwDiagramBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.diagram.DbwDiagramPanelMouseHelper;
import com.harrand.sketch.core.Diagram;
import java.awt.Point;
import java.util.List;

public class DbAutoDiagramBldr {
    private Database db;
    private DefaultDbwDiagramBldr diagramBldr = new DefaultDbwDiagramBldr();
    public static final int LOTS_OF_TABLES = 40;
    public static final Point TOP_LEFT_ORIGIN = new Point(50, 50);

    public void addAutoDiagrams(Database db) {
        this.db = db;
        if (this.getBuildManyDiagrams()) {
            this.addDiagramPerSchema();
        } else {
            this.updateDefaultDiagram();
        }
    }

    private void addDiagramPerSchema() {
        this.db.remove(Diagram.getClassName(), "diagramA");
        for (Schema sch : this.db.getSchemas()) {
            List<Table> tables = sch.getTables();
            String diaNm = sch.getName();
            this.createDiagram(tables, diaNm);
        }
    }

    private boolean getBuildManyDiagrams() {
        int schCount = this.db.size(Schema.getClassName());
        boolean hasManySchemas = schCount > 1;
        int tblCount = this.db.getAllTables().size();
        boolean hasLotsOfTables = tblCount > 40;
        return hasManySchemas && hasLotsOfTables;
    }

    private void createDiagram(List<Table> tables, String diaNm) {
        Diagram diagram = this.diagramBldr.createDiagram(this.db, diaNm);
        this.db.add(diagram);
        this.layoutGlyphs(tables, diagram);
    }

    private void layoutGlyphs(List<Table> tables, Diagram diagram) {
        new DbTableLayoutDisp().layoutTables(diagram, tables);
    }

    private void updateDefaultDiagram() {
        DbLayoutCtrl layoutCtrl = new DbLayoutCtrl(this.db);
        DbwDiagramPanelMouseHelper mouseHelper = new DbwDiagramPanelMouseHelper();
        int tblCount = this.db.getAllTables().size();
        ITestResult result = layoutCtrl.checkTooManyGlyphs(tblCount);
        if (result.getPassed()) {
            Diagram diagram = this.db.getDiagram("diagramA");
            this.layoutGlyphs(this.db.getAllTablesGen(), diagram);
        }
    }
}

