/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.coreclasses.element.ILayoutItem;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TableFkInfo
implements Comparable,
ILayoutItem,
INamed {
    private Database db_;
    private Diagram diagram_;
    private Table table_;
    private int tableType_ = 4;
    private Rectangle bounds_ = new Rectangle();
    private String direction_ = "East";
    private List linkColumnsNms_ = new ArrayList();
    private List chdTblDotNotes_ = new ArrayList();
    private List parTblDotNotes_ = new ArrayList();
    private List childFks_ = new ArrayList();
    private List parentFks_ = new ArrayList();
    private int childFkCount_ = 0;
    private int parentFkCount_ = 0;
    private int totalFkCount_ = 0;
    public static final int LONER_TBL = 0;
    public static final int LEAF_TBL = 1;
    public static final int MULTI_LINK_TBL = 4;
    private static final String EAST_STR = "East";

    public TableFkInfo(Database db, Diagram diagram, Dimension size, List diagramTblDotNotes, Table table) {
        this.db_ = db;
        this.diagram_ = diagram;
        this.table_ = table;
        this.bounds_ = new Rectangle(size);
        this.calcFkRelations(diagramTblDotNotes);
        this.calcTableType();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!(obj instanceof TableFkInfo)) {
            return 0;
        }
        TableFkInfo other = (TableFkInfo)obj;
        return this.getName().compareTo(other.getName());
    }

    public List getRelations() {
        ArrayList relations = new ArrayList(this.childFks_);
        relations.addAll(this.parentFks_);
        return relations;
    }

    public List getConnectedTblDotNotes() {
        ArrayList connectedTableNms = new ArrayList(this.getChdTblDotNotes());
        connectedTableNms.addAll(this.getParTblDotNotes());
        return connectedTableNms;
    }

    public String getSrcColumnNm(String connectedTblDotNote) {
        ForeignKey fk;
        String srcColumnNm = null;
        Iterator it = this.childFks_.iterator();
        while (srcColumnNm == null && it.hasNext()) {
            fk = (ForeignKey)it.next();
            if (!connectedTblDotNote.equals(fk.getChdTbl().getDotNote())) continue;
            srcColumnNm = fk.getParentLinkColNm();
        }
        it = this.parentFks_.iterator();
        while (srcColumnNm == null && it.hasNext()) {
            fk = (ForeignKey)it.next();
            if (!connectedTblDotNote.equals(fk.getParTbl().getDotNote())) continue;
            srcColumnNm = fk.getChildLinkColNm();
        }
        return srcColumnNm;
    }

    public List getSortedLinkColumnNms() {
        ArrayList sortedLinkColNms = new ArrayList(this.table_.getKeys(Column.getClassName()));
        sortedLinkColNms.retainAll(this.linkColumnsNms_);
        return sortedLinkColNms;
    }

    public Diagram getDiagram() {
        return this.diagram_;
    }

    Table getTable() {
        return this.table_;
    }

    @Override
    public String getDirection() {
        return this.direction_;
    }

    @Override
    public void setDirection(String direction) {
        this.direction_ = new String(direction);
    }

    public boolean isEastDirection() {
        return this.getDirection().equals(EAST_STR);
    }

    public List getChildFks() {
        return new ArrayList(this.childFks_);
    }

    public List getParentFks() {
        return new ArrayList(this.parentFks_);
    }

    public List getChdTblDotNotes() {
        return new ArrayList(this.chdTblDotNotes_);
    }

    public List getParTblDotNotes() {
        return new ArrayList(this.parTblDotNotes_);
    }

    @Override
    public String getName() {
        return this.table_.getDotNote();
    }

    public int getTableType() {
        return this.tableType_;
    }

    public boolean isLoner() {
        return this.getTableType() == 0;
    }

    public boolean isLeaf() {
        return this.getTableType() == 1;
    }

    public boolean isBranchTable() {
        return !this.isLoner() && !this.isLeaf();
    }

    @Override
    public void setName(String name) {
        LogUtil.logErr("TableFkInfo.setName() not supported");
    }

    public String toString() {
        return this.getName();
    }

    private void calcFkRelations(List diagramTblDotNotes) {
        this.linkColumnsNms_ = new ArrayList();
        this.parentFks_ = new ArrayList();
        this.parTblDotNotes_ = new ArrayList();
        List rawChildFks = this.db_.getFkUtil().getFksForTable(this.table_, 1);
        for (ForeignKey fk : rawChildFks) {
            String parTblDotNote = fk.getParTbl().getDotNote();
            if (!diagramTblDotNotes.contains(parTblDotNote)) continue;
            this.parentFks_.add(fk);
            this.parTblDotNotes_.add(parTblDotNote);
            this.linkColumnsNms_.add(fk.getChildLinkColNm());
        }
        this.childFks_ = new ArrayList();
        this.chdTblDotNotes_ = new ArrayList();
        List rawParentFks = this.db_.getFkUtil().getFksForTable(this.table_, 0);
        for (ForeignKey fk : rawParentFks) {
            String childTblDotNote = fk.getChdTbl().getDotNote();
            if (!diagramTblDotNotes.contains(childTblDotNote)) continue;
            this.childFks_.add(fk);
            this.chdTblDotNotes_.add(childTblDotNote);
            this.linkColumnsNms_.add(fk.getParentLinkColNm());
        }
        this.childFkCount_ = this.childFks_.size();
        this.parentFkCount_ = this.parentFks_.size();
        this.totalFkCount_ = this.childFkCount_ + this.parentFkCount_;
    }

    private void calcTableType() {
        this.tableType_ = this.totalFkCount_ == 0 ? 0 : (this.totalFkCount_ == 1 ? 1 : 4);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds_;
    }

    @Override
    public void setOrigin(Point origin) {
        this.bounds_.setLocation(origin);
    }

    @Override
    public Point getOrigin() {
        return this.bounds_.getLocation();
    }
}

