/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.dbwrench.diagram.autoLayout.BranchBldr;
import com.harrand.dbwrench.diagram.autoLayout.TableBranch;
import com.harrand.dbwrench.diagram.autoLayout.TableFkInfo;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableCluster
implements INamed,
Comparable {
    private Map tableFkInfosMap_;
    private TableFkInfo rootTableFkInfo_;
    private TableBranch rootBranch_ = null;
    private BranchBldr branchBldr_ = new BranchBldr();
    private Point origin_ = new Point(0, 0);

    public TableCluster(List tableFkInfos, boolean fkNmsShownFlag) {
        this.setFkNmsShownFlag(fkNmsShownFlag);
        this.buildInfosMap(tableFkInfos);
        this.findRootTable();
        this.rootBranch_ = this.branchBldr_.getRootBranch(this);
    }

    public void setFkNmsShownFlag(boolean fkNmsShownFlag) {
        this.branchBldr_.setFkNmsShownFlag(fkNmsShownFlag);
    }

    public TableFkInfo getRootTableFkInfo() {
        return this.rootTableFkInfo_;
    }

    public TableBranch getRootBranch() {
        return this.rootBranch_;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!(obj instanceof TableCluster)) {
            return 0;
        }
        TableCluster other = (TableCluster)obj;
        Integer thisTableCount = new Integer(this.getTableCount());
        Integer otherTableCount = new Integer(other.getTableCount());
        int rawCompare = thisTableCount.compareTo(otherTableCount);
        return -1 * rawCompare;
    }

    public TableFkInfo getTableFkInfo(String name) {
        return (TableFkInfo)this.tableFkInfosMap_.get(name);
    }

    public int getTableCount() {
        return this.tableFkInfosMap_.size();
    }

    public Map<Table, Point> getTablePositionsAbsolute(Point clusterOrigin) {
        this.setOrigin(clusterOrigin);
        this.rootBranch_.refreshSubInfoOrigins();
        Map<Table, Point> relativeOrigins = this.rootBranch_.getTablePositions();
        Map<Table, Point> absOrigins = this.translateToAbsolute(relativeOrigins);
        return absOrigins;
    }

    private Map<Table, Point> translateToAbsolute(Map<Table, Point> relativeOrigins) {
        Dimension compensates = this.getNegativeCompensate();
        HashMap<Table, Point> absOrigins = new HashMap<Table, Point>();
        for (Table table : relativeOrigins.keySet()) {
            Point itemOrigin = relativeOrigins.get(table);
            Point absOrigin = MathUtil.translate(itemOrigin, this.origin_.x + compensates.width, this.origin_.y + compensates.height);
            absOrigins.put(table, absOrigin);
        }
        return absOrigins;
    }

    private Dimension getNegativeCompensate() {
        int minX = this.getBounds().x;
        int xComp = 0;
        if (minX < 0) {
            xComp = Math.abs(minX);
        }
        return new Dimension(xComp, 0);
    }

    private void buildInfosMap(List tableFkInfos) {
        this.tableFkInfosMap_ = new HashMap();
        for (TableFkInfo info : tableFkInfos) {
            this.tableFkInfosMap_.put(info.getName(), info);
        }
    }

    private void findRootTable() {
        int maxLinkCount = 0;
        int maxParentCount = 0;
        TableFkInfo tempRoot = null;
        for (TableFkInfo tableFkInfo : this.tableFkInfosMap_.values()) {
            int relationCount = tableFkInfo.getRelations().size();
            int parentCount = tableFkInfo.getChdTblDotNotes().size();
            if (relationCount > maxLinkCount) {
                maxLinkCount = relationCount;
                maxParentCount = parentCount;
                tempRoot = tableFkInfo;
            }
            if (relationCount != maxLinkCount || parentCount <= maxParentCount) continue;
            tempRoot = tableFkInfo;
            maxParentCount = parentCount;
        }
        this.rootTableFkInfo_ = tempRoot;
    }

    @Override
    public String getName() {
        return this.rootTableFkInfo_.getName();
    }

    public String toString() {
        return this.getName();
    }

    public List getTableNms() {
        return new ArrayList(this.tableFkInfosMap_.keySet());
    }

    @Override
    public void setName(String name) {
        LogUtil.logErr("TableCluster.setName() not supported");
    }

    public Rectangle getBounds() {
        return this.rootBranch_.getBounds();
    }

    public Point getOrigin() {
        return this.origin_;
    }

    public void setOrigin(Point origin) {
        this.origin_ = origin;
    }
}

