/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.coreclasses.element.ILayoutItem;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.dbwrench.diagram.autoLayout.BranchSorter;
import com.harrand.dbwrench.diagram.autoLayout.CursorCtrl;
import com.harrand.dbwrench.diagram.autoLayout.StaggerCtrl;
import com.harrand.dbwrench.diagram.autoLayout.TableFkInfo;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import com.harrand.util.MathUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableBranch
implements INamed,
ILayoutItem {
    private TableFkInfo tableFkInfo_;
    private Rectangle bounds_ = new Rectangle();
    private BranchSorter sorter_ = new BranchSorter();
    private StaggerCtrl staggerCtrl_ = new StaggerCtrl();
    private String srcTblDotNote_;
    private String srcColumnNm_;
    private Map subBranchesMap_ = new HashMap();
    private Map leavesMap_ = new HashMap();
    private List conflictedTblNms_ = new ArrayList();
    private List sortedSubInfos_;
    private int depth_;
    public static final String EAST_STR = "East";
    public static final String WEST_STR = "West";

    public TableBranch(TableFkInfo tableFkInfo, String srcTblDotNote, String srcColumnNm, int depth) {
        this.tableFkInfo_ = tableFkInfo;
        this.srcTblDotNote_ = srcTblDotNote;
        this.srcColumnNm_ = srcColumnNm;
        this.depth_ = depth;
        this.bounds_ = this.tableFkInfo_.getBounds();
    }

    public void setFkNmsShownFlag(boolean fkNmsShownFlag) {
        this.staggerCtrl_.setFkNmsShownFlag(fkNmsShownFlag);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableBranch)) {
            return false;
        }
        TableBranch other = (TableBranch)o;
        return other.getName().equals(this.getName());
    }

    @Override
    public String getDirection() {
        return this.tableFkInfo_.getDirection();
    }

    @Override
    public void setDirection(String direction) {
        this.tableFkInfo_.setDirection(direction);
    }

    public boolean isRootTable() {
        return this.getSrcColumnNm() == null;
    }

    public Map<Table, Point> getTablePositions() {
        HashMap<Table, Point> positionsMap = new HashMap<Table, Point>();
        positionsMap.put(this.tableFkInfo_.getTable(), this.tableFkInfo_.getOrigin());
        for (TableFkInfo aTableFkInfo : this.sortedSubInfos_) {
            Point origin = aTableFkInfo.getOrigin();
            positionsMap.put(aTableFkInfo.getTable(), origin);
            TableBranch subBranch = this.getSubBranch(aTableFkInfo.getName());
            if (subBranch == null) continue;
            positionsMap.putAll(subBranch.getTablePositions());
        }
        return positionsMap;
    }

    public void refreshSubInfoOrigins() {
        this.sortedSubInfos_ = this.sorter_.sortSubInfos(this);
        Map staggerMap = this.staggerCtrl_.getStaggerAmounts(this, this.sortedSubInfos_);
        Rectangle bounds = this.tableFkInfo_.getBounds();
        boolean isParentRoot = this.isRootTable();
        int branchY = this.tableFkInfo_.getOrigin().y;
        CursorCtrl cursorCtrl = new CursorCtrl();
        for (TableFkInfo subInfo : this.sortedSubInfos_) {
            String subNm = subInfo.getName();
            Integer staggerObj = (Integer)staggerMap.get(subNm);
            int staggerValue = staggerObj;
            TableBranch subBranch = this.getSubBranch(subNm);
            ILayoutItem subItem = subInfo;
            int yCursor = cursorCtrl.getCursorPos(subItem.getDirection(), isParentRoot);
            int subInfoX = this.getSubInfoX(subInfo, this.tableFkInfo_, staggerValue);
            Point subOrigin = new Point(subInfoX, branchY + yCursor);
            subItem.setOrigin(subOrigin);
            if (subBranch != null) {
                subItem = subBranch;
                subBranch.refreshSubInfoOrigins();
            }
            Rectangle subBounds = subItem.getBounds();
            bounds = MathUtil.getMixMaxRect(bounds, subBounds);
            cursorCtrl.incrementLastCursor(subItem);
        }
        this.bounds_ = bounds;
    }

    private int getSubInfoX(TableFkInfo subInfo, TableFkInfo parentInfo, int staggerValue) {
        int parentX = parentInfo.getOrigin().x;
        int parentWidth = parentInfo.getBounds().width;
        int horzTblGap = this.staggerCtrl_.getHorzTblGap(this);
        int miscLengths = staggerValue + horzTblGap;
        int subX = parentX + parentWidth + miscLengths;
        if (!subInfo.isEastDirection()) {
            int subWidth = subInfo.getBounds().width;
            subX = parentX - miscLengths - subWidth;
        }
        return subX;
    }

    @Override
    public String getName() {
        return this.tableFkInfo_.getName();
    }

    public TableFkInfo getTableFkInfo() {
        return this.tableFkInfo_;
    }

    public int getDepth() {
        return this.depth_;
    }

    public String getSrcTblDotNote() {
        return this.srcTblDotNote_;
    }

    public String getSrcColumnNm() {
        return this.srcColumnNm_;
    }

    public List getConflictedTblNms() {
        return this.conflictedTblNms_;
    }

    @Override
    public void setName(String name) {
        LogUtil.logErr("TableFkInfo.setName() not supported");
    }

    public List getLeaves() {
        return new ArrayList(this.leavesMap_.values());
    }

    public TableFkInfo getLeaf(String name) {
        return (TableFkInfo)this.leavesMap_.get(name);
    }

    public List getSubBranches() {
        return new ArrayList(this.subBranchesMap_.values());
    }

    public TableBranch getSubBranch(String name) {
        return (TableBranch)this.subBranchesMap_.get(name);
    }

    public void addLeaf(TableFkInfo leaf) {
        this.leavesMap_.put(leaf.getName(), leaf);
    }

    public void addSubBranch(TableBranch branch) {
        this.subBranchesMap_.put(branch.getName(), branch);
    }

    public void addConflictedTblNms(List conflictedTblNms) {
        this.conflictedTblNms_.addAll(conflictedTblNms);
        if (this.getSrcTblDotNote() != null) {
            this.conflictedTblNms_.remove(this.getSrcTblDotNote());
        }
    }

    public List getSubBranchNms() {
        ArrayList<String> nms = new ArrayList<String>();
        for (TableBranch subBranch : this.getSubBranches()) {
            nms.add(subBranch.getName());
            nms.addAll(subBranch.getSubBranchNms());
        }
        return nms;
    }

    public List getSubBranchConflictNms() {
        ArrayList subConflictNms = new ArrayList();
        for (TableBranch subBranch : this.getSubBranches()) {
            subConflictNms.addAll(subBranch.getConflictedTblNms());
            subConflictNms.addAll(subBranch.getSubBranchConflictNms());
        }
        return subConflictNms;
    }

    private List getBoundeds() {
        ArrayList boundeds = new ArrayList(this.getLeaves());
        boundeds.addAll(this.getSubBranches());
        return boundeds;
    }

    public String getSubsSrcColumnNm(String connectedTableNm) {
        return this.tableFkInfo_.getSrcColumnNm(connectedTableNm);
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        String newPrefix = prefix + this.getName();
        String brPrefix = newPrefix + "(BR)";
        StringBuffer sb = new StringBuffer();
        if (this.getLeaves().isEmpty() && this.getSubBranches().isEmpty()) {
            sb.append(newPrefix + "\n");
        }
        for (TableFkInfo leaf : this.getLeaves()) {
            sb.append(newPrefix + "(LF)" + leaf.getName() + "\n");
        }
        for (TableBranch subBranch : this.getSubBranches()) {
            String subStr = subBranch.toString(brPrefix);
            sb.append(subStr);
        }
        return sb.toString();
    }

    public void setBounds(Rectangle bounds) {
        this.bounds_ = bounds;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds_;
    }

    @Override
    public Point getOrigin() {
        return this.tableFkInfo_.getOrigin();
    }

    @Override
    public void setOrigin(Point origin) {
        this.tableFkInfo_.setOrigin(origin);
    }
}

