/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.dbwrench.diagram.autoLayout.TableBranch;
import com.harrand.dbwrench.diagram.autoLayout.TableFkInfo;
import com.harrand.dbwrench.object.ForeignKey;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaggerCtrl {
    public boolean fkNmsShownFlag = false;
    public static final int PARALLEL_LINE_GAP = 10;
    public static final int MIN_HORZ_TBL_GAP_NO_FK_NMS = 60;
    public static final int MIN_HORZ_TBL_GAP_WITH_FK_NMS = 120;

    public void setFkNmsShownFlag(boolean fkNmsShownFlag) {
        this.fkNmsShownFlag = fkNmsShownFlag;
    }

    public Map getStaggerAmounts(TableBranch branch, List sortedInfos) {
        HashMap<String, Integer> staggerMap = new HashMap<String, Integer>();
        String branchTblNm = branch.getName();
        String lastSrcColumnNm = "";
        int staggerCount = 0;
        for (int i = sortedInfos.size() - 1; i >= 0; --i) {
            TableFkInfo info = (TableFkInfo)sortedInfos.get(i);
            String tableNm = info.getName();
            String currentSrcColumnNm = "";
            TableBranch subBranch = branch.getSubBranch(tableNm);
            if (subBranch != null) {
                currentSrcColumnNm = subBranch.getSrcColumnNm();
            } else {
                ForeignKey fk;
                if (info.getParTblDotNotes().contains(branchTblNm)) {
                    fk = (ForeignKey)info.getParentFks().get(0);
                    currentSrcColumnNm = fk.getParentLinkColNm();
                }
                if (info.getChdTblDotNotes().contains(branchTblNm)) {
                    fk = (ForeignKey)info.getChildFks().get(0);
                    currentSrcColumnNm = fk.getChildLinkColNm();
                }
            }
            staggerCount = lastSrcColumnNm.equals(currentSrcColumnNm) ? ++staggerCount : 0;
            lastSrcColumnNm = currentSrcColumnNm;
            staggerMap.put(tableNm, new Integer(staggerCount * 10));
        }
        return staggerMap;
    }

    public int getHorzTblGap(TableBranch branch) {
        int gap = this.getMinHorzTblGap();
        TableFkInfo tableFkInfo = branch.getTableFkInfo();
        int gapsNeeded = tableFkInfo.getParentFks().size() - 1;
        Dimension jointSz = tableFkInfo.getDiagram().getRenderConfig().getJointSize();
        int jointLength = jointSz.width;
        int calcGap = 2 * jointLength + gapsNeeded * 10;
        if (calcGap > gap) {
            gap = calcGap;
        }
        return gap;
    }

    private int getMinHorzTblGap() {
        if (this.fkNmsShownFlag) {
            return 120;
        }
        return 60;
    }
}

