/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.dbwrench.diagram.autoLayout.LonerSorter;
import com.harrand.dbwrench.diagram.autoLayout.TableCluster;
import com.harrand.dbwrench.diagram.autoLayout.TableFkInfo;
import com.harrand.dbwrench.diagram.table.ITableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.layout.ILayoutCtrl;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbLayoutCtrl
implements ILayoutCtrl {
    private Database db_;
    private Diagram diagram_;
    private List tables_;
    private List tableDotNotes_;
    private List tableFkInfos_;
    private List lonerInfos_ = new ArrayList();
    private Map linkedInfosMap_ = new HashMap();
    private List clusters_ = new ArrayList();
    private List searchableTblNms_ = new ArrayList();
    public static final int CLUSTER_LONER_GAP = 90;
    public static final int CLUSTER_GAP = 40;
    private List<Glyph> glyphs;

    public DbLayoutCtrl(Database db) {
        this.db_ = db;
    }

    public List getClusters() {
        return new ArrayList(this.clusters_);
    }

    public List getLonerTableFkInfos() {
        return new ArrayList(this.lonerInfos_);
    }

    private void setGlyphs(List<Glyph> glyphs) {
        this.glyphs = glyphs;
        this.buildTables(glyphs);
        this.buildTableFkInfos();
        this.buildClusters();
    }

    @Override
    public Map<Table, Point> getTablePositions(Diagram diagram, List glyphs, Point origin) {
        this.diagram_ = diagram;
        this.setGlyphs(glyphs);
        HashMap<Table, Point> positionsMap = new HashMap<Table, Point>();
        Point unzoomedOrigin = Zoomer.unZoom(origin, this.diagram_.getZoom().getLevel());
        int cursorY = unzoomedOrigin.y;
        int maxWidth = 0;
        for (TableCluster cluster : this.getClusters()) {
            cluster.setOrigin(new Point(unzoomedOrigin.x, cursorY));
            positionsMap.putAll(cluster.getTablePositionsAbsolute(new Point(unzoomedOrigin.x, cursorY)));
            maxWidth = Math.max(maxWidth, cluster.getBounds().width);
            cursorY += cluster.getBounds().height + 40;
        }
        int lonerX = !this.getClusters().isEmpty() ? unzoomedOrigin.x + maxWidth + 90 : unzoomedOrigin.x;
        Point lonerOrigin = new Point(lonerX, unzoomedOrigin.y);
        LonerSorter lonerSorter = new LonerSorter();
        Map<Table, Point> lonerPositions = lonerSorter.getTablePositionsBox(this.lonerInfos_, lonerOrigin);
        positionsMap.putAll(lonerPositions);
        return positionsMap;
    }

    private void buildTables(List glyphs) {
        this.tables_ = new ArrayList();
        this.tableDotNotes_ = new ArrayList();
        for (Object glyphObject : glyphs) {
            if (!(glyphObject instanceof ITableGlyph)) continue;
            ITableGlyph tableGlyph = (ITableGlyph)glyphObject;
            Table table = tableGlyph.getTable();
            this.tables_.add(table);
            this.tableDotNotes_.add(table.getDotNote());
        }
    }

    @Override
    public ITestResult checkTooManyGlyphs(int glyphCount) {
        DataEntryResult result = new DataEntryResult(true);
        return result;
    }

    private void buildTableFkInfos() {
        this.tableFkInfos_ = new ArrayList();
        this.lonerInfos_ = new ArrayList();
        this.linkedInfosMap_ = new HashMap();
        for (Glyph glyph : this.glyphs) {
            if (!(glyph instanceof ITableGlyph)) continue;
            Table table = ((ITableGlyph)((Object)glyph)).getTable();
            Rectangle2D bounds = glyph.getBounds2D();
            Dimension glyphSz = new Dimension((int)bounds.getWidth(), (int)bounds.getHeight());
            TableFkInfo tableFkInfo = new TableFkInfo(this.db_, this.diagram_, glyphSz, this.tableDotNotes_, table);
            this.tableFkInfos_.add(tableFkInfo);
            if (tableFkInfo.isLoner()) {
                this.lonerInfos_.add(tableFkInfo);
                continue;
            }
            this.linkedInfosMap_.put(tableFkInfo.getName(), tableFkInfo);
        }
    }

    private void buildClusters() {
        this.clusters_ = new ArrayList();
        this.searchableTblNms_ = new ArrayList(this.linkedInfosMap_.keySet());
        while (this.searchableTblNms_.size() > 0) {
            String startNm = (String)this.searchableTblNms_.get(0);
            List clusteredInfos = this.getClusteredFkInfos(startNm, true);
            TableCluster cluster = new TableCluster(clusteredInfos, this.getShowFkNames());
            this.clusters_.add(cluster);
        }
        Collections.sort(this.clusters_);
    }

    private List getClusteredFkInfos(String startNm, boolean addStartInfo) {
        TableFkInfo tableFkInfo = (TableFkInfo)this.linkedInfosMap_.get(startNm);
        List childTblNms = tableFkInfo.getChdTblDotNotes();
        childTblNms.retainAll(this.searchableTblNms_);
        List parentTblNms = tableFkInfo.getParTblDotNotes();
        parentTblNms.retainAll(this.searchableTblNms_);
        ArrayList connectedTblNms = new ArrayList(childTblNms);
        connectedTblNms.addAll(parentTblNms);
        this.searchableTblNms_.removeAll(connectedTblNms);
        this.searchableTblNms_.remove(startNm);
        ArrayList connectedInfos = new ArrayList();
        if (addStartInfo) {
            connectedInfos.add(this.linkedInfosMap_.get(startNm));
        }
        for (String tableNm : connectedTblNms) {
            connectedInfos.add(this.linkedInfosMap_.get(tableNm));
            List recursiveFoundNms = this.getClusteredFkInfos(tableNm, false);
            connectedInfos.addAll(recursiveFoundNms);
        }
        return connectedInfos;
    }

    private boolean getShowFkNames() {
        boolean showFkNames = this.diagram_.getDiagramProps().getShowFkNames();
        return showFkNames;
    }
}

