/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.coreclasses.element.ILayoutItem;
import com.harrand.dbwrench.diagram.autoLayout.LayoutCursor;
import com.harrand.dbwrench.diagram.autoLayout.TableBranch;
import java.util.HashMap;
import java.util.Map;

public class CursorCtrl {
    private Map<String, LayoutCursor> cursors = new HashMap<String, LayoutCursor>();
    private LayoutCursor lastCursor_ = null;
    private static final String CENTER_CURSOR_NM = "CenterCursor";
    private static final String WEST_CURSOR_NM = "WestCursor";
    private static final String EAST_CURSOR_NM = "EastCursor";
    public static final int LEAF_VERT_GAP = 15;
    public static final int BRANCH_VERT_GAP = 30;
    public static final String EAST_STR = "East";
    public static final String WEST_STR = "West";

    public CursorCtrl() {
        this.createCursor(CENTER_CURSOR_NM);
        this.createCursor(WEST_CURSOR_NM);
        this.createCursor(EAST_CURSOR_NM);
        this.lastCursor_ = this.cursors.get(CENTER_CURSOR_NM);
    }

    public void reset() {
        for (LayoutCursor cursor : this.cursors.values()) {
            cursor.reset();
        }
    }

    public int getCursorPos(String xDirection, boolean isParentRoot) {
        LayoutCursor cursor = this.selectCursor(xDirection, isParentRoot);
        int currentPos = cursor.getPosition();
        this.lastCursor_ = cursor;
        return currentPos;
    }

    public void incrementLastCursor(ILayoutItem bounded) {
        int vGap = bounded instanceof TableBranch ? 30 : 15;
        this.lastCursor_.increment(bounded.getBounds().height + vGap);
    }

    private void createCursor(String nm) {
        this.cursors.put(nm, new LayoutCursor(nm));
    }

    private LayoutCursor selectCursor(String xDirection, boolean isParentRoot) {
        String cursorNm = CENTER_CURSOR_NM;
        if (isParentRoot) {
            boolean isEast = xDirection.equals(EAST_STR);
            cursorNm = isEast ? EAST_CURSOR_NM : WEST_CURSOR_NM;
        }
        LayoutCursor cursor = this.cursors.get(cursorNm);
        return cursor;
    }
}

