/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.coreclasses.element.ILayoutItem;
import com.harrand.dbwrench.diagram.autoLayout.AffinityStrength;
import com.harrand.dbwrench.diagram.autoLayout.BranchAffinity;
import com.harrand.dbwrench.diagram.autoLayout.DirectionCtrl;
import com.harrand.dbwrench.diagram.autoLayout.TableBranch;
import com.harrand.dbwrench.diagram.autoLayout.TableFkInfo;
import com.harrand.dbwrench.object.ForeignKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BranchSorter {
    private Map affinitiesMap_;
    private DirectionCtrl directionCtrl_ = new DirectionCtrl();

    public List sortSubInfos(TableBranch branch) {
        String branchTblNm = branch.getTableFkInfo().getName();
        if (branch.isRootTable()) {
            this.directionCtrl_.reset();
        }
        ArrayList orderedInfos = new ArrayList();
        List sortedLinkColNms = branch.getTableFkInfo().getSortedLinkColumnNms();
        for (String linkColNm : sortedLinkColNms) {
            ArrayList<TableBranch> columnSubBranches = new ArrayList<TableBranch>();
            for (TableBranch subBranch : branch.getSubBranches()) {
                if (subBranch.getSrcColumnNm().equals(linkColNm)) {
                    columnSubBranches.add(subBranch);
                }
                this.setDirection(branch, subBranch);
            }
            List sortedBranchInfos = this.getSortedBranchesDisp(branch, columnSubBranches);
            orderedInfos.addAll(sortedBranchInfos);
            ArrayList<TableFkInfo> columnLeaves = new ArrayList<TableFkInfo>();
            for (TableFkInfo leaf : branch.getLeaves()) {
                ForeignKey fk;
                if (leaf.getParTblDotNotes().contains(branchTblNm) && (fk = (ForeignKey)leaf.getParentFks().get(0)).getParentLinkColNm().equals(linkColNm)) {
                    columnLeaves.add(leaf);
                }
                if (leaf.getChdTblDotNotes().contains(branchTblNm) && (fk = (ForeignKey)leaf.getChildFks().get(0)).getChildLinkColNm().equals(linkColNm)) {
                    columnLeaves.add(leaf);
                }
                this.setDirection(branch, leaf);
            }
            Collections.sort(columnLeaves);
            orderedInfos.addAll(columnLeaves);
        }
        return orderedInfos;
    }

    private List getSortedBranchesDisp(TableBranch srcBranch, List moveableBranches) {
        List sortedBranches = moveableBranches.size() == 0 ? new ArrayList() : (moveableBranches.size() == 1 ? new ArrayList(moveableBranches) : (moveableBranches.size() == 2 ? new ArrayList(moveableBranches) : this.sortManyBranches(srcBranch, moveableBranches)));
        return this.getInfosFromBranches(sortedBranches);
    }

    private List getInfosFromBranches(List branches) {
        ArrayList<TableFkInfo> sortedInfos = new ArrayList<TableFkInfo>();
        for (TableBranch branch : branches) {
            sortedInfos.add(branch.getTableFkInfo());
        }
        return sortedInfos;
    }

    public List sortManyBranches(TableBranch srcBranch, List movableBranches) {
        this.buildAffinities(movableBranches);
        ArrayList affinities = new ArrayList(this.affinitiesMap_.values());
        Collections.sort(affinities);
        ArrayList branchNms = new ArrayList(this.affinitiesMap_.keySet());
        ArrayList<TableBranch> sortedBranches = new ArrayList<TableBranch>();
        BranchAffinity affinity = (BranchAffinity)affinities.get(affinities.size() - 1);
        String seedBranchNm = affinity.getName();
        sortedBranches.add(srcBranch.getSubBranch(seedBranchNm));
        branchNms.remove(seedBranchNm);
        while (!branchNms.isEmpty()) {
            String newName;
            TableBranch firstSortedBranch = (TableBranch)sortedBranches.get(0);
            BranchAffinity firstAffinity = (BranchAffinity)this.affinitiesMap_.get(firstSortedBranch.getName());
            TableBranch lastSortedBranch = (TableBranch)sortedBranches.get(sortedBranches.size() - 1);
            BranchAffinity lastAffinity = (BranchAffinity)this.affinitiesMap_.get(lastSortedBranch.getName());
            AffinityStrength firstStrength = firstAffinity.getNeighborStrength(branchNms);
            AffinityStrength lastStrength = lastAffinity.getNeighborStrength(branchNms);
            if (lastStrength.getStrength() >= firstStrength.getStrength()) {
                newName = lastStrength.getBranchNmB();
                sortedBranches.add(srcBranch.getSubBranch(newName));
            } else {
                newName = firstStrength.getBranchNmB();
                sortedBranches.add(0, srcBranch.getSubBranch(newName));
            }
            branchNms.remove(newName);
        }
        return sortedBranches;
    }

    private void buildAffinities(List movableBranches) {
        this.affinitiesMap_ = new HashMap();
        for (TableBranch branch : movableBranches) {
            BranchAffinity affinity = new BranchAffinity(branch, movableBranches);
            this.affinitiesMap_.put(affinity.getName(), affinity);
        }
    }

    private void setDirection(TableBranch branch, ILayoutItem subItem) {
        String dir = this.directionCtrl_.calcItemDirection(branch);
        subItem.setDirection(dir);
    }
}

