/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.dbwrench.diagram.DataGenSketch;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.autoLayout.DbLayoutCtrl;
import com.harrand.dbwrench.diagram.autoLayout.TableCluster;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AutoLayoutData {
    public static final String DB_NM = "AutoLayoutDb";
    public static final String DIAGRAM_NM = "Zoo";
    public static final String FISH_TBL_NM = "Fish";
    public static final String WHALE_TBL_NM = "Whale";
    public static final String ZOO_TBL_NM = "Zoo";
    public static final String KEEPER_TBL_NM = "Keeper";
    public static final String RODENT_TBL_NM = "Rodent";
    public static final String QUAD_TBL_NM = "Quad";
    public static final String CAT_TBL_NM = "Cat";
    public static final String CARNIVORE_TBL_NM = "Carnivore";
    public static final String DOLPHIN_TBL_NM = "Dolphin";
    public static final String RAT_TBL_NM = "Rat";
    public static final String MOUSE_TBL_NM = "Mouse";
    public static final String SHREW_TBL_NM = "Shrew";
    public static final String WHEEL_TBL_NM = "Wheel";
    public static final String RABBIT_TBL_NM = "Rabbit";
    public static final String MEAT_TBL_NM = "Meat";
    public static final String PROTEIN_TBL_NM = "Protein";
    public static final String AMINO_TBL_NM = "Amino";
    public static final String POOL_TBL_NM = "Pool";
    public static final String SHOW_TBL_NM = "Show";
    public static final String TRAINER_TBL_NM = "Trainer";
    public static final String POD_TBL_NM = "Pod";

    public static TableCluster getCluster() {
        Database db = AutoLayoutData.getDb();
        Diagram diagram = DataGenSketch.getEmptyDiagram(db, "Zoo");
        Schema sch = db.getSchema("schemaA");
        ArrayList tables = new ArrayList(sch.values(Table.getClassName()));
        DbLayoutCtrl ctrl = new DbLayoutCtrl(db);
        List glyphs = AutoLayoutData.getTableGlyphsAll(db);
        Map<Table, Point> positionsMap = ctrl.getTablePositions(diagram, glyphs, new Point(0, 0));
        List clusters = ctrl.getClusters();
        TableCluster cluster = (TableCluster)clusters.get(0);
        return cluster;
    }

    public static Database getDb() {
        Database db = new Database(DB_NM);
        AutoLayoutData.addTables(db);
        AutoLayoutData.addFksDisp(db);
        Diagram diagram = DataGenSketch.getEmptyDiagram(db, "Zoo");
        db.add(diagram);
        return db;
    }

    public static List getTableGlyphsAll(Database db) {
        ArrayList<DbTableGlyph> tableGlyphs = new ArrayList<DbTableGlyph>();
        Diagram diagram = db.getDiagram("Zoo");
        Schema sch = db.getSchema("schemaA");
        for (Table table : sch.values(Table.getClassName())) {
            DbTableGlyph glyph = new DbTableGlyph(new Point(0, 0), table, diagram);
            tableGlyphs.add(glyph);
        }
        return tableGlyphs;
    }

    private static void addTables(Database db) {
        try {
            Schema sch = db.getSchema("schemaA");
            sch.add(AutoLayoutData.createTable(FISH_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(WHALE_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable("Zoo", 4));
            sch.add(AutoLayoutData.createTable(KEEPER_TBL_NM, 6));
            sch.add(AutoLayoutData.createTable(RODENT_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(QUAD_TBL_NM, 7));
            sch.add(AutoLayoutData.createTable(CAT_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(CARNIVORE_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(DOLPHIN_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(RAT_TBL_NM, 1));
            sch.add(AutoLayoutData.createTable(MOUSE_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(SHREW_TBL_NM, 1));
            sch.add(AutoLayoutData.createTable(WHEEL_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(RABBIT_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(MEAT_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(PROTEIN_TBL_NM, 7));
            sch.add(AutoLayoutData.createTable(AMINO_TBL_NM, 4));
            sch.add(AutoLayoutData.createTable(POOL_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(SHOW_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(TRAINER_TBL_NM, 3));
            sch.add(AutoLayoutData.createTable(POD_TBL_NM, 3));
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private static void addFksDisp(Database db) {
        try {
            AutoLayoutData.addFk(db, "Zoo", KEEPER_TBL_NM);
            AutoLayoutData.addFk(db, KEEPER_TBL_NM, FISH_TBL_NM);
            AutoLayoutData.addFk(db, KEEPER_TBL_NM, WHALE_TBL_NM);
            AutoLayoutData.addFk(db, KEEPER_TBL_NM, RODENT_TBL_NM);
            AutoLayoutData.addFk(db, KEEPER_TBL_NM, QUAD_TBL_NM);
            AutoLayoutData.addFk(db, KEEPER_TBL_NM, CAT_TBL_NM);
            AutoLayoutData.addFk(db, KEEPER_TBL_NM, CARNIVORE_TBL_NM);
            AutoLayoutData.addFk(db, KEEPER_TBL_NM, DOLPHIN_TBL_NM);
            AutoLayoutData.addFk(db, RODENT_TBL_NM, RAT_TBL_NM);
            AutoLayoutData.addFk(db, RODENT_TBL_NM, MOUSE_TBL_NM);
            AutoLayoutData.addFk(db, MOUSE_TBL_NM, SHREW_TBL_NM);
            AutoLayoutData.addFk(db, WHEEL_TBL_NM, MOUSE_TBL_NM);
            AutoLayoutData.addFk(db, WHEEL_TBL_NM, RABBIT_TBL_NM);
            AutoLayoutData.addFk(db, QUAD_TBL_NM, RODENT_TBL_NM);
            AutoLayoutData.addFk(db, QUAD_TBL_NM, RABBIT_TBL_NM);
            AutoLayoutData.addFk(db, QUAD_TBL_NM, CAT_TBL_NM);
            AutoLayoutData.addFk(db, CARNIVORE_TBL_NM, CAT_TBL_NM);
            AutoLayoutData.addFk(db, CARNIVORE_TBL_NM, MEAT_TBL_NM);
            AutoLayoutData.addFk(db, MEAT_TBL_NM, PROTEIN_TBL_NM);
            AutoLayoutData.addFk(db, PROTEIN_TBL_NM, AMINO_TBL_NM);
            AutoLayoutData.addFk(db, POOL_TBL_NM, DOLPHIN_TBL_NM);
            AutoLayoutData.addFk(db, SHOW_TBL_NM, DOLPHIN_TBL_NM);
            AutoLayoutData.addFk(db, TRAINER_TBL_NM, DOLPHIN_TBL_NM);
            AutoLayoutData.addFk(db, POD_TBL_NM, DOLPHIN_TBL_NM);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private static void addFk(Database db, String parTblNm, String chdTblNm) throws Exception {
        Schema schDef = db.getSchema("schemaA");
        String colNm = parTblNm + "Id";
        Column chdCol = new Column(colNm, 4, null, true);
        Table chdTable = schDef.getTable(chdTblNm);
        Table parTable = schDef.getTable(parTblNm);
        chdTable.add(chdCol);
        ForeignKey fk = new ForeignKey("fk" + chdTblNm + parTblNm, parTable, chdTable, colNm, colNm);
        chdTable.add(fk);
    }

    private static Table createTable(String tblNm, int descColCount) throws Exception {
        Table tbl = new Table(tblNm);
        tbl.setUseManualSort(true);
        Column colId = new Column(tblNm + "Id", 4, null, true);
        tbl.add(colId);
        for (int i = 0; i < descColCount; ++i) {
            String colNm = "Desc" + Integer.toString(i);
            Column colDesc = new Column(colNm, 12, new Integer(i + 10), true);
            tbl.add(colDesc);
        }
        Column colChangeBy = new Column("ChangeBy", 12, new Integer(50), true);
        Column colChangeDate = new Column("ChangeDate", 700, null, true);
        tbl.add(colChangeBy);
        tbl.add(colChangeDate);
        ArrayList<String> pkCols = new ArrayList<String>();
        pkCols.add(colId.getName());
        PrimaryKey pk = new PrimaryKey("pk" + tblNm, pkCols);
        tbl.setPrimaryKey(pk);
        return tbl;
    }
}

