/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.sketch.linkStrategies.arc.ArcBldr;
import com.harrand.sketch.linkStrategies.line.LineDirectionCalc;
import com.harrand.util.MathUtil;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;

public class ArcCornerCtrl {
    private List<Shape> shapes_;
    private List<Arc2D> arcs_;
    private boolean isHorzLineLead_;
    private int minLength_ = 3;

    public ArcCornerCtrl() {
        this.reset();
    }

    private void reset() {
        this.shapes_ = new ArrayList<Shape>();
        this.arcs_ = new ArrayList<Arc2D>();
    }

    public List<Shape> addArcsToLinesBasic(Line2D horzLineA, Line2D vertLine, Line2D horzLineB) {
        this.reset();
        boolean trimVertStart = false;
        boolean trimVertEnd = false;
        this.isHorzLineLead_ = true;
        trimVertStart = this.getCornerArced(horzLineA, vertLine);
        this.isHorzLineLead_ = false;
        trimVertEnd = this.getCornerArced(horzLineB, vertLine);
        this.trimVertLineDisp(vertLine, trimVertStart, trimVertEnd);
        this.shapes_.addAll(this.arcs_);
        return this.shapes_;
    }

    public List<Shape> addArcsToLinesBent(Line2D horzLineA, Line2D vertLineA, Line2D horzLineB, Line2D vertLineB, Line2D horzLineC) {
        this.reset();
        this.isHorzLineLead_ = true;
        boolean trimVertAStart = this.getCornerArced(horzLineA, vertLineA);
        this.isHorzLineLead_ = false;
        boolean trimVertAEnd = this.getCornerArced(horzLineB, vertLineA);
        Line2D newHorzBStartTrimmed = (Line2D)this.shapes_.get(this.shapes_.size() - 1);
        this.shapes_.remove(this.shapes_.size() - 1);
        this.isHorzLineLead_ = true;
        boolean trimVertBStart = this.getCornerArced(horzLineB, vertLineB);
        Line2D newHorzBEndTrimmed = (Line2D)this.shapes_.get(this.shapes_.size() - 1);
        this.shapes_.remove(this.shapes_.size() - 1);
        Line2D.Double bothEndsTrimmed = new Line2D.Double(newHorzBStartTrimmed.getP1(), newHorzBEndTrimmed.getP2());
        this.shapes_.add(bothEndsTrimmed);
        this.isHorzLineLead_ = false;
        boolean trimVertBEnd = this.getCornerArced(horzLineC, vertLineB);
        this.trimVertLineDisp(vertLineA, trimVertAStart, trimVertAEnd);
        this.trimVertLineDisp(vertLineB, trimVertBStart, trimVertBEnd);
        this.shapes_.addAll(this.arcs_);
        return this.shapes_;
    }

    private boolean getCornerArced(Line2D horzLine, Line2D vertLine) {
        boolean trimStart;
        boolean arced = false;
        boolean isHorzLine = true;
        boolean trimEnd = this.isHorzLineLead_;
        boolean bl = trimStart = !trimEnd;
        if (this.getCanArcCorner(horzLine, vertLine)) {
            Line2D newHorz = this.trimLine(horzLine, isHorzLine, trimStart, trimEnd);
            arced = true;
            this.shapes_.add(newHorz);
            this.arcs_.add(new ArcBldr().getArc(horzLine, vertLine, this.isHorzLineLead_));
        } else {
            this.shapes_.add(horzLine);
        }
        return arced;
    }

    private void trimVertLineDisp(Line2D vertLine, boolean trimStart, boolean trimEnd) {
        boolean trimVert = trimStart || trimEnd;
        boolean isHorz = false;
        if (trimVert) {
            Line2D newVert = this.trimLine(vertLine, isHorz, trimStart, trimEnd);
            this.shapes_.add(1, newVert);
        } else {
            this.shapes_.add(vertLine);
        }
    }

    private boolean getCanArcCorner(Line2D horzLine, Line2D vertLine) {
        int horzLineLn = MathUtil.getHorzLineLength(horzLine);
        int vertLineLn = MathUtil.getVertLineLength(vertLine);
        boolean horzIsLongEnough = horzLineLn > this.minLength_;
        boolean vertIsLongEnough = vertLineLn > this.minLength_;
        boolean canArc = horzIsLongEnough && vertIsLongEnough;
        return canArc;
    }

    private Line2D trimLine(Line2D origLine, boolean isHorz, boolean trimStart, boolean trimEnd) {
        int x1 = (int)origLine.getX1();
        int x2 = (int)origLine.getX2();
        int y1 = (int)origLine.getY1();
        int y2 = (int)origLine.getY2();
        int r = 3;
        if (isHorz) {
            boolean isEastBound = LineDirectionCalc.isEastBound(origLine);
            if (isEastBound) {
                if (trimStart) {
                    x1 += r;
                }
                if (trimEnd) {
                    x2 -= r;
                }
            } else {
                if (trimStart) {
                    x1 -= r;
                }
                if (trimEnd) {
                    x2 += r;
                }
            }
        } else {
            boolean isSouthBound = LineDirectionCalc.isSouthBound(origLine);
            if (isSouthBound) {
                if (trimStart) {
                    y1 += r;
                }
                if (trimEnd) {
                    y2 -= r;
                }
            } else {
                if (trimStart) {
                    y1 -= r;
                }
                if (trimEnd) {
                    y2 += r;
                }
            }
        }
        Line2D.Double newLine = new Line2D.Double(x1, y1, x2, y2);
        return newLine;
    }

    private String lineToStr(Line2D line) {
        return StrHelper.getLineToStr(line);
    }
}

