/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.dbwrench.diagram.FkRightAngleLinkCtrl;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.autoLayout.ArcCornerCtrl;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RightAngleLinesCtrl {
    private ArcCornerCtrl arcCornerCtrl_ = new ArcCornerCtrl();
    private List selfJoins_ = new ArrayList();
    private List childExtendedLinks_ = new ArrayList();
    private List bentLinks_ = new ArrayList();
    private List nwLinks_ = new ArrayList();
    private List neLinks_ = new ArrayList();
    private List swLinks_ = new ArrayList();
    private List seLinks_ = new ArrayList();
    private int westCount_ = 0;
    private int eastCount_ = 0;
    private double jointLength_ = 0.0;
    private double jointHeight_ = 0.0;
    private double parallelGap_ = 0.0;
    private Table chdTbl_;
    public static final double BEND_BOX_GAP = 10.0;
    public static final int ARC_SPACE = 4;

    private void reset() {
        this.westCount_ = 0;
        this.eastCount_ = 0;
        this.selfJoins_.clear();
        this.childExtendedLinks_.clear();
        this.bentLinks_.clear();
        this.nwLinks_.clear();
        this.neLinks_.clear();
        this.swLinks_.clear();
        this.seLinks_.clear();
    }

    public void setJointLength(double jointLength) {
        this.jointLength_ = jointLength;
    }

    public void setJointHeight(double jointHeight) {
        this.jointHeight_ = jointHeight;
    }

    public void setParallelGap(double gap) {
        this.parallelGap_ = gap;
    }

    public Map getLinkLines(NamedList links, Map linkCtrls, Table chdTbl) {
        this.reset();
        this.chdTbl_ = chdTbl;
        List<ForeignKey> fks = this.chdTbl_.getFksInOrder();
        for (ForeignKey fk : fks) {
            String fkFqn = this.chdTbl_.getDotNote() + "." + fk.getName();
            INamed linkObj = links.get(fkFqn);
            if (linkObj == null) continue;
            ForeignKeyGlyph link = (ForeignKeyGlyph)linkObj;
            FkRightAngleLinkCtrl ctrl = (FkRightAngleLinkCtrl)linkCtrls.get(link.getName());
            this.addToDirectionMap(ctrl);
        }
        Collections.reverse(this.swLinks_);
        Collections.reverse(this.seLinks_);
        Map linkLines = this.getLinkLinesDisp(linkCtrls);
        return linkLines;
    }

    private void addToDirectionMap(FkRightAngleLinkCtrl ctrl) {
        String name = ctrl.getName();
        if (ctrl.getIsSelfJoin()) {
            this.selfJoins_.add(name);
            return;
        }
        if (ctrl.getIsChildExtended()) {
            this.childExtendedLinks_.add(name);
            return;
        }
        int edge = ctrl.getChildEdge();
        int direction = ctrl.getVertDirection();
        List quadrantList = null;
        if (edge == 3) {
            if (direction == 0) {
                quadrantList = this.nwLinks_;
            }
            if (direction == 2) {
                quadrantList = this.swLinks_;
            }
        } else {
            if (direction == 0) {
                quadrantList = this.neLinks_;
            }
            if (direction == 2) {
                quadrantList = this.seLinks_;
            }
        }
        if (ctrl.getIsBent()) {
            quadrantList.add(0, name);
        } else {
            quadrantList.add(name);
        }
    }

    private Map getLinkLinesDisp(Map linkCtrls) {
        HashMap linesMap = new HashMap();
        linesMap.putAll(this.getQuadrantLines(linkCtrls, this.nwLinks_, 3));
        linesMap.putAll(this.getQuadrantLines(linkCtrls, this.swLinks_, 3));
        linesMap.putAll(this.getQuadrantLines(linkCtrls, this.childExtendedLinks_, 3));
        linesMap.putAll(this.getQuadrantLines(linkCtrls, this.selfJoins_, 1));
        linesMap.putAll(this.getQuadrantLines(linkCtrls, this.neLinks_, 1));
        linesMap.putAll(this.getQuadrantLines(linkCtrls, this.seLinks_, 1));
        return linesMap;
    }

    private Map getQuadrantLines(Map ctrls, List quadrantList, int latEdge) {
        HashMap linesMap = new HashMap();
        int edgeCount = latEdge == 3 ? this.westCount_ : this.eastCount_;
        for (String fkName : quadrantList) {
            ArrayList lines = new ArrayList();
            FkRightAngleLinkCtrl ctrl = (FkRightAngleLinkCtrl)ctrls.get(fkName);
            int childSign = this.getSign(ctrl.getChildEdge());
            int parentSign = this.getSign(ctrl.getParentEdge());
            double childStartX = (double)ctrl.getChildX() + (double)childSign * this.jointLength_;
            double childStartY = ctrl.getChildY();
            double parentStartX = (double)ctrl.getParentX() + (double)parentSign * this.jointLength_;
            double parentStartY = ctrl.getParentY();
            double childEndX = childStartX + (double)(childSign * 4) + (double)childSign * this.parallelGap_ * (double)edgeCount;
            double childEndY = childStartY;
            if (this.isChildExtended(fkName)) {
                childEndX = Math.min(childEndX, parentStartX);
            }
            Line2D.Double childLine = new Line2D.Double(childStartX, childStartY, childEndX, childEndY);
            lines.addAll(this.getConnectingShapes(ctrl, childLine, parentStartX, parentStartY));
            linesMap.put(fkName, lines);
            ++edgeCount;
        }
        if (latEdge == 3) {
            this.westCount_ = edgeCount;
        } else {
            this.eastCount_ = edgeCount;
        }
        return linesMap;
    }

    private List getConnectingShapes(FkRightAngleLinkCtrl ctrl, Line2D childLine, double parentStartX, double parentStartY) {
        double childEndX = childLine.getX2();
        double childEndY = childLine.getY2();
        if (!ctrl.getIsBent()) {
            Line2D.Double vertLine = new Line2D.Double(childEndX, childEndY, childEndX, parentStartY);
            Line2D.Double parentLine = new Line2D.Double(childEndX, parentStartY, parentStartX, parentStartY);
            List<Shape> lines = this.arcCornerCtrl_.addArcsToLinesBasic(childLine, vertLine, parentLine);
            ctrl.setNamedLine(vertLine);
            return lines;
        }
        return this.getBentConnectingShapes(ctrl, childLine, parentStartX, parentStartY);
    }

    private List getBentConnectingShapes(FkRightAngleLinkCtrl ctrl, Line2D childHorz, double parentStartX, double parentStartY) {
        double childEndX = childHorz.getX2();
        double childEndY = childHorz.getY2();
        double horzLineY = ctrl.getVertDirection() == 0 ? ctrl.getParentBox().getMaxY() + 10.0 : ctrl.getParentBox().getMinY() - 10.0;
        int parentSign = this.getSign(ctrl.getParentEdge());
        double horzParentX = parentStartX + (double)(parentSign * 4);
        Line2D.Double childVert = new Line2D.Double(childEndX, childEndY, childEndX, horzLineY);
        Line2D.Double horz = new Line2D.Double(childEndX, horzLineY, horzParentX, horzLineY);
        Line2D.Double parentVert = new Line2D.Double(horzParentX, horzLineY, horzParentX, parentStartY);
        Line2D.Double parentHorz = new Line2D.Double(horzParentX, parentStartY, parentStartX, parentStartY);
        ctrl.setNamedLine(childVert);
        List<Shape> lines = this.arcCornerCtrl_.addArcsToLinesBent(childHorz, childVert, horz, parentVert, parentHorz);
        return lines;
    }

    private int getSign(int edge) {
        int sign = edge == 3 ? -1 : 1;
        return sign;
    }

    private boolean isChildExtended(String fkName) {
        return this.childExtendedLinks_.contains(fkName);
    }
}

