/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.table.ITableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.linkStrategies.linkNm.KeyToKeyNmPositionCalc;
import com.harrand.sketch.relation.glyph.JointGlyph;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class FkRightAngleLinkCtrl {
    private ForeignKey fk_;
    private ForeignKeyGlyph fkGlyph_;
    private Glyph parentGlyph_;
    private Glyph childGlyph_;
    private Rectangle2D childBox_;
    private Rectangle2D parentBox_;
    private String childTableName_;
    private String parentTableName_;
    private String childColumnName_;
    private String parentColumnName_;
    private Line2D namedLine;
    private double jointLength_;
    private int vertDirection_;
    private int parentEdge_;
    private int childEdge_;
    private boolean isSelfJoin_ = false;
    private boolean isChildExtended_ = false;
    private boolean isBent_ = false;
    private int parentX_;
    private int parentY_;
    private int childX_;
    private int childY_;
    private double vertStep_;
    private double headerRowHeight_;
    private double separatorHeight_;

    public FkRightAngleLinkCtrl(Database db, ForeignKeyGlyph fkGlyph) {
        this.fkGlyph_ = fkGlyph;
        this.fk_ = this.fkGlyph_.getForeignKey();
        this.parentGlyph_ = this.fkGlyph_.getParentGlyph();
        this.childGlyph_ = this.fkGlyph_.getChildGlyph();
        this.parentBox_ = this.parentGlyph_.getBounds2D();
        this.childBox_ = this.childGlyph_.getBounds2D();
        this.parentTableName_ = this.fk_.getParTbl().getName();
        this.childTableName_ = this.fk_.getChdTbl().getName();
        this.parentColumnName_ = this.fk_.getParentLinkColNm();
        this.childColumnName_ = this.fk_.getChildLinkColNm();
        JointGlyph jointGlyph = (JointGlyph)fkGlyph.getJoint(fkGlyph.getChildJointName());
        this.jointLength_ = jointGlyph.getLength();
    }

    public void refreshCalcs() {
        this.refreshIsSelfJoin();
        this.calcVertAttrs();
        this.calcEdges();
        this.calcJointXs();
    }

    private void refreshIsSelfJoin() {
        this.isSelfJoin_ = this.parentTableName_.equals(this.childTableName_);
    }

    public void calcVertAttrs() {
        int parentColPos = ((ITableGlyph)((Object)this.parentGlyph_)).getColumnPos(this.parentColumnName_);
        int childColPos = ((ITableGlyph)((Object)this.childGlyph_)).getColumnPos(this.childColumnName_);
        this.childY_ = this.getJointY((int)this.childBox_.getY(), childColPos);
        this.parentY_ = this.getJointY((int)this.parentBox_.getY(), parentColPos);
        this.vertDirection_ = this.childY_ >= this.parentY_ ? 0 : 2;
    }

    public void calcEdges() {
        if (this.getIsSelfJoin()) {
            this.setEdges(1, 1);
            return;
        }
        int cmin = (int)(this.childBox_.getX() - this.jointLength_);
        int cmax = (int)(this.childBox_.getX() + this.childBox_.getWidth() + this.jointLength_);
        int cmid = (int)(this.childBox_.getX() + 0.5 * this.childBox_.getWidth());
        int pmin = (int)(this.parentBox_.getX() - this.jointLength_);
        int pmax = (int)(this.parentBox_.getX() + this.parentBox_.getWidth() + this.jointLength_);
        this.isChildExtended_ = false;
        if (pmax < cmin) {
            this.setEdges(3, 1);
        } else if (pmin > cmax) {
            this.setEdges(1, 3);
        } else if (pmin > cmin) {
            if (pmin > cmid) {
                this.isBent_ = true;
                this.setEdges(1, 3);
            } else {
                this.setEdges(3, 3);
            }
        } else if (pmax < cmax) {
            if (pmax < cmid) {
                this.isBent_ = true;
                this.setEdges(3, 1);
            } else {
                this.setEdges(1, 1);
            }
        } else {
            this.setEdges(3, 3);
            this.isChildExtended_ = true;
        }
    }

    private void calcJointXs() {
        this.childX_ = this.getJointX(this.childBox_, this.childEdge_);
        this.parentX_ = this.getJointX(this.parentBox_, this.parentEdge_);
    }

    private int getJointY(int boxY, int columnPos) {
        double y = (double)boxY + this.vertStep_ + 9.0;
        return (int)(y += ((double)columnPos + 0.5) * this.vertStep_ + 1.0);
    }

    private int getJointX(Rectangle2D box, int edgeId) {
        int x = (int)box.getX();
        if (edgeId == 3) {
            --x;
        }
        if (edgeId == 1) {
            x += (int)box.getWidth();
        }
        return x;
    }

    private void setEdges(int childEdge, int parentEdge) {
        this.childEdge_ = childEdge;
        this.parentEdge_ = parentEdge;
    }

    public void setNamedLine(Line2D namedLine) {
        KeyToKeyNmPositionCalc nmPosCalc = new KeyToKeyNmPositionCalc();
        IPositioningCoord nmPosCoord = nmPosCalc.getNmCoord(namedLine, this.getNmCoordShiftFlag(), this.getIsSelfJoin());
        this.fkGlyph_.setNmPosCoord(nmPosCoord);
    }

    private String getNmCoordShiftFlag() {
        if (this.childEdge_ == 3) {
            return "ShiftLeft";
        }
        return "ShiftRight";
    }

    public void setHeaderHeight(double height) {
        this.headerRowHeight_ = height;
    }

    public void setStandardRowHeight(double height) {
        this.vertStep_ = height;
    }

    public void setSeparatorHeight(double height) {
        this.separatorHeight_ = height;
    }

    public int getVertDirection() {
        return this.vertDirection_;
    }

    public int getParentEdge() {
        return this.parentEdge_;
    }

    public int getChildEdge() {
        return this.childEdge_;
    }

    public int getParentX() {
        return this.parentX_;
    }

    public int getParentY() {
        return this.parentY_;
    }

    public Rectangle2D getParentBox() {
        return this.parentBox_;
    }

    public int getChildX() {
        return this.childX_;
    }

    public int getChildY() {
        return this.childY_;
    }

    public boolean getIsSelfJoin() {
        return this.isSelfJoin_;
    }

    public boolean getIsChildExtended() {
        return this.isChildExtended_;
    }

    public boolean getIsBent() {
        return this.isBent_;
    }

    public String getName() {
        Table chdTbl = this.fk_.getChdTbl();
        String nm = chdTbl.getSchema().getName() + "." + chdTbl.getName() + "." + this.fk_.getName();
        return nm;
    }
}

