/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.column.ColumnDiagramTextFormatter;
import com.harrand.dbwrench.diagram.table.TableGlyphWidthCalc;
import com.harrand.dbwrench.diagram.table.TableTitleStringBldr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.diagram.text.textLine.column.AutoNumberTextLine;
import com.harrand.dbwrenchgui.diagram.text.textLine.column.ColumnCommentTextLine;
import com.harrand.dbwrenchgui.diagram.text.textLine.column.ColumnDefaultTextLine;
import com.harrand.dbwrenchgui.diagram.text.textLine.column.ColumnNameTextLine;
import com.harrand.dbwrenchgui.diagram.text.textLine.column.DataLengthTextLine;
import com.harrand.dbwrenchgui.diagram.text.textLine.column.DataScaleTextLine;
import com.harrand.dbwrenchgui.diagram.text.textLine.column.DataTypeTextLine;
import com.harrand.dbwrenchgui.diagram.text.textLine.column.SignedTextLine;
import com.harrand.sketch.core.GlyphTextLine;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.glyph.calc.IconGlyphSizeCalc;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;

public final class DbTableTextBuilder
implements IObserver {
    private Table table_;
    private final DbTableGlyph tableGlyph;
    private int alignTabX_ = 0;
    private int columnsMaxWidth;
    private ColumnDiagramTextFormatter columnTextFormatter;
    private IconGlyphSizeCalc iconGlyphSizeCalc = new IconGlyphSizeCalc();
    private ColumnNameTextLine columnNmTextLine;
    private DataTypeTextLine dataTypeTextLine;
    private DataLengthTextLine lengthTextLine;
    private DataScaleTextLine scaleTextLine;
    private SignedTextLine signedTextLine;
    private AutoNumberTextLine autonumberTextLine;
    private ColumnDefaultTextLine columnDefaultTextLine;
    private ColumnCommentTextLine commentTextLine;
    private TableTitleStringBldr tableTitleStrBldr = new TableTitleStringBldr();
    private GlyphTextLine isArrayTextLine;
    private GlyphTextLine spacerTextLine;
    private GlyphTextLine startBracketLine;
    private GlyphTextLine endBracketLine;
    private GlyphTextLine commaLine;
    public static final int TEXT_SPACE = 5;
    public static final int AFTER_TBL_NM_ICON_COUNT = 2;
    public static final Color TEXT_COLOR = DbTableGlyph.MAIN_TEXT_DEFAULT_COLOR;

    public DbTableTextBuilder(DbTableGlyph tableGlyph) {
        this.tableGlyph = tableGlyph;
        this.table_ = tableGlyph.getTable();
        this.updateCalcs();
    }

    public void buildColumnGlyphTexts(Column column, Point2D start) {
        this.columnTextFormatter = new ColumnDiagramTextFormatter(column);
        this.clearTextLines();
        Point2D cursor = new Point2D.Double(start.getX(), start.getY());
        this.columnNmTextLine = new ColumnNameTextLine(this.table_, column, cursor, this.getFont());
        this.setTextLineCoordSpace(this.columnNmTextLine);
        cursor = new Point2D.Double(((Point2D)cursor).getX() + (double)this.alignTabX_, ((Point2D)cursor).getY());
        boolean showDataType = this.getVb().getShowFlag(DbVerbosity.getKeyDataType());
        if (showDataType) {
            cursor = this.buildDataTypeTextLines(column, cursor);
        }
        Point2D point2D = this.buildColumnDetailTextLines(column, cursor);
    }

    private void clearTextLines() {
        this.columnNmTextLine = null;
        this.dataTypeTextLine = null;
        this.lengthTextLine = null;
        this.scaleTextLine = null;
        this.isArrayTextLine = null;
        this.lengthTextLine = null;
        this.scaleTextLine = null;
        this.signedTextLine = null;
        this.autonumberTextLine = null;
        this.columnDefaultTextLine = null;
        this.commentTextLine = null;
        this.commaLine = null;
    }

    @Deprecated
    public int getMaxWidth() {
        this.updateCalcs();
        int headerWidth = GuiHelper.getSwingStringLength(this.getTitleStr(), this.getRenderConfig().getHeaderFont());
        int tableHeaderIconCnt = 3;
        int maxWidth = headerWidth + tableHeaderIconCnt * this.getIconSpace();
        if (!this.getDisplayColumns().isEmpty()) {
            maxWidth = Math.max(headerWidth, this.columnsMaxWidth);
        }
        return maxWidth;
    }

    public DbVerbosity getVb() {
        return (DbVerbosity)this.getRenderConfig().getVerbosityConfig();
    }

    public Point2D.Double incrementCursor(Point2D cursor, GlyphTextLine typeTextLine, boolean addSpacer) {
        int xSpace = addSpacer ? 5 : 0;
        double newX = cursor.getX() + (double)typeTextLine.getWidth() + (double)xSpace;
        return new Point2D.Double(newX, cursor.getY());
    }

    private void updateCalcs() {
        this.calcMaxWidths();
    }

    private List<Column> getDisplayColumns() {
        return this.tableGlyph.getDisplayColumns();
    }

    private void calcMaxWidths() {
        TableGlyphWidthCalc widthCalc = new TableGlyphWidthCalc(this.tableGlyph);
        this.alignTabX_ = (int)widthCalc.getColNmMaxWidth();
        this.columnsMaxWidth = (int)widthCalc.getWidth();
    }

    private Point2D setCoordSpaceDisp(GlyphTextLine textLine, Point2D cursor, boolean addSpacer) {
        this.setTextLineCoordSpace(textLine);
        return this.incrementCursor(cursor, textLine, addSpacer);
    }

    private Point2D buildDataTypeTextLines(Column column, Point2D cursor) {
        DbVerbosity vb = this.getVb();
        boolean showLengthFlag = vb.getShowFlag(DbVerbosity.getKeyLength());
        IDataType dataType = column.getDataType();
        boolean displayLength = showLengthFlag && dataType.isLengthUsed();
        this.dataTypeTextLine = new DataTypeTextLine(column, cursor, this.getFont());
        cursor = this.setCoordSpaceDisp(this.dataTypeTextLine, cursor, false);
        String strIsArray = this.columnTextFormatter.getIsArrayText();
        if (displayLength) {
            cursor = this.appendLengthScaleTextLines(column, cursor);
        }
        this.isArrayTextLine = this.createBasicTextLine(cursor, strIsArray);
        cursor = this.setCoordSpaceDisp(this.isArrayTextLine, cursor, false);
        this.spacerTextLine = this.createBasicTextLine(cursor, "  ");
        cursor = this.setCoordSpaceDisp(this.spacerTextLine, cursor, false);
        return cursor;
    }

    private Point2D appendLengthScaleTextLines(Column column, Point2D inCursor) {
        boolean displayScale;
        this.startBracketLine = this.createBasicTextLine(inCursor, "(");
        Point2D cursor = this.setCoordSpaceDisp(this.startBracketLine, inCursor, false);
        this.lengthTextLine = new DataLengthTextLine(column, cursor, this.getFont());
        cursor = this.setCoordSpaceDisp(this.lengthTextLine, cursor, false);
        boolean bl = displayScale = column.getScale() != null;
        if (displayScale) {
            this.commaLine = this.createBasicTextLine(cursor, ", ");
            cursor = this.setCoordSpaceDisp(this.commaLine, cursor, false);
            this.scaleTextLine = new DataScaleTextLine(column, cursor, this.getFont());
            cursor = this.setCoordSpaceDisp(this.scaleTextLine, cursor, false);
        }
        this.endBracketLine = this.createBasicTextLine(cursor, ")");
        cursor = this.setCoordSpaceDisp(this.endBracketLine, cursor, false);
        return cursor;
    }

    private Point2D buildColumnDetailTextLines(Column column, Point2D inCursor) {
        DbVerbosity vb = this.getVb();
        Point2D cursor = new Point2D.Double(inCursor.getX(), inCursor.getY());
        if (vb.getShowFlag(vb.getKeySigned())) {
            this.signedTextLine = new SignedTextLine(column, cursor, this.getFont(), this.columnTextFormatter.getSignedText());
            cursor = this.setCoordSpaceDisp(this.signedTextLine, cursor, true);
        }
        if (vb.getShowFlag(vb.getKeyAutoNumber())) {
            this.autonumberTextLine = new AutoNumberTextLine(column, cursor, this.getFont(), this.columnTextFormatter.getAutoNumberText());
            cursor = this.setCoordSpaceDisp(this.autonumberTextLine, cursor, true);
        }
        if (vb.getShowFlag(DbVerbosity.getKeyDefault())) {
            this.columnDefaultTextLine = new ColumnDefaultTextLine(column, cursor, this.getFont(), this.columnTextFormatter.getDefaultText());
            cursor = this.setCoordSpaceDisp(this.columnDefaultTextLine, cursor, true);
        }
        if (vb.getShowFlag(DbVerbosity.getKeyComment())) {
            this.commentTextLine = new ColumnCommentTextLine(column, cursor, this.getFont(), this.columnTextFormatter.getCommentText());
            cursor = this.setCoordSpaceDisp(this.commentTextLine, cursor, true);
        }
        return cursor;
    }

    @Override
    public void update(UpdateChain chain) {
    }

    public GlyphTextLine createBasicTextLine(Point2D cursor, String text) {
        return new GlyphTextLine(text, cursor, this.getFont(), 0, TEXT_COLOR);
    }

    private void setTextLineCoordSpace(GlyphTextLine textLine) {
        textLine.setCoordSpace(new Point(this.tableGlyph.getStart()));
    }

    private Font getFont() {
        return this.getRenderConfig().getFont();
    }

    public RenderConfig getRenderConfig() {
        return this.tableGlyph.getRenderConfig();
    }

    private int getIconSpace() {
        return this.iconGlyphSizeCalc.getIconSpace(this.getRenderConfig().getScaleFactor());
    }

    public AutoNumberTextLine getAutonumberTextLine() {
        return this.autonumberTextLine;
    }

    public ColumnDefaultTextLine getColumnDefaultTextLine() {
        return this.columnDefaultTextLine;
    }

    public ColumnNameTextLine getColumnNmTextLine() {
        return this.columnNmTextLine;
    }

    public GlyphTextLine getCommaTextLine() {
        return this.commaLine;
    }

    public ColumnCommentTextLine getCommentTextLine() {
        return this.commentTextLine;
    }

    public DataTypeTextLine getDataTypeTextLine() {
        return this.dataTypeTextLine;
    }

    public GlyphTextLine getEndBracketLine() {
        return this.endBracketLine;
    }

    public GlyphTextLine getIsArrayTextLine() {
        return this.isArrayTextLine;
    }

    public DataLengthTextLine getLengthTextLine() {
        return this.lengthTextLine;
    }

    public DataScaleTextLine getScaleTextLine() {
        return this.scaleTextLine;
    }

    public SignedTextLine getSignedTextLine() {
        return this.signedTextLine;
    }

    public GlyphTextLine getSpacerTextLine() {
        return this.spacerTextLine;
    }

    public GlyphTextLine getStartBracketLine() {
        return this.startBracketLine;
    }

    private String getTitleStr() {
        return this.tableTitleStrBldr.getTitleStr(this.table_, this.getVb());
    }
}

