/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.display.BasicColorable;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.display.color.DefaultColorCtrl;
import com.harrand.coreclasses.element.IDiagramCopyable;
import com.harrand.coreclasses.element.IMemoryReclaimable;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.mouse.tracker.IMouseTracker;
import com.harrand.dbwrench.diagram.bldr.DbTableSubGlyphBldr;
import com.harrand.dbwrench.diagram.hilight.color.BlueColorScheme;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.dbwrench.diagram.table.ITableGlyph;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.diagram.clickAction.bldr.DbTableGlyphClickActionCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.GlyphImage;
import com.harrand.sketch.core.GlyphSeperator;
import com.harrand.sketch.core.GlyphTextLine;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.box.DiagramBox;
import com.harrand.sketch.core.config.rc.IRenderConfigSrc;
import com.harrand.sketch.glyph.GlyphPosUtil;
import com.harrand.sketch.glyph.RectGlyph;
import com.harrand.sketch.glyph.interfaces.IDetailableGlyph;
import com.harrand.sketch.glyph.rect.OverZoneCalc;
import com.harrand.sketch.interfaces.IGradientable;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.interfaces.IObjGlyph;
import com.harrand.sketch.interfaces.IPreImagedGlyph;
import com.harrand.sketch.interfaces.IRenderConfigDependent;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.highLight.RoundRectHighLighter;
import com.harrand.sketch.j2d.shadow.RoundRectSpotShadow;
import com.harrand.sketch.support.DrawableUtil;
import com.harrand.sketch.xml.DiagramProps;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class DbTableGlyph
implements Glyph,
IObserver,
IObservable,
IColorable,
IDirtyTrackable,
IPreImagedGlyph,
IHilightableGlyph,
IGradientable,
IRenderConfigDependent,
ITableGlyph,
IMemoryReclaimable,
IDiagramCopyable,
IObjGlyph,
IDrawable,
IMouseTracker,
IRenderConfigSrc,
IDetailableGlyph {
    private Diagram diagram_;
    private final Table table_;
    private List<Column> displayColumns_ = new ArrayList<Column>();
    private Point origin;
    private RoundRectangle2D rectAbs = new RoundRectangle2D.Double();
    private RoundRectangle2D rectRelative = new RoundRectangle2D.Double();
    private final GlyphPosUtil posUtil_ = new GlyphPosUtil();
    private final RoundRectHighLighter hiLighter = new RoundRectHighLighter();
    private final DbTableSubGlyphBldr subGlyphBuilder;
    private final DbTableGlyphClickActionCtrl clickActionCtrl;
    private RoundRectSpotShadow shadow;
    private Point cursor_;
    private double boxWidth_;
    private double boxHeight_;
    private double scaleFactor_ = 1.0;
    private int vertStep_;
    private boolean hasMoved;
    private double radiusD;
    private Set indexColumnNames_ = new HashSet();
    private IColorable colorable_;
    private final BasicObservable observable_;
    private IDirtyTracker dirtyTracker_;
    private BufferedImage image_ = null;
    private boolean selected_;
    private boolean useGradient_ = true;
    private String titleStr_ = "";
    private String columnsStr_ = "";
    private List fkColNms_ = new ArrayList();
    public static final Color MAIN_TEXT_DEFAULT_COLOR = Color.BLACK;
    public static final Color MAIN_BOX_DEFAULT_COLOR = Colors.getBlue3_0();
    public static final int VERT_SPACER_COUNT = 4;
    public static final int VERT_IMG_PAD = 2;
    private static final IColorScheme DEFAULT_HILIGHT_COLOR_SCHEME = BlueColorScheme.getInstance();

    public DbTableGlyph(Point start, Table table, Diagram diagram) {
        this.setOrigin(start);
        this.table_ = table;
        this.setDiagram(diagram);
        this.observable_ = new BasicObservable();
        this.table_.addObserver(this);
        this.clickActionCtrl = new DbTableGlyphClickActionCtrl(this);
        this.subGlyphBuilder = new DbTableSubGlyphBldr(this);
        this.loadDisplayColumns();
        this.initColors();
        this.calcVertStep();
        this.calcFields();
        this.observable_.setSuperDesc("TblGly:" + this.getName());
    }

    public void addNotNullGlyphImage(GlyphImage pkGlyph, List<IDrawable> drawables) {
        if (pkGlyph != null) {
            drawables.add(pkGlyph);
        }
    }

    private void clearClickActions() {
        this.clickActionCtrl.checkClearClickActions();
    }

    private void clearColumnTextLineStore() {
        this.subGlyphBuilder.clearColumnTextLineStores();
    }

    private Font getFont() {
        return this.getRenderConfig().getFont();
    }

    private void setOrigin(Point start) {
        this.origin = start;
        if (this.clickActionCtrl != null) {
            this.updateRect();
        }
    }

    public String toString() {
        return DbTableGlyph.getClassName() + ": " + this.getName();
    }

    private void updateRect() {
        this.radiusD = this.getCornerRadius();
        this.rectAbs = new RoundRectangle2D.Double(this.origin.x, this.origin.y, this.getRectWidth(), this.getRectHeight(), this.radiusD, this.radiusD);
        this.rectRelative = new RoundRectangle2D.Double(0.0, 0.0, this.getRectWidth(), this.getRectHeight(), this.radiusD, this.radiusD);
        if (this.shadow != null) {
            this.shadow.setRect(this.rectAbs);
        }
    }

    private long getRectWidth() {
        return Math.round(this.boxWidth_) - 1L;
    }

    private long getRectHeight() {
        return Math.round(this.boxHeight_) - 1L;
    }

    private void initColors() {
        this.colorable_ = new BasicColorable();
        this.colorable_.setColor("MainBox", DefaultColorCtrl.getInstance().getDefaultColorSafe(this.getClass(), MAIN_BOX_DEFAULT_COLOR));
        this.colorable_.setColor("MainText", MAIN_TEXT_DEFAULT_COLOR);
    }

    public String getTitleStr() {
        return this.titleStr_;
    }

    public String getColumnsStr() {
        return this.columnsStr_;
    }

    public double getWidth() {
        return this.getBounds2D().getWidth();
    }

    public Diagram getDiagram() {
        return this.diagram_;
    }

    public DiagramBox getDiagramBox() {
        return new DiagramBox(this.getName(), this.getBounds2D());
    }

    public List getIndexColNms() {
        return new ArrayList(this.indexColumnNames_);
    }

    public List getFkColNms() {
        return this.fkColNms_;
    }

    public GlyphPosUtil getPosUtil() {
        return this.posUtil_;
    }

    public boolean containsZoomed(Point2D p) {
        return this.getZoomedBounds().contains(p);
    }

    public Rectangle2D getZoomedBounds() {
        return Zoomer.zoom(this.getBounds2D(), this.getRenderConfig().getZoomLevel());
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getBounds2D().contains(p);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.origin.getX(), this.origin.getY(), this.boxWidth_ - 1.0, this.boxHeight_ - 1.0);
    }

    @Override
    public BufferedImage getImage() {
        if (this.image_ == null) {
            this.createBI();
            this.refresh();
        }
        return this.image_;
    }

    private void createBI() {
        this.image_ = GuiHelper.getBufferedImage(this.getImgWidth(), this.getImgHeight(), true);
    }

    private int getImgWidth() {
        int imgWidth = (int)this.boxWidth_ + 3;
        return imgWidth;
    }

    private int getImgHeight() {
        int imgHeight = (int)this.boxHeight_ + 3;
        return imgHeight;
    }

    private void addVertSpacer() {
        this.cursor_.translate(0, 2);
    }

    @Override
    public void refresh() {
        this.scaleFactor_ = this.getRenderConfig().getScaleFactor();
        this.loadDisplayColumns();
        this.calcVertStep();
        this.calcFields();
        this.renderImage();
        this.hasMoved = false;
    }

    private void loadDisplayColumns() {
        int oldColCount = this.displayColumns_.size();
        this.displayColumns_.clear();
        DiagramProps props = this.diagram_.getDiagramProps();
        ArrayList<Column> allColumns = new ArrayList<Column>(this.table_.values(Column.getClassName()));
        if (props.getShowAllColumns()) {
            this.displayColumns_ = allColumns;
        } else {
            boolean showPks = props.getShowPkColumns();
            boolean showFks = props.getShowFkColumns();
            for (Column column : allColumns) {
                if (showPks && column.isPkField(this.table_)) {
                    this.displayColumns_.add(column);
                }
                if (!showFks || !this.table_.getIsFkCol(column.getName())) continue;
                this.displayColumns_.add(column);
            }
        }
        int newColCount = this.displayColumns_.size();
        if (newColCount != oldColCount) {
            this.clearColumnTextLineStore();
            this.refresh();
        }
    }

    private boolean needNewBI() {
        boolean need = false;
        if (this.image_ != null && (this.image_.getWidth() != (int)this.boxWidth_ || this.image_.getHeight() != (int)this.boxHeight_)) {
            need = true;
        }
        return need;
    }

    private boolean isDisplayedColumn(String colNm) {
        boolean isDisplayed = this.getColumnPos(colNm) >= 0;
        return isDisplayed;
    }

    @Override
    public int getColumnPos(String colNm) {
        int pos = -1;
        int i = 0;
        for (Column column : this.displayColumns_) {
            if (column.getName().equals(colNm)) {
                pos = i;
                return pos;
            }
            ++i;
        }
        return pos;
    }

    @Override
    public Rectangle2D getColumnBounds(String colNm) {
        Rectangle2D.Double rawRect = null;
        if (this.isDisplayedColumn(colNm)) {
            int pos = this.getColumnPos(colNm);
            Rectangle2D box = this.getBounds2D();
            double x = box.getX() + 1.0;
            double y = box.getY() + ((double)pos + 1.3) * (double)this.vertStep_ + 3.0 + 4.0;
            rawRect = new Rectangle2D.Double(x, y, box.getWidth() - 5.0, this.vertStep_);
        }
        return rawRect;
    }

    public List getDrawables() {
        return this.refreshDrawables();
    }

    public List<IDrawable> refreshDrawables() {
        int indentL = this.getIndent();
        this.refreshIndexColumns();
        ArrayList<IDrawable> drawables = new ArrayList<IDrawable>();
        StringBuilder colsSb = new StringBuilder();
        this.initNmLists();
        this.clickActionCtrl.checkRebuildRequired();
        this.posUtil_.setRenderConfig(this.getRenderConfig());
        this.posUtil_.setBoxWidth(this.boxWidth_);
        this.posUtil_.setCoordSpace(this.getStart());
        this.cursor_ = new Point(0, 0);
        int vertStep = this.getVertStep();
        this.cursor_.translate(0, vertStep);
        this.addVertSpacer();
        GlyphImage tablePropsGlyph = this.subGlyphBuilder.getTableDetailsGlyph();
        drawables.add(tablePropsGlyph);
        this.cursor_.translate(indentL, 0);
        this.titleStr_ = this.subGlyphBuilder.getTitleStr();
        GlyphTextLine headerTextLine = this.subGlyphBuilder.getTableGlyphText(this.titleStr_);
        double tblNmStartX = headerTextLine.getStart().getX();
        drawables.add(headerTextLine);
        GlyphImage deleteTableGlyph = this.subGlyphBuilder.getDeleteTableGlyph(tblNmStartX);
        GlyphImage showDataGlyph = this.subGlyphBuilder.getShowDataGlyph();
        this.addNotNullGlyphImage(showDataGlyph, drawables);
        this.cursor_.translate(-indentL, (int)(0.3 * (double)vertStep));
        this.addVertSpacer();
        drawables.add(this.getSeparatorGlyph());
        this.addVertSpacer();
        this.cursor_.translate(0, vertStep);
        int count = 0;
        for (Column column : this.displayColumns_) {
            ++count;
            GlyphImage pkGlyph = this.subGlyphBuilder.getPkGlyph(column, this.cursor_);
            this.addNotNullGlyphImage(pkGlyph, drawables);
            GlyphImage nullableGlyph = this.subGlyphBuilder.getNullableGlyph(column, this.cursor_);
            this.addNotNullGlyphImage(nullableGlyph, drawables);
            GlyphImage fkGlyph = this.subGlyphBuilder.getFkGlyph(column, this.cursor_);
            this.addNotNullGlyphImage(fkGlyph, drawables);
            GlyphImage indexGlyph = this.getIndexGlyph(column);
            this.addNotNullGlyphImage(indexGlyph, drawables);
            GlyphImage deleteColGlyph = this.subGlyphBuilder.getDeleteColumnGlyph(column, this.cursor_);
            this.addNotNullGlyphImage(deleteColGlyph, drawables);
            GlyphImage addColGlyph = this.subGlyphBuilder.getAddColumnGlyph(column, count, this.cursor_);
            this.addNotNullGlyphImage(addColGlyph, drawables);
            this.cursor_.translate(indentL, 0);
            List<GlyphTextLine> columnGlyphTexts = this.subGlyphBuilder.getColumnGlyphTexts(column, this.cursor_);
            drawables.addAll(columnGlyphTexts);
            this.cursor_.translate(-indentL, vertStep);
        }
        this.columnsStr_ = colsSb.toString();
        ArrayList<IDrawable> allDrawables = new ArrayList<IDrawable>();
        allDrawables.add(this.getRectGlyph());
        allDrawables.addAll(this.clickActionCtrl.getDrawables());
        allDrawables.addAll(drawables);
        return allDrawables;
    }

    private void initNmLists() {
        this.fkColNms_ = new ArrayList();
    }

    public RoundRectSpotShadow getShadow() {
        if (OverZoneCalc.isOverZone(this.getBounds2D(), this.diagram_.getZones())) {
            return null;
        }
        if (this.shadow == null) {
            this.createShadow();
        }
        return this.shadow;
    }

    private void createShadow() {
        String nm = DbTableGlyph.getClassName() + " - " + this.getName();
        this.shadow = new RoundRectSpotShadow(this.rectAbs, nm);
    }

    @Override
    public List<IDrawable> getHilightDrawables(Diagram diagram) {
        return this.hiLighter.getHilightShapes(this.rectAbs, diagram.getZoom());
    }

    private void refreshIndexColumns() {
        this.indexColumnNames_ = new HashSet();
        for (Index index : this.table_.values(Index.getClassName())) {
            this.indexColumnNames_.addAll(index.getIndexColumns());
        }
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        DrawableUtil.drawPreImaged(this, g2, zoom);
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    private void notifyDirty() {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    public static String getClassName() {
        return "DbTableGlyph";
    }

    public String getObjectName() {
        return this.getTableName();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    public String getTableName() {
        return this.table_.getName();
    }

    @Override
    public Table getTable() {
        return this.table_;
    }

    @Override
    public String getName() {
        return this.getTable().getDotNote();
    }

    @Override
    public void move(Point p) {
        this.setOrigin(new Point(p));
        this.hasMoved = true;
        this.notifyDirty();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected_;
    }

    private void calcFields() {
        this.getIndent();
        this.calcWidth();
        this.calcHeight();
        this.updateRect();
    }

    private void calcWidth() {
        this.boxWidth_ = this.subGlyphBuilder.getMaxWidth();
    }

    private void calcHeight() {
        this.boxHeight_ = this.getVertStep() * (this.displayColumns_.size() + 1) + (int)(0.5 * (double)this.getVertStep()) + 1 + 8;
    }

    private int getIndent() {
        return this.posUtil_.getIconSpace() + 2;
    }

    private void renderImage() throws IllegalArgumentException {
        if (this.image_ != null) {
            if (this.needNewBI()) {
                this.createBI();
            }
            Graphics2D gfx = (Graphics2D)this.image_.getGraphics();
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gfx.setPaint(Color.BLACK);
            DrawableUtil.drawMixedItems(this.refreshDrawables(), gfx, this.getRenderConfig().getZoom());
        }
    }

    @Override
    public void setDiagram(Diagram diagram) {
        this.diagram_ = diagram;
        this.posUtil_.setRenderConfig(this.getRenderConfig());
    }

    @Override
    public RenderConfig getRenderConfig() {
        return this.diagram_.getRenderConfig();
    }

    public int getVertStep() {
        return this.vertStep_;
    }

    public int getCornerRadius() {
        return this.getFont().getSize() + 1;
    }

    private void calcVertStep() {
        this.vertStep_ = GuiHelper.getFontLineHeight(this.getFont());
    }

    private GlyphImage getIndexGlyph(Column column) {
        GlyphImage glyphImage = this.subGlyphBuilder.getIndexGlyph(column, this.cursor_);
        return glyphImage;
    }

    private Line2D getSeparatorLine() {
        Line2D.Double line = new Line2D.Double(this.cursor_.getX() + 1.0, this.cursor_.getY(), this.cursor_.getX() + this.boxWidth_ - 2.0, this.cursor_.getY());
        return line;
    }

    private GlyphSeperator getSeparatorGlyph() {
        Line2D line = this.getSeparatorLine();
        GlyphSeperator sep = new GlyphSeperator(line.getP1(), line.getP2(), Color.GRAY);
        sep.setCoordSpace(this.origin);
        return sep;
    }

    private RectGlyph getRectGlyph() {
        RectGlyph rectGlyph = new RectGlyph(this.rectRelative);
        rectGlyph.setBgColor(this.colorable_.getColor("MainBox"));
        rectGlyph.setUseGradient(this.useGradient_);
        rectGlyph.setCoordSpace(new Point(this.origin));
        rectGlyph.setRectangleFill(this.diagram_.getDiagramProps().getDbTableRectangleFill());
        rectGlyph.setHeaderHeight(1.3 * (double)this.vertStep_ + 4.0 + this.radiusD);
        return rectGlyph;
    }

    public Point getStart() {
        return this.origin;
    }

    @Override
    public void setScaleFactor(double sf) {
        LogUtil.logErr("DbTableGlyph.setScaleFactor() should not be called.");
    }

    public double getScaleFactor() {
        return this.scaleFactor_;
    }

    @Override
    public void update(UpdateChain chain) {
        this.clickActionCtrl.refresh();
        this.clearColumnTextLineStore();
        this.refresh();
        this.notifyObservers(chain);
    }

    @Override
    public Color getColor(String key) {
        return this.colorable_.getColor(key);
    }

    @Override
    public List getKeys() {
        return this.colorable_.getKeys();
    }

    @Override
    public void setColor(String key, Color color) {
        this.colorable_.setColor(key, color);
        if (key.equals("MainBox")) {
            DefaultColorCtrl.getInstance().putDefaultColor(this.getClass(), color);
        }
        this.refresh();
        this.notifyDirty();
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public void reclaimMemory() {
    }

    @Override
    public void setUseGradient(boolean flag) {
        this.useGradient_ = flag;
    }

    @Override
    public boolean getUseGradient() {
        return this.useGradient_;
    }

    @Override
    public IDiagramCopyable copy(Diagram targetDiagram) {
        DbTableGlyph copy = new DbTableGlyph(this.origin, this.table_, targetDiagram);
        copy.setColor("MainBox", this.getColor("MainBox"));
        return copy;
    }

    @Override
    public Object getGlyphObject() {
        return this.getTable();
    }

    public DbTableGlyphClickActionCtrl getClickActionCtrl() {
        return this.clickActionCtrl;
    }

    private boolean contains(MouseEvent e) {
        return this.contains(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        boolean isOverGlyph = this.containsZoomed(e.getPoint());
        this.clickActionCtrl.setIsActive(isOverGlyph);
        if (isOverGlyph) {
            this.clickActionCtrl.mouseMoved(e);
            this.refresh();
        } else {
            this.clearClickActions();
        }
    }

    @Override
    public boolean mouseDown(MouseEvent e) {
        boolean processed = false;
        boolean isOverGlyph = this.containsZoomed(e.getPoint());
        if (isOverGlyph) {
            CentralLookup.getDefault().addOrReplace(this.table_);
            processed = this.clickActionCtrl.mouseDown(e);
            boolean stillInSchema = this.table_.getSchema().contains(Table.getClassName(), this.table_.getName());
            if (processed && stillInSchema) {
                this.clearClickActions();
                this.mouseMoved(e);
            }
        }
        return processed;
    }

    @Override
    public void mouseUp(MouseEvent e) {
        this.clickActionCtrl.mouseUp(e);
        if (this.hasMoved) {
            this.clickActionCtrl.refresh();
            this.refresh();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.isTableDeleted()) {
            this.clearClickActions();
        }
    }

    public List<Column> getDisplayColumns() {
        return this.displayColumns_;
    }

    private boolean isTableDeleted() {
        return !this.table_.getSchema().containsTable(this.table_.getName());
    }

    @Override
    public void setColorScheme(IColorScheme colorScheme) {
        LogUtil.logMsg(this, "colorScheme: " + colorScheme.getClass());
        this.hiLighter.clearSelectionShapes();
        this.hiLighter.setColorScheme(colorScheme);
    }

    public void setDefaultHilightSchema() {
        this.setColorScheme(DEFAULT_HILIGHT_COLOR_SCHEME);
    }
}

