/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.table.ITableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.interfaces.ILinkSource;
import java.awt.Color;
import java.util.ArrayList;

public final class DbLinkSource
implements ILinkSource,
IObservable,
IObserver {
    private Database db_;
    private BasicObservable observable_;

    public DbLinkSource(Database db) {
        this.db_ = db;
        this.db_.addObserver(this);
        this.observable_ = new BasicObservable();
    }

    private ForeignKeyGlyph createFkGlyph(ForeignKey fk, Diagram diagram, ForeignKeyGlyph oldFkGlyph) {
        if (oldFkGlyph != null) {
            oldFkGlyph.setFk(fk);
            return oldFkGlyph;
        }
        ForeignKeyGlyph newFkGlyph = new ForeignKeyGlyph(fk, diagram, Color.BLACK);
        newFkGlyph.setDirtyTracker(this.db_);
        newFkGlyph.addObserver(diagram);
        return newFkGlyph;
    }

    @Override
    public NamedList getLinks2(Diagram diagram) {
        NamedList oldFkGlyphs = diagram.getLinksList();
        NamedList newFkGlyphs = new NamedList();
        ArrayList<Table> diagramTables = new ArrayList<Table>();
        for (Glyph glyph : diagram.getOnlyGlyphs()) {
            if (!(glyph instanceof ITableGlyph)) continue;
            diagramTables.add(((ITableGlyph)((Object)glyph)).getTable());
        }
        for (ForeignKey fk : this.db_.getFkUtil().getAllFks()) {
            String fkDotNote = fk.getDotNote();
            Table parTbl = fk.getParTbl();
            Table chdTbl = fk.getChdTbl();
            if (!diagramTables.contains(parTbl) || !diagramTables.contains(chdTbl)) continue;
            ForeignKeyGlyph oldFkGlyph = (ForeignKeyGlyph)oldFkGlyphs.get(fkDotNote);
            ForeignKeyGlyph newFkGlyph = oldFkGlyph != null && oldFkGlyph.getForeignKey() == fk ? oldFkGlyph : this.createFkGlyph(fk, diagram, oldFkGlyph);
            newFkGlyphs.add(newFkGlyph);
        }
        return newFkGlyphs;
    }

    @Override
    public NamedList getLinks(Diagram diagram) {
        NamedList oldFkGlyphs = diagram.getLinksList();
        NamedList newFkGlyphs = new NamedList();
        ArrayList<String> tblDotNotes = new ArrayList<String>();
        for (Glyph glyph : diagram.getOnlyGlyphs()) {
            tblDotNotes.add(glyph.getName());
        }
        for (ForeignKey fk : this.db_.getFkUtil().getAllFks()) {
            ForeignKeyGlyph newFkGlyph;
            String fkDotNote = fk.getDotNote();
            String parTblDotNote = fk.getParTbl().getDotNote();
            String chdTblDotNote = fk.getChdTbl().getDotNote();
            if (!tblDotNotes.contains(parTblDotNote) || !tblDotNotes.contains(chdTblDotNote)) continue;
            ForeignKeyGlyph oldFkGlyph = (ForeignKeyGlyph)oldFkGlyphs.get(fkDotNote);
            if (oldFkGlyph != null && oldFkGlyph.getForeignKey() == fk) {
                newFkGlyph = oldFkGlyph;
                Color color = oldFkGlyph.getColor("BackColor");
            } else {
                newFkGlyph = this.createFkGlyph(fk, diagram, oldFkGlyph);
            }
            newFkGlyphs.add(newFkGlyph);
        }
        return newFkGlyphs;
    }

    @Override
    public NamedList updateLinkNmsByPrefix(Diagram diagram, String oldDotNotePrefix, String newDotNotePrefix) {
        return diagram.getLinksList();
    }

    @Override
    public NamedList updateLinkNms(Diagram diagram, String oldFkDotNote, String newFkDotNote) {
        NamedList newLinks = new NamedList();
        NamedList oldLinks = diagram.getLinksList();
        for (String key : oldLinks.getNames()) {
            ForeignKeyGlyph oldFkGlyph = (ForeignKeyGlyph)oldLinks.get(key);
            if (key.equals(oldFkDotNote)) {
                ForeignKey fk = this.db_.getFkFromDotNote(newFkDotNote);
                ForeignKeyGlyph newFkGlyph = this.createFkGlyph(fk, diagram, oldFkGlyph);
                newLinks.add(newFkGlyph);
                continue;
            }
            newLinks.add(oldFkGlyph);
        }
        return newLinks;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void update(UpdateChain chain) {
    }
}

