/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.diagram.DbLinkSource;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.KeyToKeyStrategy;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.util.ArrayList;

public class DbDiagramTestData {
    public static final String DATA_TB_NM = "DataTbl";
    public static final String DATA_ID_COL_NM = "DataTblId";
    public static final String NW_TB_NM = "NorthWest";
    public static final String NW_ID_COL_NM = "NorthWestId";
    public static final String NE_TB_NM = "NorthEast";
    public static final String NE_ID_COL_NM = "NorthEastId";
    public static final String SW_TB_NM = "SouthWest";
    public static final String SW_ID_COL_NM = "SouthWestId";
    public static final String SE_TB_NM = "SouthEast";
    public static final String SE_ID_COL_NM = "SouthEastId";
    public static final String SC_TB_NM = "SouthCenter";
    public static final String SC_ID_A_COL_NM = "SouthCenterIdA";
    public static final String SC_ID_B_COL_NM = "SouthCenterIdB";
    public static final String SELF_ID_COL_NM = "SelfId";
    public static final String BW_TB_NM = "BendWest";
    public static final String BW_ID_COL_NM = "BendWestId";
    public static final String BE_TB_NM = "BendEast";
    public static final String BE_ID_COL_NM = "BendEastId";
    public static final String SC_DESC_COL_NM = "SouthCenterDescription";
    public static final String FK_NW_NM = "fkNw";
    public static final String FK_NE_NM = "fkNe";
    public static final String FK_SW_NM = "fkSw";
    public static final String FK_SE_NM = "fkSe";
    public static final String FK_SC_NM = "fkSc";
    public static final String FK_SELF_NM = "fkSelf";
    public static final String FK_BW_NM = "fkBw";
    public static final String FK_BE_NM = "fkBe";
    public static final String DIAGRAM_NM = "DiagramA";

    public static Database getDatabaseWithDiagrams() {
        Database db = new Database("DiagramTestDb");
        Schema schema = db.getSchema("schemaA");
        schema.add(DbDiagramTestData.getBasicTable(DATA_TB_NM, DATA_ID_COL_NM));
        schema.add(DbDiagramTestData.getBasicTable(NW_TB_NM, NW_ID_COL_NM));
        schema.add(DbDiagramTestData.getBasicTable(NE_TB_NM, NE_ID_COL_NM));
        schema.add(DbDiagramTestData.getBasicTable(SW_TB_NM, SW_ID_COL_NM));
        schema.add(DbDiagramTestData.getBasicTable(SE_TB_NM, SE_ID_COL_NM));
        schema.add(DbDiagramTestData.getScTable());
        schema.add(DbDiagramTestData.getBasicTable(BW_TB_NM, BW_ID_COL_NM));
        schema.add(DbDiagramTestData.getBasicTable(BE_TB_NM, BE_ID_COL_NM));
        Table scTable = schema.getTable(SC_TB_NM);
        Table dataTable = schema.getTable(DATA_TB_NM);
        try {
            Column colScDesc = new Column(SC_DESC_COL_NM, 12, new Integer(255), false);
            ITestResult result = scTable.add(colScDesc);
            Column colSelfId = new Column(SELF_ID_COL_NM, 4, null, false);
            result = dataTable.add(colSelfId);
            ForeignKey fkSelf = new ForeignKey(FK_SELF_NM, dataTable, dataTable, DATA_ID_COL_NM, SELF_ID_COL_NM);
            result = dataTable.add(fkSelf);
        }
        catch (Exception e) {
            LogUtil.logErr("DbDiagramTestData.extraTableError: " + e.getMessage());
        }
        DbDiagramTestData.addDataTableFk(db, FK_NW_NM, NW_TB_NM, NW_ID_COL_NM);
        DbDiagramTestData.addDataTableFk(db, FK_NE_NM, NE_TB_NM, NE_ID_COL_NM);
        DbDiagramTestData.addDataTableFk(db, FK_SW_NM, SW_TB_NM, SW_ID_COL_NM);
        DbDiagramTestData.addDataTableFk(db, FK_SE_NM, SE_TB_NM, SE_ID_COL_NM);
        DbDiagramTestData.addScFk(db);
        DbDiagramTestData.addDataTableFk(db, FK_BW_NM, BW_TB_NM, BW_ID_COL_NM);
        DbDiagramTestData.addDataTableFk(db, FK_BE_NM, BE_TB_NM, BE_ID_COL_NM);
        RenderConfig renderConfig = new RenderConfig(1.0, (LinkStrategy)new KeyToKeyStrategy(db), (VerbosityConfig)new DbVerbosity());
        Diagram diagram = new Diagram(DIAGRAM_NM, renderConfig, new ArrayList());
        DbLinkSource linkSource = new DbLinkSource(db);
        DbDiagramTestData.addGlyph(db, diagram, DATA_TB_NM, 400, 400);
        DbDiagramTestData.addGlyph(db, diagram, NW_TB_NM, 10, 10);
        DbDiagramTestData.addGlyph(db, diagram, NE_TB_NM, 800, 10);
        DbDiagramTestData.addGlyph(db, diagram, SW_TB_NM, 10, 800);
        DbDiagramTestData.addGlyph(db, diagram, SE_TB_NM, 800, 800);
        DbDiagramTestData.addGlyph(db, diagram, SC_TB_NM, 360, 800);
        DbDiagramTestData.addGlyph(db, diagram, BW_TB_NM, 250, 10);
        DbDiagramTestData.addGlyph(db, diagram, BE_TB_NM, 550, 10);
        db.add(diagram);
        diagram.setLinkSource(linkSource);
        return db;
    }

    private static Table getBasicTable(String tableName, String idColName) {
        Table table = null;
        try {
            Column idCol = new Column(idColName, 4, null, false);
            table = new Table(tableName);
            table.add(idCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(idColName);
            PrimaryKey pk = new PrimaryKey("pk" + tableName, pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.logErr("DbDiagramTestData Error: " + e.getMessage());
        }
        return table;
    }

    private static Table getScTable() {
        Table table = null;
        try {
            Column idACol = new Column(SC_ID_A_COL_NM, 4, null, false);
            Column idBCol = new Column(SC_ID_B_COL_NM, 4, null, false);
            table = new Table(SC_TB_NM);
            table.add(idACol);
            table.add(idBCol);
            ArrayList<String> pkCols = new ArrayList<String>();
            pkCols.add(SC_ID_A_COL_NM);
            pkCols.add(SC_ID_B_COL_NM);
            PrimaryKey pk = new PrimaryKey("pkSouthCenter", pkCols);
            table.setPrimaryKey(pk);
        }
        catch (Exception e) {
            LogUtil.logErr("DbDiagramTestData Error: " + e.getMessage());
        }
        return table;
    }

    private static void addDataTableFk(Database db, String fkName, String parentTableName, String parentColumnName) {
        try {
            Column colChild = new Column(parentColumnName, 4, null, true);
            Schema schema = db.getSchema("schemaA");
            Table tblParent = schema.getTable(parentTableName);
            Table tblData = schema.getTable(DATA_TB_NM);
            tblData.add(colChild);
            ForeignKey fk = new ForeignKey(fkName, tblParent, tblData, parentColumnName, colChild.getName());
            tblData.add(fk);
        }
        catch (Exception e) {
            LogUtil.logErr("DbDiagramTestData Error: " + e.getMessage());
        }
    }

    private static void addScFk(Database db) {
        try {
            Schema schema = db.getSchema("schemaA");
            Table scTbl = schema.getTable(SC_TB_NM);
            Table childTable = schema.getTable(DATA_TB_NM);
            Column colChildA = new Column(SC_ID_A_COL_NM, 4, null, true);
            Column colChildB = new Column(SC_ID_B_COL_NM, 4, null, true);
            childTable.add(colChildA);
            childTable.add(colChildB);
            ArrayList<StringPair> fkCols = new ArrayList<StringPair>();
            fkCols.add(new StringPair(SC_ID_A_COL_NM, SC_ID_A_COL_NM));
            fkCols.add(new StringPair(SC_ID_B_COL_NM, SC_ID_B_COL_NM));
            ForeignKey fk = new ForeignKey(FK_SC_NM, scTbl, childTable, fkCols, 3, 3, "", ForeignKey.getDefaultCardinality(1), SC_ID_A_COL_NM);
            childTable.add(fk);
        }
        catch (Exception e) {
            LogUtil.logErr("DbDiagramTestData Error: " + e.getMessage());
        }
    }

    private static void addGlyph(Database db, Diagram diagram, String tableName, int x, int y) {
        Schema schema = db.getSchema("schemaA");
        Table table = schema.getTable(tableName);
        DbTableGlyph glyph = new DbTableGlyph(new Point(x, y), table, diagram);
        diagram.addGlyph(glyph);
    }
}

