/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db.table;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.bldr.DbTableLayoutDisp;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.sketch.core.Diagram;
import java.awt.Point;
import java.util.ArrayList;

public final class CloneTableCommand
extends Command {
    public static final String CLONE_NAME_SUFFIX = "_dup";
    public static final int POINT_OFFSET = 20;
    private String cmdName;
    private Table tableToClone;
    private Table clone;
    private Diagram diagram;
    private String cloneTableName;

    public CloneTableCommand(Table tableToClone, Diagram diagram, String cloneTableName) {
        this.init(tableToClone, diagram, cloneTableName, null);
    }

    private CloneTableCommand(Table tableToClone, Diagram diagram, String cloneTableName, Table clone) {
        this.init(tableToClone, diagram, cloneTableName, clone);
    }

    private void init(Table tableToClone, Diagram diagram, String cloneTableName, Table clone) {
        this.tableToClone = tableToClone;
        this.diagram = diagram;
        this.cloneTableName = cloneTableName;
        this.clone = clone;
        this.cmdName = "Clone Table: " + tableToClone.getName();
        this.setProps();
        CommandChain cmdChain = CommandChainMgr.getInstance().getCommandChain();
        this.setCommandChain(cmdChain);
    }

    private void cloneTable() {
        Schema schema = this.tableToClone.getSchema();
        ITestResult dupNameRslt = schema.checkDuplicateName(Table.getClassName(), this.cloneTableName);
        if (dupNameRslt.getPassed()) {
            this.doCloneDispatch();
            if (this.isDiagramSet()) {
                this.addToDiagram();
            }
        } else {
            GuiMessageHelper.showInputErrMsg(null, dupNameRslt);
        }
    }

    private void doCloneDispatch() {
        this.clone = this.tableToClone.getShallowClone(this.cloneTableName);
        for (Column column : this.tableToClone.getColumns()) {
            this.clone.add(column.clone());
        }
        for (Index index : this.tableToClone.getIndexes()) {
            this.clone.add(index.clone());
        }
        for (Trigger trigger : this.tableToClone.getTriggers()) {
            this.clone.add(trigger.clone());
        }
        for (ForeignKey fk : this.tableToClone.getFks()) {
            this.clone.add(fk.clone(this.clone));
        }
        PrimaryKey pk = this.tableToClone.getPrimaryKey();
        if (pk != null) {
            PrimaryKey pkClone = pk.clone(pk.getName() + CLONE_NAME_SUFFIX);
            this.clone.setPrimaryKey(pkClone);
        }
        Schema schema = this.tableToClone.getSchema();
        schema.add(this.clone);
    }

    private void addToDiagram() {
        DbTableGlyph currentTableGlyph = (DbTableGlyph)this.diagram.getGlyph(this.tableToClone.getDotNote());
        Point currentPoint = currentTableGlyph.getStart();
        Point newPoint = new Point(currentPoint.x + 20, currentPoint.y + 20);
        DbTableGlyph newTableGlyph = new DbTableGlyph(newPoint, this.clone, this.diagram);
        this.diagram.addGlyph(newTableGlyph);
        DbTableLayoutDisp tableLayoutDisp = new DbTableLayoutDisp();
        ArrayList<Table> tables = new ArrayList<Table>();
        tables.add(this.clone);
        tableLayoutDisp.layoutTables(this.diagram, tables, newPoint);
    }

    @Override
    protected void execute() {
        this.cloneTable();
    }

    private boolean isDiagramSet() {
        return this.diagram != null;
    }

    @Override
    protected void undo() {
        if (this.isDiagramSet()) {
            this.diagram.removeGlyph(this.clone.getDotNote());
        }
        Schema schema = this.clone.getSchema();
        schema.remove(Table.getClassName(), this.clone.getName());
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", "Clone Table");
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.TABLE);
    }

    @Override
    public Command duplicate() {
        CloneTableCommand cmdNew = new CloneTableCommand(this.tableToClone, this.diagram, this.cloneTableName, this.clone);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }
}

