/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db;

import com.harrand.coreclasses.db.DbDataResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.db.TableDataCtrl;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.worker.sql.SqlWorker;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;

public class ServerColumnChecker
implements IThreadObserver {
    private final Set<String> serverColumnNames = new HashSet<String>();
    private final SqlWorker sqlWorker;
    private final String sql;
    private final TableDataCtrl tableDataCtrl;

    public ServerColumnChecker(JdbcConfig config, TableDataCtrl tableDataCtrl, Table table, JButton disabledBtn, JLabel statusLbl) {
        this.tableDataCtrl = tableDataCtrl;
        this.sql = "SELECT * FROM " + config.getForEngNm(table) + " LIMIT 1";
        this.sqlWorker = new SqlWorker();
        this.sqlWorker.setDisabledButton(disabledBtn);
        this.sqlWorker.setStatusLabel(statusLbl);
    }

    public void refreshServerColumns() {
        this.serverColumnNames.clear();
        this.sqlWorker.setExecutingText(StrHelper.REFRESHING_DATA_STR);
        this.sqlWorker.startSqlCmd(this.sql, this);
    }

    public boolean getColumnExistsOnServer(Column column) {
        return this.serverColumnNames.contains(column.getName().toLowerCase());
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        SqlWorker sqlCmdWorker = (SqlWorker)threadWorker;
        DbDataResult dataResult = (DbDataResult)sqlCmdWorker.getResult();
        Object[][] data = dataResult.getData();
        if (dataResult.getPassed()) {
            for (Object item : data[0]) {
                this.serverColumnNames.add(item.toString().toLowerCase());
            }
            this.tableDataCtrl.startGetTableDataDispatch();
        } else {
            String svrMsg = dataResult.getDetail();
            DbDataResult sqlCmdResult = new DbDataResult(false, data, true);
            String fullMsg = "Server Message: " + svrMsg;
            sqlCmdResult.setSummary("Table Column Name Retrieval Error");
            sqlCmdResult.setDetail(fullMsg);
            GuiMessageHelper.showInputErrMsg(null, dataResult);
        }
    }
}

