/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db;

import com.harrand.coreclasses.element.BasicId;
import com.harrand.coreclasses.element.IId;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;

public final class JdbcHelper {
    public static IId buildBasicId(ResultSet rs, String idField, String nameField) throws Exception {
        int id = rs.getInt(idField);
        if (rs.wasNull()) {
            return null;
        }
        String name = rs.getString(nameField);
        if (name == null) {
            return null;
        }
        return new BasicId(id, name);
    }

    public static Integer getIntObj(ResultSet rs, String colName) throws Exception {
        int i = rs.getInt(colName);
        if (rs.wasNull()) {
            return null;
        }
        return new Integer(i);
    }

    public static Double getDoubleObj(ResultSet rs, String colName) throws Exception {
        double d = rs.getDouble(colName);
        if (rs.wasNull()) {
            return null;
        }
        return new Double(d);
    }

    public static Object[][] rsToMatrix(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        ArrayList[] columns = new ArrayList[columnCount];
        for (int col = 1; col <= columnCount; ++col) {
            columns[col - 1] = new ArrayList();
            columns[col - 1].add(rsmd.getColumnName(col));
        }
        int row = 0;
        while (rs.next()) {
            ++row;
            for (int col = 1; col <= columnCount; ++col) {
                Object obj = null;
                try {
                    Float flt;
                    obj = rs.getObject(col);
                    if (rs.wasNull()) {
                        columns[col - 1].add(null);
                        continue;
                    }
                    if (obj instanceof BigDecimal) {
                        BigDecimal dec = (BigDecimal)obj;
                        String str = dec.toString();
                        columns[col - 1].add(str);
                        continue;
                    }
                    if (obj instanceof Float) {
                        flt = (Float)obj;
                        columns[col - 1].add(flt.toString());
                        continue;
                    }
                    if (obj instanceof Byte) {
                        Byte byt = (Byte)obj;
                        columns[col - 1].add(byt.toString());
                        continue;
                    }
                    if (obj instanceof Short) {
                        Short shr = (Short)obj;
                        columns[col - 1].add(shr.toString());
                        continue;
                    }
                    if (obj instanceof Float) {
                        flt = (Float)obj;
                        columns[col - 1].add(flt.toString());
                        continue;
                    }
                    if (obj instanceof Long) {
                        Long lng = (Long)obj;
                        columns[col - 1].add(lng.toString());
                        continue;
                    }
                    if (obj instanceof Integer) {
                        Integer intObj = (Integer)obj;
                        columns[col - 1].add(intObj.toString());
                        continue;
                    }
                    if (obj instanceof Date) {
                        Date sqlDate = (Date)obj;
                        java.util.Date javaDate = new java.util.Date(sqlDate.getTime());
                        String str = DateFormat.getDateInstance(2).format(javaDate);
                        columns[col - 1].add(str);
                        continue;
                    }
                    if (obj instanceof Timestamp) {
                        Timestamp stamp = (Timestamp)obj;
                        String str = DateFormat.getDateTimeInstance(2, 2).format(stamp);
                        columns[col - 1].add(str);
                        continue;
                    }
                    if (obj instanceof String) {
                        String strObj = (String)obj;
                        columns[col - 1].add(strObj);
                        continue;
                    }
                    String strTry = null;
                    try {
                        strTry = rs.getString(col);
                    }
                    catch (Exception e) {
                        LogUtil.logErr("JdbcHelper.could not read JDBC data object: " + obj);
                    }
                    if (strTry != null) {
                        columns[col - 1].add(strTry);
                        continue;
                    }
                    columns[col - 1].add(obj);
                    continue;
                }
                catch (Exception e) {
                    String err = e.getMessage();
                    if (err.indexOf("0000-00-00 00:00:00") < 0) continue;
                    columns[col - 1].add("0000-00-00 00:00:00");
                }
            }
        }
        int rowCount = row + 1;
        Object[][] data = new Object[rowCount][columnCount];
        for (int r = 0; r < rowCount; ++r) {
            for (int c = 0; c < columnCount; ++c) {
                data[r][c] = columns[c].get(r);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNextId(JdbcConfig config, Table table) {
        Connection conn = null;
        int nextId = 0;
        if (config.getDbmsId() != 1) return nextId;
        try {
            String tableName = table.getName();
            String sql = "SELECT (MAX(" + tableName + "id) + 1)" + " FROM " + tableName;
            conn = ConnectionFactory.getConnection(config);
            ResultSet rs = ConnectionFactory.doSql(conn, sql);
            if (rs.next()) {
                nextId = rs.getInt(0);
            }
            ConnectionFactory.close(rs);
            if (conn == null) return nextId;
        }
        catch (Exception e) {
            System.out.println("JdbcHelper.getNextId Error: " + e.getMessage());
            return nextId;
        }
        finally {
            if (conn != null) {
                ConnectionFactory.close(conn);
            }
        }
        ConnectionFactory.close(conn);
        return nextId;
    }

    public static String cleanMySqlConnErrMsg(String rawMsg) {
        String parsePhrase = "MESSAGE: ";
        int msgIdx = rawMsg.indexOf(parsePhrase);
        if (msgIdx < 0) {
            return rawMsg;
        }
        int msgEndIdx = rawMsg.indexOf("\n", msgIdx);
        String onlyMsg = rawMsg.substring(msgIdx + parsePhrase.length(), msgEndIdx);
        return onlyMsg;
    }
}

