/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.dataConversion;

import com.harrand.coreclasses.dataConversion.abstractions.IDataConversion;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class DbDataConversion
implements IDataConversion,
IXmlable {
    private INamed convertee_;
    private INamed parent_;
    private Collector collector_;
    private String conversionValue_;

    public DbDataConversion(INamed convertee, Collector collector, INamed parent, String conversionValue) {
        this.convertee_ = convertee;
        this.collector_ = collector;
        this.parent_ = parent;
        this.conversionValue_ = conversionValue;
    }

    public Element asXml() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(DbDataConversion.getClassName());
        XmlHelper.addElementSimple(doc, element, "Name", this.getName());
        Element elmConvertee = XmlHelper.createElementSimple(doc, "Convertee", "");
        XmlHelper.addElementSimple(doc, elmConvertee, "ClassName", ((Identifiable)this.convertee_).getMapName());
        XmlHelper.addElementSimple(doc, elmConvertee, "Name", this.convertee_.getName());
        element.appendChild(elmConvertee);
        Element elmCollector = XmlHelper.createElementSimple(doc, "Collector", "");
        XmlHelper.addElementSimple(doc, elmCollector, "ClassName", ((Identifiable)((Object)this.collector_)).getMapName());
        Table tbl = (Table)this.collector_;
        String dotNote = tbl.getDotNote();
        XmlHelper.addElementSimple(doc, elmCollector, "Name", dotNote);
        element.appendChild(elmCollector);
        XmlHelper.addElementSimple(doc, element, "Conversion", this.conversionValue_.toString());
        return element;
    }

    public static DbDataConversion fromXml(Element element, Database db) {
        Element elmCollector = XmlHelper.getFirstElementByTagName(element, "Collector");
        String collectorClassName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmCollector, "ClassName"));
        String collectorName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmCollector, "Name"));
        Table lCollector = db.getTableFromDotNote(collectorName);
        Element elmConvertee = XmlHelper.getFirstElementByTagName(element, "Convertee");
        String converteeClassName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmConvertee, "ClassName"));
        String converteeName = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(elmConvertee, "Name"));
        Identifiable lConvertee = lCollector.get(Column.getClassName(), converteeName);
        String lConversion = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "Conversion"));
        return new DbDataConversion(lConvertee, lCollector, db, lConversion);
    }

    @Override
    public INamed getParent() {
        return this.parent_;
    }

    @Override
    public INamed getCollector() {
        return this.collector_;
    }

    @Override
    public Object getConversionValue() {
        return this.conversionValue_;
    }

    @Override
    public INamed getConvertedObject() {
        return this.convertee_;
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    public String getName() {
        return this.collector_.getName() + " - " + this.convertee_.getName();
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept("DbDataConversion.setName() not implemented.");
    }

    @Override
    public Element asXmlElement() {
        return this.asXml();
    }

    public static String getClassName() {
        return "DbDataConversion";
    }

    @Override
    public String getMapName() {
        return DbDataConversion.getClassName();
    }
}

