/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.command.bldr.column;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.SetProperty;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.PkNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import java.util.ArrayList;

public class SetPkCmdBldr {
    private PrimaryKey pk;
    private Table table;
    private Column column;

    public Command getCommand(Table table, Column column) {
        this.pk = table.getPrimaryKey();
        this.table = table;
        this.column = column;
        return this.createCommand();
    }

    private Command createCommand() {
        ArrayList pkColNames = this.pk != null ? this.pk.getKeyColumnNames() : new ArrayList();
        this.addOrRemoveColNm(pkColNames);
        String newPkName = this.getNewPkNm(pkColNames);
        PrimaryKey newPk = !pkColNames.isEmpty() ? new PrimaryKey(newPkName, pkColNames) : null;
        PrimaryKey oldPk = this.table.getPrimaryKey();
        SetProperty cmd = new SetProperty(this.table, oldPk, newPk);
        cmd.setCommandChain(App.getCommandChain());
        return cmd;
    }

    private void addOrRemoveColNm(ArrayList pkColNames) {
        String colName = this.column.getName();
        boolean isColumnInPk = this.isColumnInPk();
        if (isColumnInPk) {
            pkColNames.remove(colName);
        } else {
            pkColNames.add(colName);
        }
    }

    private String getNewPkNm(ArrayList pkColNames) {
        PkNameBldr bldr = (PkNameBldr)DbwNameBldrSvr.instance().getNameBldr("PkNameBldr");
        String newPkName = bldr.getFormedName(this.table.getName(), pkColNames);
        return newPkName;
    }

    private boolean isColumnInPk() {
        boolean isInPk = false;
        if (this.pk != null) {
            isInPk = this.pk.containsColumnName(this.column.getName());
        }
        return isInPk;
    }
}

