/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.undo;

import com.harrand.coreclasses.element.Range;
import com.harrand.coregui.text.TextPanel;
import com.harrand.coregui.text.style.ITextStyleCtrl;
import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.util.LogUtil;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;

public final class SimpleReplaceUndoableEdit
extends AbstractUndoableEdit {
    private String oldText_;
    private String newText_;
    private JTextComponent textComp_;
    private int pos_;
    private BasicUndoEditListener undoEditListener_;
    private ITextStyleCtrl textStyleCtrl_;
    private Document doc_;

    public SimpleReplaceUndoableEdit(TextPanel textPanel, String oldText, String replaceText, int pos) {
        this.init(textPanel.getTextComponent(), textPanel.getUndoEditListener(), textPanel.getTextStyleCtrl(), oldText, replaceText, pos);
    }

    public SimpleReplaceUndoableEdit(JTextComponent txtComp, BasicUndoEditListener undoEditListener, ITextStyleCtrl textStyleCtrl, String oldText, String replaceText, int pos) {
        this.init(txtComp, undoEditListener, textStyleCtrl, oldText, replaceText, pos);
    }

    private void init(JTextComponent txtComp, BasicUndoEditListener undoEditListener, ITextStyleCtrl textStyleCtrl, String oldText, String replaceText, int pos) {
        this.textComp_ = txtComp;
        this.oldText_ = oldText;
        this.newText_ = replaceText;
        this.undoEditListener_ = undoEditListener;
        this.textStyleCtrl_ = textStyleCtrl;
        this.doc_ = this.textComp_.getDocument();
        this.pos_ = pos;
    }

    public void exec() {
        this.replaceText(this.oldText_, this.newText_);
        this.undoEditListener_.addUndoableEdit(this);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.replaceText(this.newText_, this.oldText_);
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        this.replaceText(this.oldText_, this.newText_);
    }

    private void replaceText(String removeText, String insertText) {
        this.doc_.removeUndoableEditListener(this.undoEditListener_);
        try {
            this.doc_.remove(this.pos_, removeText.length());
            this.doc_.insertString(this.pos_, insertText, null);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        this.doc_.addUndoableEditListener(this.undoEditListener_);
        this.textStyleCtrl_.styleRange(new Range(this.pos_, new Integer(insertText.length())));
    }
}

