/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.undo;

import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.util.LogUtil;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotUndoException;

public final class ReplaceTextUndoableEdit
extends AbstractUndoableEdit {
    private String oldText_;
    private String newText_;
    private JTextComponent textComp_;
    private int[] doPositions_;
    private int[] undoPositions_;
    private String[] replacedStrings_;
    private BasicUndoEditListener undoEditListener_;
    private Document doc_;

    public ReplaceTextUndoableEdit(JTextComponent textComp, BasicUndoEditListener undoEditListener, String oldText, String replaceText, List positions) {
        this.textComp_ = textComp;
        this.oldText_ = oldText;
        this.newText_ = replaceText;
        this.undoEditListener_ = undoEditListener;
        this.doc_ = this.textComp_.getDocument();
        this.buildLocationArrays(positions);
    }

    private void buildLocationArrays(List positions) {
        this.doPositions_ = new int[positions.size()];
        this.undoPositions_ = new int[this.doPositions_.length];
        this.replacedStrings_ = new String[this.doPositions_.length];
        int lengthChange = this.newText_.length() - this.oldText_.length();
        for (int i = 0; i < positions.size(); ++i) {
            int position;
            this.doPositions_[i] = position = ((Integer)positions.get(i)).intValue();
            this.undoPositions_[i] = position + i * lengthChange;
            try {
                this.replacedStrings_[i] = this.doc_.getText(position, this.oldText_.length());
                continue;
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
            }
        }
    }

    public void exec() {
        this.replaceText(this.doPositions_, this.oldText_, this.newText_, false);
        this.undoEditListener_.addUndoableEdit(this);
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.replaceText(this.undoPositions_, this.newText_, this.oldText_, true);
    }

    @Override
    public void redo() throws CannotUndoException {
        super.redo();
        this.replaceText(this.doPositions_, this.oldText_, this.newText_, false);
    }

    private void replaceText(int[] positions, String removeText, String insertText, boolean undo) {
        this.doc_.removeUndoableEditListener(this.undoEditListener_);
        for (int i = positions.length - 1; i >= 0; --i) {
            int position = positions[i];
            try {
                this.doc_.remove(position, removeText.length());
                if (undo) {
                    this.doc_.insertString(position, this.replacedStrings_[i], null);
                    continue;
                }
                this.doc_.insertString(position, insertText, null);
                continue;
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
            }
        }
        this.doc_.addUndoableEditListener(this.undoEditListener_);
    }
}

