/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text.style;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.scanner.BasicMultilineScanner;
import com.harrand.coreclasses.text.scanner.EncloseScanner;
import com.harrand.coreclasses.text.scanner.EolScanner;
import com.harrand.coreclasses.text.scanner.IMultilineScanner;
import com.harrand.coreclasses.text.scanner.IScanner;
import com.harrand.coreclasses.text.scanner.ISingleWordScanner;
import com.harrand.coreclasses.text.scanner.NumericScanner;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.text.style.ITextStyleCtrl;
import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.util.Validator;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTextPane;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public final class BasicTextStyleCtrl
implements ITextStyleCtrl {
    private JTextPane textPane_;
    private StyledDocument doc_;
    private BasicUndoEditListener editListener_;
    private String oldText_;
    private String newText_;
    private String changedText_;
    private String oldExamineText_;
    private String newExamineText_;
    private Range updatedRange_;
    private Range eolRange_;
    private boolean insertedFlag_;
    private int preprocessModifiers_;
    private int pos_;
    private int textLengthChange_;
    private List wordScanners_ = new ArrayList();
    private List lineScanners_ = new ArrayList();
    private IMultilineScanner multilineCommentScanner_;
    private String deleteStr_;
    private Map styles_ = new TreeMap();

    public BasicTextStyleCtrl(JTextPane textPane, BasicUndoEditListener editListener, ISingleWordScanner keywordScanner) {
        this.textPane_ = textPane;
        this.doc_ = (StyledDocument)this.textPane_.getDocument();
        this.newText_ = this.oldText_ = this.textPane_.getText();
        this.editListener_ = editListener;
        this.initScanners(keywordScanner);
        this.initStyles();
    }

    @Override
    public void preProcess(KeyEvent evt) {
        this.preprocessModifiers_ = evt.getModifiers();
    }

    @Override
    public void process(KeyEvent evt) {
        char ch;
        int modifiers;
        int keyCode;
        String selectedText;
        block13: {
            block12: {
                this.changedText_ = null;
                this.newText_ = GuiHelper.getTextDocumentText(this.doc_);
                this.insertedFlag_ = true;
                this.pos_ = this.textPane_.getCaretPosition();
                this.updatedRange_ = new Range(this.pos_, this.pos_ + 1);
                selectedText = this.textPane_.getSelectedText();
                keyCode = evt.getKeyCode();
                modifiers = evt.getModifiers() | this.preprocessModifiers_;
                if (keyCode == 127) break block12;
                if (keyCode != 8) break block13;
            }
            if (Validator.isStringValid(this.oldText_)) {
                this.changedText_ = Validator.isStringValid(selectedText) ? selectedText : this.oldText_.substring(this.pos_, this.pos_ + 1);
                this.insertedFlag_ = false;
                this.updatedRange_ = new Range(this.pos_ - 1, this.pos_);
            }
        }
        if (keyCode == 86) {
            if ((modifiers & (0x80 | 2)) != 0) {
                String changeText_ = GuiHelper.getClipboardContents();
                this.updatedRange_ = new Range(this.pos_ - changeText_.length(), this.pos_);
            }
        }
        if (keyCode == 88) {
            if (modifiers == 128) {
                this.changedText_ = selectedText;
            }
        }
        if (keyCode == 10) {
            this.oldText_ = GuiHelper.getTextDocumentText(this.doc_);
            return;
        }
        if (this.changedText_ == null && Character.isDefined(ch = evt.getKeyChar())) {
            StringBuffer sb = new StringBuffer().append(ch);
            this.changedText_ = sb.toString();
        }
        this.eolRange_ = StrHelper.getEolRange(this.newText_, this.updatedRange_);
        if (this.changedText_ != null) {
            this.setExamineTexts(this.insertedFlag_);
            if (!this.checkSectionUpdated()) {
                this.applyStylesDisp(this.eolRange_, true, true, false);
            }
            this.oldText_ = GuiHelper.getTextDocumentText(this.doc_);
        }
    }

    @Override
    public void styleFullText() {
        String fullText;
        this.newText_ = fullText = GuiHelper.getTextDocumentText(this.doc_);
        this.oldText_ = fullText;
        if (this.newText_.length() > 0) {
            this.applyStylesDisp(new Range(0, fullText.length() - 1), true, true, true);
        }
    }

    @Override
    public void styleRange(Range range) {
        if (range.getLength() > 0) {
            String fullText;
            this.newText_ = fullText = GuiHelper.getTextDocumentText(this.doc_);
            this.oldText_ = fullText;
            this.applyStylesDisp(range, true, true, true);
        }
    }

    private void setNewText() {
        StringBuffer sb = new StringBuffer(this.oldText_);
        if (this.insertedFlag_) {
            this.newText_ = sb.insert(this.pos_, this.changedText_).toString();
        } else {
            int changeLength = this.changedText_.length();
            this.newText_ = sb.replace(this.pos_ - changeLength, this.pos_, "").toString();
        }
    }

    private boolean checkSectionUpdated() {
        boolean update = this.multilineCommentScanner_.needsUpdate(this.oldExamineText_) || this.multilineCommentScanner_.needsUpdate(this.newExamineText_);
        String eolText = new String(this.newText_.substring(this.eolRange_.getStart(), this.eolRange_.getEnd()));
        update |= this.multilineCommentScanner_.needsUpdate(eolText);
        if (update |= this.multilineCommentScanner_.openAt(this.newText_, this.pos_)) {
            Range range = this.multilineCommentScanner_.getEffectedRange(this.newText_, this.updatedRange_);
            this.applyStylesDisp(range, true, true, true);
        }
        return update;
    }

    private boolean isInMarkedRange(int wordStart, String word) {
        boolean isMarked = false;
        int end = wordStart + word.length();
        for (int i = wordStart; i < end; ++i) {
            String styleName = GuiHelper.getStyleNameAtPos(this.doc_, i);
            isMarked |= styleName.equals("Comment") || styleName.equals("Literal");
        }
        return isMarked;
    }

    public void applyStylesDisp(Range range, boolean applyWordStyles, boolean applyLineStyles, boolean applyMultilineStyles) {
        ArrayList<IMultilineScanner> applyScanners = new ArrayList<IMultilineScanner>();
        String effectedText = new String(this.newText_.substring(range.getStart(), range.getEnd()));
        this.doc_.removeUndoableEditListener(this.editListener_);
        this.applyStyle("default", range);
        if (applyWordStyles) {
            applyScanners.addAll(this.wordScanners_);
        }
        if (applyLineStyles) {
            applyScanners.addAll(this.lineScanners_);
        }
        if (applyMultilineStyles) {
            applyScanners.add(this.multilineCommentScanner_);
        }
        for (IScanner iScanner : applyScanners) {
            String styleName = iScanner.getStyleName();
            this.applyStyleLoop(styleName, iScanner.getRanges(effectedText, range.getStart()));
        }
        this.doc_.addUndoableEditListener(this.editListener_);
    }

    private void applyStyleLoop(String styleName, List ranges) {
        Style style = (Style)this.styles_.get(styleName);
        Iterator it = ranges.iterator();
        while (it.hasNext()) {
            this.applyStyle(style, (Range)it.next());
        }
    }

    private void applyStyle(String styleName, Range range) {
        Style style = (Style)this.styles_.get(styleName);
        this.applyStyle(style, range);
    }

    private void applyStyle(Style style, Range range) {
        this.doc_.setCharacterAttributes(range.getStart(), range.getLength(), style, true);
    }

    private void setExamineTexts(boolean insertFlag) {
        int changeLength = this.changedText_.length();
        if (insertFlag) {
            int oldPos = this.pos_ - changeLength;
            String oldPrefix = this.getCharStrAt(this.oldText_, oldPos - 1);
            String oldSuffix = this.getCharStrAt(this.oldText_, oldPos);
            this.oldExamineText_ = oldPrefix + oldSuffix;
            this.newExamineText_ = oldPrefix + this.changedText_ + oldSuffix;
        } else {
            int oldPos = this.pos_;
            String oldPrefix = this.getCharStrAt(this.oldText_, this.pos_ - 1);
            String oldSuffix = this.getCharStrAt(this.oldText_, this.pos_ + changeLength);
            this.oldExamineText_ = oldPrefix + this.changedText_ + oldSuffix;
            this.newExamineText_ = oldPrefix + oldSuffix;
        }
    }

    private String getCharStrAt(String fullText, int index) {
        return StrHelper.getSubstringSafe(fullText, index, index + 1);
    }

    private void initScanners(ISingleWordScanner keywordScanner) {
        if (keywordScanner != null) {
            this.wordScanners_.add(keywordScanner);
        }
        this.wordScanners_.add(NumericScanner.instance());
        this.lineScanners_.add(new EncloseScanner("Literal", "\""));
        this.lineScanners_.add(new EncloseScanner("Literal", "'"));
        this.lineScanners_.add(new EolScanner("Comment", "--"));
        this.lineScanners_.add(new EolScanner("Comment", "//"));
        this.multilineCommentScanner_ = new BasicMultilineScanner("Comment", "/*", "*/");
    }

    private void initStyles() {
        String fontFamily = "Monospaced";
        Style defaultStyle = this.textPane_.getStyle("default");
        this.styles_.put("default", defaultStyle);
        StyleConstants.setFontFamily(defaultStyle, fontFamily);
        Style keywordStyle = this.textPane_.addStyle("Keyword", null);
        StyleConstants.setForeground(keywordStyle, Colors.getBlueKeyword());
        StyleConstants.setBold(keywordStyle, true);
        StyleConstants.setFontFamily(keywordStyle, fontFamily);
        this.styles_.put("Keyword", keywordStyle);
        Style commentStyle = this.textPane_.addStyle("Comment", null);
        StyleConstants.setForeground(commentStyle, Colors.getGreenComment());
        StyleConstants.setItalic(commentStyle, true);
        StyleConstants.setFontFamily(commentStyle, fontFamily);
        this.styles_.put("Comment", commentStyle);
        Style literalStyle = this.textPane_.addStyle("Literal", null);
        StyleConstants.setForeground(literalStyle, Colors.getPurpleLiteral());
        StyleConstants.setFontFamily(literalStyle, fontFamily);
        this.styles_.put("Literal", literalStyle);
        Style numberStyle = this.textPane_.addStyle("Number", null);
        StyleConstants.setForeground(numberStyle, Colors.getBlueNumber());
        StyleConstants.setFontFamily(numberStyle, fontFamily);
        this.styles_.put("Number", numberStyle);
        Style errorStyle = this.textPane_.addStyle("Error", null);
        StyleConstants.setForeground(errorStyle, Color.RED);
        StyleConstants.setBold(errorStyle, true);
        StyleConstants.setFontFamily(errorStyle, fontFamily);
        this.styles_.put("Error", errorStyle);
    }
}

