/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text.operation;

import com.harrand.coreclasses.element.Range;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.operation.CommentCtrl;
import com.harrand.coreclasses.text.operation.ITextOperationCtrl;
import com.harrand.coreclasses.text.operation.IndentCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.text.TextPanel;
import com.harrand.coregui.text.style.ITextStyleCtrl;
import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.coregui.undo.SimpleReplaceUndoableEdit;
import javax.swing.JTextPane;
import javax.swing.text.Document;

public final class TextPaneTextOperationCtrl
implements ITextOperationCtrl {
    private TextPanel textPanel_;
    private JTextPane textPane_;
    private Document doc_;
    private BasicUndoEditListener undoableEditListener_;
    private ITextStyleCtrl textStyleCtrl_;
    private CommentCtrl commentCtrl_;
    private IndentCtrl indentCtrl_;

    public TextPaneTextOperationCtrl(TextPanel textPanel, String commentDelimiter, int indentSize) {
        this.textPanel_ = textPanel;
        this.textPane_ = (JTextPane)textPanel.getTextComponent();
        this.undoableEditListener_ = textPanel.getUndoEditListener();
        this.textStyleCtrl_ = textPanel.getTextStyleCtrl();
        this.commentCtrl_ = new CommentCtrl(commentDelimiter);
        this.indentCtrl_ = new IndentCtrl(indentSize);
        this.doc_ = this.textPane_.getDocument();
    }

    @Override
    public Range commentText(int operation) {
        return this.processText(1, operation);
    }

    @Override
    public Range indentText(int operation) {
        return this.processText(0, operation);
    }

    @Override
    public void setIndentSize(int size) {
        this.indentCtrl_.setIndentSize(size);
    }

    @Override
    public int getIndentSize() {
        return this.indentCtrl_.getIndentSize();
    }

    private Range processText(int commandId, int operation) {
        Range range;
        String fullText = GuiHelper.getTextDocumentText(this.doc_);
        if (fullText.length() > 0) {
            int pos = this.textPane_.getCaretPosition();
            int selectionEnd = this.textPane_.getSelectionEnd();
            Range selectionRange = selectionEnd > 0 ? new Range(this.textPane_.getSelectionStart(), this.textPane_.getSelectionEnd()) : new Range(pos, pos);
            Range eolRange = StrHelper.getEolRange(fullText, selectionRange);
            Range effectedRange = fullText.charAt(eolRange.getStart()) == '\n' ? new Range(eolRange.getStart() + 1, eolRange.getEnd()) : eolRange;
            String effectedText = "";
            try {
                effectedText = fullText.substring(effectedRange.getStart(), effectedRange.getEnd());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Range selRangeInEffected = new Range(selectionRange.getStart() - effectedRange.getStart(), new Integer(selectionRange.getLength()));
            String newText = this.getNewText(effectedText, selRangeInEffected, commandId, operation);
            SimpleReplaceUndoableEdit undoableEdit = new SimpleReplaceUndoableEdit(this.textPanel_, effectedText, newText, effectedRange.getStart());
            undoableEdit.exec();
            this.updateSelection(selectionRange, effectedText, newText, commandId);
            range = new Range(effectedRange.getStart(), new Integer(newText.length() - 1));
        } else {
            range = new Range(0, 0);
        }
        return range;
    }

    private String getNewText(String effectedText, Range selRangeInEffected, int commandId, int operation) {
        String newText = null;
        switch (commandId) {
            case 0: {
                newText = this.indentCtrl_.indentText(effectedText, selRangeInEffected, operation);
                break;
            }
            case 1: {
                newText = this.commentCtrl_.commentText(effectedText, operation);
                break;
            }
            default: {
                StrHelper.throwProgExcept("CommandId: " + commandId + " is not supported!");
            }
        }
        return newText;
    }

    private int getLineChangeLength(int commandId) {
        int length = 0;
        switch (commandId) {
            case 0: {
                length = this.indentCtrl_.getIndentSize();
                break;
            }
            case 1: {
                length = this.commentCtrl_.getDelimiter().length();
                break;
            }
            default: {
                StrHelper.throwProgExcept("CommandId: " + commandId + " is not supported!");
            }
        }
        return length;
    }

    private void updateSelection(Range oldSelection, String oldText, String newText, int commandId) {
        int sign;
        int unitLength = this.getLineChangeLength(commandId);
        int textLengthChange = newText.length() - oldText.length();
        int n = sign = textLengthChange >= 0 ? 1 : -1;
        if (oldSelection.getLength() != 0) {
            int newStart = oldSelection.getStart() + sign * unitLength;
            int newEnd = oldSelection.getEnd() + textLengthChange;
            this.textPane_.setSelectionStart(newStart);
            this.textPane_.setSelectionEnd(newEnd);
        } else {
            int newStart;
            int newEnd = newStart = oldSelection.getStart() + textLengthChange;
            this.textPane_.setCaretPosition(newStart);
        }
    }
}

